/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client;

import com.linkedin.r2.transport.common.bridge.common.RequestWithCallback;
import com.linkedin.r2.transport.common.bridge.common.TransportCallback;
import com.linkedin.r2.transport.common.bridge.common.TransportResponseImpl;
import com.linkedin.r2.transport.http.client.Http2FrameListener;
import com.linkedin.r2.transport.http.client.TimeoutAsyncPoolHandle;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Http2UpgradeHandler
extends ChannelDuplexHandler {
    private static final Logger LOG = LoggerFactory.getLogger(Http2UpgradeHandler.class);
    private final String _host;
    private final int _port;
    private final String _path;
    private ChannelPromise _upgradePromise = null;

    public Http2UpgradeHandler(String host, int port, String path) {
        this._host = host;
        this._port = port;
        this._path = path;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this._upgradePromise = ctx.channel().newPromise();
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.OPTIONS, this._path);
        request.headers().add((CharSequence)HttpHeaderNames.HOST, (Object)(this._host + ":" + this._port));
        ctx.writeAndFlush((Object)request);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (!(msg instanceof RequestWithCallback)) {
            ctx.write(msg, promise);
            return;
        }
        this._upgradePromise.addListener(f -> {
            ChannelFuture future = (ChannelFuture)f;
            if (future.isSuccess()) {
                ctx.write(msg, promise);
            } else {
                TimeoutAsyncPoolHandle handle = (TimeoutAsyncPoolHandle)((RequestWithCallback)msg).handle();
                handle.error().release();
                TransportCallback callback = ((RequestWithCallback)msg).callback();
                callback.onResponse(TransportResponseImpl.error((Throwable)future.cause()));
            }
        });
    }

    public void flush(ChannelHandlerContext ctx) throws Exception {
        this._upgradePromise.addListener(f -> {
            ChannelFuture future = (ChannelFuture)f;
            if (future.isSuccess()) {
                ctx.flush();
            }
        });
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        LOG.debug("Received user event {}", evt);
        if (evt == HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_ISSUED) {
            LOG.debug("HTTP/2 clear text upgrade issued");
        } else if (evt == HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_SUCCESSFUL) {
            LOG.debug("HTTP/2 clear text upgrade successful");
        } else if (evt == HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_REJECTED) {
            LOG.error("HTTP/2 clear text upgrade failed");
            this._upgradePromise.setFailure((Throwable)new IllegalStateException("HTTP/2 clear text upgrade failed"));
        } else if (evt == Http2FrameListener.FrameEvent.SETTINGS_FRAME_RECEIVED) {
            LOG.debug("HTTP/2 settings frame received");
            ctx.pipeline().remove((ChannelHandler)this);
            this._upgradePromise.setSuccess();
        }
        ctx.fireUserEventTriggered(evt);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOG.error("HTTP/2 clear text upgrade failed", cause);
        this._upgradePromise.setFailure(cause);
        ctx.fireExceptionCaught(cause);
    }
}

