/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client;

import com.linkedin.r2.transport.http.client.Http2InitializerHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.util.AttributeKey;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ScheduledExecutorService;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Http2ClientPipelineInitializer
extends ChannelInitializer<NioSocketChannel> {
    private static final Logger LOG = LoggerFactory.getLogger(Http2ClientPipelineInitializer.class);
    private final SSLContext _sslContext;
    private final SSLParameters _sslParameters;
    private final ScheduledExecutorService _scheduler;
    private final int _maxHeaderSize;
    private final int _maxChunkSize;
    private final long _maxResponseSize;
    private final long _streamingTimeout;
    public static final AttributeKey<Http2Connection> HTTP2_CONNECTION_ATTR_KEY = AttributeKey.valueOf((String)"Http2Connection");
    public static final AttributeKey<Http2Connection.PropertyKey> CALLBACK_ATTR_KEY = AttributeKey.valueOf((String)"Callback");
    public static final AttributeKey<Http2Connection.PropertyKey> CHANNEL_POOL_HANDLE_ATTR_KEY = AttributeKey.valueOf((String)"Handle");

    public Http2ClientPipelineInitializer(SSLContext sslContext, SSLParameters sslParameters, ScheduledExecutorService scheduler, int maxHeaderSize, int maxChunkSize, long maxResponseSize, long streamingTimeout) {
        if (sslParameters != null) {
            if (sslContext == null) {
                throw new IllegalArgumentException("SSLParameters passed with no SSLContext");
            }
            SSLParameters supportedSSLParameters = sslContext.getSupportedSSLParameters();
            if (sslParameters.getCipherSuites() != null) {
                this.checkContained(supportedSSLParameters.getCipherSuites(), sslParameters.getCipherSuites(), "cipher suite");
            }
            if (sslParameters.getProtocols() != null) {
                this.checkContained(supportedSSLParameters.getProtocols(), sslParameters.getProtocols(), "protocol");
            }
        }
        this._sslContext = sslContext;
        this._sslParameters = sslParameters;
        this._scheduler = scheduler;
        this._maxHeaderSize = maxHeaderSize;
        this._maxChunkSize = maxChunkSize;
        this._maxResponseSize = maxResponseSize;
        this._streamingTimeout = streamingTimeout;
    }

    protected void initChannel(NioSocketChannel channel) throws Exception {
        DefaultHttp2Connection connection = new DefaultHttp2Connection(false);
        channel.attr(HTTP2_CONNECTION_ATTR_KEY).set((Object)connection);
        channel.attr(CALLBACK_ATTR_KEY).set((Object)connection.newKey());
        channel.attr(CHANNEL_POOL_HANDLE_ATTR_KEY).set((Object)connection.newKey());
        Http2InitializerHandler initializerHandler = new Http2InitializerHandler(this._maxHeaderSize, this._maxChunkSize, this._maxResponseSize, this._streamingTimeout, this._scheduler, (Http2Connection)connection, this._sslContext, this._sslParameters);
        channel.pipeline().addLast("initializerHandler", (ChannelHandler)initializerHandler);
    }

    private void checkContained(String[] containingArray, String[] containedArray, String valueName) {
        HashSet<String> containingSet = new HashSet<String>(Arrays.asList(containingArray));
        HashSet<String> containedSet = new HashSet<String>(Arrays.asList(containedArray));
        boolean changed = containedSet.removeAll(containingSet);
        if (!changed) {
            throw new IllegalArgumentException("None of the requested " + valueName + "s: " + containedSet + " are found in SSLContext");
        }
        if (!containedSet.isEmpty()) {
            for (String paramValue : containedSet) {
                LOG.warn("{} {} requested but not found in SSLContext", (Object)valueName, (Object)paramValue);
            }
        }
    }
}

