/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputEntityReader;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.utils.CompressionUtils;

import java.io.File;

/**
 * Input format that breaks the input on newlines, and returns a single column named {@link LinesReader#LINE_COLUMN}.
 */
public class LinesInputFormat implements InputFormat
{
  public static final String TYPE_KEY = "lines";

  @JsonCreator
  public LinesInputFormat()
  {
  }

  @Override
  public boolean isSplittable()
  {
    return false;
  }

  @Override
  public InputEntityReader createReader(InputRowSchema inputRowSchema, InputEntity source, File temporaryDirectory)
  {
    return new LinesReader(inputRowSchema, source);
  }

  @Override
  public long getWeightedSize(String path, long size)
  {
    return size * CompressionUtils.estimatedCompressionFactor(CompressionUtils.Format.fromFileName(path));
  }
}
