/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.RangeSet;
import com.google.common.hash.HashCode;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.AbstractOptimizableDimFilter;
import org.apache.druid.query.filter.BloomKFilter;
import org.apache.druid.query.filter.BloomKFilterHolder;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.druid.query.filter.DruidFloatPredicate;
import org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.druid.query.filter.DruidObjectPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.DruidPredicateMatch;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.FilterTuning;
import org.apache.druid.segment.filter.DimensionPredicateFilter;

public class BloomDimFilter
extends AbstractOptimizableDimFilter
implements DimFilter {
    private final String dimension;
    private final BloomKFilter bloomKFilter;
    private final HashCode hash;
    @Nullable
    private final ExtractionFn extractionFn;
    @Nullable
    private final FilterTuning filterTuning;

    @JsonCreator
    public BloomDimFilter(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="bloomKFilter") BloomKFilterHolder bloomKFilterHolder, @JsonProperty(value="extractionFn") @Nullable ExtractionFn extractionFn, @JsonProperty(value="filterTuning") @Nullable FilterTuning filterTuning) {
        Preconditions.checkArgument((dimension != null ? 1 : 0) != 0, (Object)"dimension must not be null");
        Preconditions.checkNotNull((Object)bloomKFilterHolder);
        this.dimension = dimension;
        this.bloomKFilter = bloomKFilterHolder.getFilter();
        this.hash = bloomKFilterHolder.getFilterHash();
        this.extractionFn = extractionFn;
        this.filterTuning = filterTuning;
    }

    @VisibleForTesting
    public BloomDimFilter(String dimension, BloomKFilterHolder bloomKFilterHolder, @Nullable ExtractionFn extractionFn) {
        this(dimension, bloomKFilterHolder, extractionFn, null);
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(16).appendString(this.dimension).appendByte((byte)-1).appendByteArray(this.extractionFn == null ? new byte[]{} : this.extractionFn.getCacheKey()).appendByte((byte)-1).appendByteArray(this.hash.asBytes()).build();
    }

    public Filter toFilter() {
        return new DimensionPredicateFilter(this.dimension, new DruidPredicateFactory(){

            public DruidObjectPredicate<String> makeStringPredicate() {
                return str -> {
                    if (str == null) {
                        return DruidPredicateMatch.of((boolean)BloomDimFilter.this.bloomKFilter.testBytes(null, 0, 0));
                    }
                    return DruidPredicateMatch.of((boolean)BloomDimFilter.this.bloomKFilter.testString((String)str));
                };
            }

            public DruidLongPredicate makeLongPredicate() {
                return new DruidLongPredicate(){

                    public DruidPredicateMatch applyLong(long input) {
                        return DruidPredicateMatch.of((boolean)BloomDimFilter.this.bloomKFilter.testLong(input));
                    }

                    public DruidPredicateMatch applyNull() {
                        return DruidPredicateMatch.of((boolean)BloomDimFilter.this.bloomKFilter.testBytes(null, 0, 0));
                    }
                };
            }

            public DruidFloatPredicate makeFloatPredicate() {
                return new DruidFloatPredicate(){

                    public DruidPredicateMatch applyFloat(float input) {
                        return DruidPredicateMatch.of((boolean)BloomDimFilter.this.bloomKFilter.testFloat(input));
                    }

                    public DruidPredicateMatch applyNull() {
                        return DruidPredicateMatch.of((boolean)BloomDimFilter.this.bloomKFilter.testBytes(null, 0, 0));
                    }
                };
            }

            public DruidDoublePredicate makeDoublePredicate() {
                return new DruidDoublePredicate(){

                    public DruidPredicateMatch applyDouble(double input) {
                        return DruidPredicateMatch.of((boolean)BloomDimFilter.this.bloomKFilter.testDouble(input));
                    }

                    public DruidPredicateMatch applyNull() {
                        return DruidPredicateMatch.of((boolean)BloomDimFilter.this.bloomKFilter.testBytes(null, 0, 0));
                    }
                };
            }
        }, this.extractionFn, this.filterTuning);
    }

    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @JsonProperty
    public BloomKFilter getBloomKFilter() {
        return this.bloomKFilter;
    }

    @Nullable
    @JsonProperty
    public ExtractionFn getExtractionFn() {
        return this.extractionFn;
    }

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty
    public FilterTuning getFilterTuning() {
        return this.filterTuning;
    }

    public RangeSet<String> getDimensionRangeSet(String dimension) {
        return null;
    }

    public Set<String> getRequiredColumns() {
        return ImmutableSet.of((Object)this.dimension);
    }

    public String toString() {
        return new DimFilter.DimFilterToStringBuilder().appendDimension(this.dimension, this.extractionFn).appendEquals(this.hash.toString()).appendFilterTuning(this.filterTuning).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        BloomDimFilter that = (BloomDimFilter)((Object)o);
        return this.dimension.equals(that.dimension) && this.hash.equals((Object)that.hash) && Objects.equals(this.extractionFn, that.extractionFn) && Objects.equals(this.filterTuning, that.filterTuning);
    }

    public int hashCode() {
        return Objects.hash(this.dimension, this.hash, this.extractionFn, this.filterTuning);
    }
}

