/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1NodeConfigSource;
import io.kubernetes.client.openapi.models.V1NodeConfigSourceBuilder;
import io.kubernetes.client.openapi.models.V1NodeConfigSourceFluentImpl;
import io.kubernetes.client.openapi.models.V1NodeSpec;
import io.kubernetes.client.openapi.models.V1NodeSpecFluent;
import io.kubernetes.client.openapi.models.V1Taint;
import io.kubernetes.client.openapi.models.V1TaintBuilder;
import io.kubernetes.client.openapi.models.V1TaintFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1NodeSpecFluentImpl<A extends V1NodeSpecFluent<A>>
extends BaseFluent<A>
implements V1NodeSpecFluent<A> {
    private V1NodeConfigSourceBuilder configSource;
    private String externalID;
    private String podCIDR;
    private List<String> podCIDRs;
    private String providerID;
    private ArrayList<V1TaintBuilder> taints;
    private Boolean unschedulable;

    public V1NodeSpecFluentImpl() {
    }

    public V1NodeSpecFluentImpl(V1NodeSpec instance) {
        if (instance != null) {
            this.withConfigSource(instance.getConfigSource());
            this.withExternalID(instance.getExternalID());
            this.withPodCIDR(instance.getPodCIDR());
            this.withPodCIDRs(instance.getPodCIDRs());
            this.withProviderID(instance.getProviderID());
            this.withTaints(instance.getTaints());
            this.withUnschedulable(instance.getUnschedulable());
        }
    }

    @Override
    @Deprecated
    public V1NodeConfigSource getConfigSource() {
        return this.configSource != null ? this.configSource.build() : null;
    }

    @Override
    public V1NodeConfigSource buildConfigSource() {
        return this.configSource != null ? this.configSource.build() : null;
    }

    @Override
    public A withConfigSource(V1NodeConfigSource configSource) {
        this._visitables.get("configSource").remove(this.configSource);
        if (configSource != null) {
            this.configSource = new V1NodeConfigSourceBuilder(configSource);
            this._visitables.get("configSource").add(this.configSource);
        } else {
            this.configSource = null;
            this._visitables.get("configSource").remove(this.configSource);
        }
        return (A)this;
    }

    @Override
    public Boolean hasConfigSource() {
        return this.configSource != null;
    }

    @Override
    public V1NodeSpecFluent.ConfigSourceNested<A> withNewConfigSource() {
        return new ConfigSourceNestedImpl();
    }

    @Override
    public V1NodeSpecFluent.ConfigSourceNested<A> withNewConfigSourceLike(V1NodeConfigSource item) {
        return new ConfigSourceNestedImpl(item);
    }

    @Override
    public V1NodeSpecFluent.ConfigSourceNested<A> editConfigSource() {
        return this.withNewConfigSourceLike(this.getConfigSource());
    }

    @Override
    public V1NodeSpecFluent.ConfigSourceNested<A> editOrNewConfigSource() {
        return this.withNewConfigSourceLike(this.getConfigSource() != null ? this.getConfigSource() : new V1NodeConfigSourceBuilder().build());
    }

    @Override
    public V1NodeSpecFluent.ConfigSourceNested<A> editOrNewConfigSourceLike(V1NodeConfigSource item) {
        return this.withNewConfigSourceLike(this.getConfigSource() != null ? this.getConfigSource() : item);
    }

    @Override
    public String getExternalID() {
        return this.externalID;
    }

    @Override
    public A withExternalID(String externalID) {
        this.externalID = externalID;
        return (A)this;
    }

    @Override
    public Boolean hasExternalID() {
        return this.externalID != null;
    }

    @Override
    public String getPodCIDR() {
        return this.podCIDR;
    }

    @Override
    public A withPodCIDR(String podCIDR) {
        this.podCIDR = podCIDR;
        return (A)this;
    }

    @Override
    public Boolean hasPodCIDR() {
        return this.podCIDR != null;
    }

    @Override
    public A addToPodCIDRs(int index, String item) {
        if (this.podCIDRs == null) {
            this.podCIDRs = new ArrayList<String>();
        }
        this.podCIDRs.add(index, item);
        return (A)this;
    }

    @Override
    public A setToPodCIDRs(int index, String item) {
        if (this.podCIDRs == null) {
            this.podCIDRs = new ArrayList<String>();
        }
        this.podCIDRs.set(index, item);
        return (A)this;
    }

    @Override
    public A addToPodCIDRs(String ... items) {
        if (this.podCIDRs == null) {
            this.podCIDRs = new ArrayList<String>();
        }
        for (String item : items) {
            this.podCIDRs.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToPodCIDRs(Collection<String> items) {
        if (this.podCIDRs == null) {
            this.podCIDRs = new ArrayList<String>();
        }
        for (String item : items) {
            this.podCIDRs.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromPodCIDRs(String ... items) {
        for (String item : items) {
            if (this.podCIDRs == null) continue;
            this.podCIDRs.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPodCIDRs(Collection<String> items) {
        for (String item : items) {
            if (this.podCIDRs == null) continue;
            this.podCIDRs.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getPodCIDRs() {
        return this.podCIDRs;
    }

    @Override
    public String getPodCIDR(int index) {
        return this.podCIDRs.get(index);
    }

    @Override
    public String getFirstPodCIDR() {
        return this.podCIDRs.get(0);
    }

    @Override
    public String getLastPodCIDR() {
        return this.podCIDRs.get(this.podCIDRs.size() - 1);
    }

    @Override
    public String getMatchingPodCIDR(Predicate<String> predicate) {
        for (String item : this.podCIDRs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPodCIDR(Predicate<String> predicate) {
        for (String item : this.podCIDRs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPodCIDRs(List<String> podCIDRs) {
        if (podCIDRs != null) {
            this.podCIDRs = new ArrayList<String>();
            for (String item : podCIDRs) {
                this.addToPodCIDRs(item);
            }
        } else {
            this.podCIDRs = null;
        }
        return (A)this;
    }

    @Override
    public A withPodCIDRs(String ... podCIDRs) {
        if (this.podCIDRs != null) {
            this.podCIDRs.clear();
            this._visitables.remove("podCIDRs");
        }
        if (podCIDRs != null) {
            for (String item : podCIDRs) {
                this.addToPodCIDRs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPodCIDRs() {
        return this.podCIDRs != null && !this.podCIDRs.isEmpty();
    }

    @Override
    public String getProviderID() {
        return this.providerID;
    }

    @Override
    public A withProviderID(String providerID) {
        this.providerID = providerID;
        return (A)this;
    }

    @Override
    public Boolean hasProviderID() {
        return this.providerID != null;
    }

    @Override
    public A addToTaints(int index, V1Taint item) {
        if (this.taints == null) {
            this.taints = new ArrayList();
        }
        V1TaintBuilder builder = new V1TaintBuilder(item);
        if (index < 0 || index >= this.taints.size()) {
            this._visitables.get("taints").add(builder);
            this.taints.add(builder);
        } else {
            this._visitables.get("taints").add(index, builder);
            this.taints.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToTaints(int index, V1Taint item) {
        if (this.taints == null) {
            this.taints = new ArrayList();
        }
        V1TaintBuilder builder = new V1TaintBuilder(item);
        if (index < 0 || index >= this.taints.size()) {
            this._visitables.get("taints").add(builder);
            this.taints.add(builder);
        } else {
            this._visitables.get("taints").set(index, builder);
            this.taints.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToTaints(V1Taint ... items) {
        if (this.taints == null) {
            this.taints = new ArrayList();
        }
        for (V1Taint item : items) {
            V1TaintBuilder builder = new V1TaintBuilder(item);
            this._visitables.get("taints").add(builder);
            this.taints.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToTaints(Collection<V1Taint> items) {
        if (this.taints == null) {
            this.taints = new ArrayList();
        }
        for (V1Taint item : items) {
            V1TaintBuilder builder = new V1TaintBuilder(item);
            this._visitables.get("taints").add(builder);
            this.taints.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromTaints(V1Taint ... items) {
        for (V1Taint item : items) {
            V1TaintBuilder builder = new V1TaintBuilder(item);
            this._visitables.get("taints").remove(builder);
            if (this.taints == null) continue;
            this.taints.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTaints(Collection<V1Taint> items) {
        for (V1Taint item : items) {
            V1TaintBuilder builder = new V1TaintBuilder(item);
            this._visitables.get("taints").remove(builder);
            if (this.taints == null) continue;
            this.taints.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromTaints(Predicate<V1TaintBuilder> predicate) {
        if (this.taints == null) {
            return (A)this;
        }
        Iterator<V1TaintBuilder> each = this.taints.iterator();
        Object visitables = this._visitables.get("taints");
        while (each.hasNext()) {
            V1TaintBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1Taint> getTaints() {
        return this.taints != null ? V1NodeSpecFluentImpl.build(this.taints) : null;
    }

    @Override
    public List<V1Taint> buildTaints() {
        return this.taints != null ? V1NodeSpecFluentImpl.build(this.taints) : null;
    }

    @Override
    public V1Taint buildTaint(int index) {
        return this.taints.get(index).build();
    }

    @Override
    public V1Taint buildFirstTaint() {
        return this.taints.get(0).build();
    }

    @Override
    public V1Taint buildLastTaint() {
        return this.taints.get(this.taints.size() - 1).build();
    }

    @Override
    public V1Taint buildMatchingTaint(Predicate<V1TaintBuilder> predicate) {
        for (V1TaintBuilder item : this.taints) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTaint(Predicate<V1TaintBuilder> predicate) {
        for (V1TaintBuilder item : this.taints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTaints(List<V1Taint> taints) {
        if (this.taints != null) {
            this._visitables.get("taints").clear();
        }
        if (taints != null) {
            this.taints = new ArrayList();
            for (V1Taint item : taints) {
                this.addToTaints(item);
            }
        } else {
            this.taints = null;
        }
        return (A)this;
    }

    @Override
    public A withTaints(V1Taint ... taints) {
        if (this.taints != null) {
            this.taints.clear();
            this._visitables.remove("taints");
        }
        if (taints != null) {
            for (V1Taint item : taints) {
                this.addToTaints(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTaints() {
        return this.taints != null && !this.taints.isEmpty();
    }

    @Override
    public V1NodeSpecFluent.TaintsNested<A> addNewTaint() {
        return new TaintsNestedImpl();
    }

    @Override
    public V1NodeSpecFluent.TaintsNested<A> addNewTaintLike(V1Taint item) {
        return new TaintsNestedImpl(-1, item);
    }

    @Override
    public V1NodeSpecFluent.TaintsNested<A> setNewTaintLike(int index, V1Taint item) {
        return new TaintsNestedImpl(index, item);
    }

    @Override
    public V1NodeSpecFluent.TaintsNested<A> editTaint(int index) {
        if (this.taints.size() <= index) {
            throw new RuntimeException("Can't edit taints. Index exceeds size.");
        }
        return this.setNewTaintLike(index, this.buildTaint(index));
    }

    @Override
    public V1NodeSpecFluent.TaintsNested<A> editFirstTaint() {
        if (this.taints.size() == 0) {
            throw new RuntimeException("Can't edit first taints. The list is empty.");
        }
        return this.setNewTaintLike(0, this.buildTaint(0));
    }

    @Override
    public V1NodeSpecFluent.TaintsNested<A> editLastTaint() {
        int index = this.taints.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last taints. The list is empty.");
        }
        return this.setNewTaintLike(index, this.buildTaint(index));
    }

    @Override
    public V1NodeSpecFluent.TaintsNested<A> editMatchingTaint(Predicate<V1TaintBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.taints.size(); ++i) {
            if (!predicate.test(this.taints.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching taints. No match found.");
        }
        return this.setNewTaintLike(index, this.buildTaint(index));
    }

    @Override
    public Boolean getUnschedulable() {
        return this.unschedulable;
    }

    @Override
    public A withUnschedulable(Boolean unschedulable) {
        this.unschedulable = unschedulable;
        return (A)this;
    }

    @Override
    public Boolean hasUnschedulable() {
        return this.unschedulable != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1NodeSpecFluentImpl that = (V1NodeSpecFluentImpl)o;
        if (!Objects.equals(this.configSource, that.configSource)) {
            return false;
        }
        if (!Objects.equals(this.externalID, that.externalID)) {
            return false;
        }
        if (!Objects.equals(this.podCIDR, that.podCIDR)) {
            return false;
        }
        if (!Objects.equals(this.podCIDRs, that.podCIDRs)) {
            return false;
        }
        if (!Objects.equals(this.providerID, that.providerID)) {
            return false;
        }
        if (!Objects.equals(this.taints, that.taints)) {
            return false;
        }
        return Objects.equals(this.unschedulable, that.unschedulable);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.configSource, this.externalID, this.podCIDR, this.podCIDRs, this.providerID, this.taints, this.unschedulable, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.configSource != null) {
            sb.append("configSource:");
            sb.append(this.configSource + ",");
        }
        if (this.externalID != null) {
            sb.append("externalID:");
            sb.append(this.externalID + ",");
        }
        if (this.podCIDR != null) {
            sb.append("podCIDR:");
            sb.append(this.podCIDR + ",");
        }
        if (this.podCIDRs != null && !this.podCIDRs.isEmpty()) {
            sb.append("podCIDRs:");
            sb.append(this.podCIDRs + ",");
        }
        if (this.providerID != null) {
            sb.append("providerID:");
            sb.append(this.providerID + ",");
        }
        if (this.taints != null) {
            sb.append("taints:");
            sb.append(this.taints + ",");
        }
        if (this.unschedulable != null) {
            sb.append("unschedulable:");
            sb.append(this.unschedulable);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withUnschedulable() {
        return this.withUnschedulable(true);
    }

    class ConfigSourceNestedImpl<N>
    extends V1NodeConfigSourceFluentImpl<V1NodeSpecFluent.ConfigSourceNested<N>>
    implements V1NodeSpecFluent.ConfigSourceNested<N>,
    Nested<N> {
        V1NodeConfigSourceBuilder builder;

        ConfigSourceNestedImpl(V1NodeConfigSource item) {
            this.builder = new V1NodeConfigSourceBuilder(this, item);
        }

        ConfigSourceNestedImpl() {
            this.builder = new V1NodeConfigSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1NodeSpecFluentImpl.this.withConfigSource(this.builder.build());
        }

        @Override
        public N endConfigSource() {
            return this.and();
        }
    }

    class TaintsNestedImpl<N>
    extends V1TaintFluentImpl<V1NodeSpecFluent.TaintsNested<N>>
    implements V1NodeSpecFluent.TaintsNested<N>,
    Nested<N> {
        V1TaintBuilder builder;
        int index;

        TaintsNestedImpl(int index, V1Taint item) {
            this.index = index;
            this.builder = new V1TaintBuilder(this, item);
        }

        TaintsNestedImpl() {
            this.index = -1;
            this.builder = new V1TaintBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1NodeSpecFluentImpl.this.setToTaints(this.index, this.builder.build());
        }

        @Override
        public N endTaint() {
            return this.and();
        }
    }
}

