/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.k8s.discovery;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.druid.concurrent.LifecycleLock;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.k8s.discovery.K8sDiscoveryConfig;
import org.apache.druid.k8s.discovery.K8sLeaderElector;
import org.apache.druid.k8s.discovery.K8sLeaderElectorFactory;

public class LeaderElectorAsyncWrapper
implements Closeable {
    private static final Logger LOGGER = new Logger(LeaderElectorAsyncWrapper.class);
    private ExecutorService executor;
    private final AtomicReference<Future> futureRef = new AtomicReference();
    private final K8sLeaderElector k8sLeaderElector;
    private final LifecycleLock lifecycleLock = new LifecycleLock();

    public LeaderElectorAsyncWrapper(String candidateId, String lockResourceName, String lockResourceNamespace, K8sDiscoveryConfig discoveryConfig, K8sLeaderElectorFactory k8sLeaderElectorFactory) {
        Preconditions.checkArgument((boolean)K8sDiscoveryConfig.K8S_RESOURCE_NAME_REGEX.matcher(lockResourceName).matches(), (String)"lockResourceName[%s] must match regex[%s]", (Object)lockResourceName, (Object)K8sDiscoveryConfig.K8S_RESOURCE_NAME_REGEX.pattern());
        LOGGER.info("Creating LeaderElector with candidateId[%s], lockResourceName[%s],  k8sNamespace[%s].", new Object[]{candidateId, lockResourceName, lockResourceNamespace});
        this.k8sLeaderElector = k8sLeaderElectorFactory.create(candidateId, lockResourceNamespace, lockResourceName);
    }

    public void run(Runnable startLeadingHook, Runnable stopLeadingHook) {
        if (!this.lifecycleLock.canStart()) {
            throw new ISE("can't start.", new Object[0]);
        }
        try {
            this.executor = Execs.singleThreaded((String)this.getClass().getSimpleName());
            this.futureRef.set(this.executor.submit(() -> {
                while (this.lifecycleLock.awaitStarted(1L, TimeUnit.MILLISECONDS)) {
                    try {
                        this.k8sLeaderElector.run(startLeadingHook, stopLeadingHook);
                    }
                    catch (Throwable ex) {
                        LOGGER.error(ex, "Exception in K8s LeaderElector.run()", new Object[0]);
                    }
                }
            }));
            this.lifecycleLock.started();
        }
        finally {
            this.lifecycleLock.exitStart();
        }
    }

    @Override
    public void close() {
        if (!this.lifecycleLock.canStop()) {
            throw new ISE("can't stop.", new Object[0]);
        }
        try {
            this.futureRef.get().cancel(true);
            this.executor.shutdownNow();
            if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                LOGGER.warn("Failed to terminate [%s] executor.", new Object[]{this.getClass().getSimpleName()});
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    public String getCurrentLeader() {
        return this.k8sLeaderElector.getCurrentLeader();
    }
}

