/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl.writer;

import java.io.IOException;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DateColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.orc.OrcProto;
import org.apache.orc.TypeDescription;
import org.apache.orc.impl.CryptoUtils;
import org.apache.orc.impl.IntegerWriter;
import org.apache.orc.impl.OutStream;
import org.apache.orc.impl.PositionRecorder;
import org.apache.orc.impl.StreamName;
import org.apache.orc.impl.writer.TreeWriterBase;
import org.apache.orc.impl.writer.WriterContext;
import org.apache.orc.impl.writer.WriterEncryptionVariant;

public class DateTreeWriter
extends TreeWriterBase {
    private final IntegerWriter writer;
    private final boolean isDirectV2;
    private final boolean useProleptic;

    public DateTreeWriter(TypeDescription schema, WriterEncryptionVariant encryption, WriterContext writer) throws IOException {
        super(schema, encryption, writer);
        OutStream out = writer.createStream(new StreamName(this.id, OrcProto.Stream.Kind.DATA, encryption));
        this.isDirectV2 = this.isNewWriteFormat(writer);
        this.writer = this.createIntegerWriter(out, true, this.isDirectV2, writer);
        if (this.rowIndexPosition != null) {
            this.recordPosition(this.rowIndexPosition);
        }
        this.useProleptic = writer.getProlepticGregorian();
    }

    @Override
    public void writeBatch(ColumnVector vector, int offset, int length) throws IOException {
        block9: {
            LongColumnVector vec;
            block8: {
                super.writeBatch(vector, offset, length);
                vec = (LongColumnVector)vector;
                if (vector instanceof DateColumnVector) {
                    ((DateColumnVector)vec).changeCalendar(this.useProleptic, true);
                } else if (this.useProleptic) {
                    throw new IllegalArgumentException("Can't use LongColumnVector to write proleptic dates");
                }
                if (!vector.isRepeating) break block8;
                if (!vector.noNulls && vector.isNull[0]) break block9;
                int value = (int)vec.vector[0];
                this.indexStatistics.updateDate(value);
                if (this.createBloomFilter) {
                    if (this.bloomFilter != null) {
                        this.bloomFilter.addLong(value);
                    }
                    this.bloomFilterUtf8.addLong(value);
                }
                for (int i = 0; i < length; ++i) {
                    this.writer.write(value);
                }
                break block9;
            }
            for (int i = 0; i < length; ++i) {
                if (!vec.noNulls && vec.isNull[i + offset]) continue;
                int value = (int)vec.vector[i + offset];
                this.writer.write(value);
                this.indexStatistics.updateDate(value);
                if (!this.createBloomFilter) continue;
                if (this.bloomFilter != null) {
                    this.bloomFilter.addLong(value);
                }
                this.bloomFilterUtf8.addLong(value);
            }
        }
    }

    @Override
    public void writeStripe(int requiredIndexEntries) throws IOException {
        super.writeStripe(requiredIndexEntries);
        if (this.rowIndexPosition != null) {
            this.recordPosition(this.rowIndexPosition);
        }
    }

    @Override
    void recordPosition(PositionRecorder recorder) throws IOException {
        super.recordPosition(recorder);
        this.writer.getPosition(recorder);
    }

    @Override
    OrcProto.ColumnEncoding.Builder getEncoding() {
        OrcProto.ColumnEncoding.Builder result = super.getEncoding();
        if (this.isDirectV2) {
            result.setKind(OrcProto.ColumnEncoding.Kind.DIRECT_V2);
        } else {
            result.setKind(OrcProto.ColumnEncoding.Kind.DIRECT);
        }
        return result;
    }

    @Override
    public long estimateMemory() {
        return super.estimateMemory() + this.writer.estimateMemory();
    }

    @Override
    public long getRawDataSize() {
        return this.fileStatistics.getNumberOfValues() * (long)JavaDataModel.get().lengthOfDate();
    }

    @Override
    public void flushStreams() throws IOException {
        super.flushStreams();
        this.writer.flush();
    }

    @Override
    public void prepareStripe(int stripeId) {
        super.prepareStripe(stripeId);
        this.writer.changeIv(CryptoUtils.modifyIvForStripe(stripeId));
    }
}

