/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.router;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import org.apache.druid.indexing.overlord.setup.JavaScriptUtil;
import org.apache.druid.js.JavaScriptConfig;
import org.apache.druid.query.Query;
import org.apache.druid.server.router.TieredBrokerConfig;
import org.apache.druid.server.router.TieredBrokerSelectorStrategy;

public class JavaScriptTieredBrokerSelectorStrategy
implements TieredBrokerSelectorStrategy {
    private final String function;
    private SelectorFunction fnSelector;

    @JsonCreator
    public JavaScriptTieredBrokerSelectorStrategy(@JsonProperty(value="function") String fn, @JacksonInject JavaScriptConfig config) {
        Preconditions.checkNotNull((Object)fn, (Object)"function must not be null");
        Preconditions.checkState((boolean)config.isEnabled(), (Object)"JavaScript is disabled");
        this.function = fn;
    }

    public Optional<String> getBrokerServiceName(TieredBrokerConfig config, Query query) {
        this.fnSelector = this.fnSelector == null ? (SelectorFunction)JavaScriptUtil.compileSelectorFunction(SelectorFunction.class, (String)this.function) : this.fnSelector;
        return Optional.fromNullable((Object)this.fnSelector.apply(config, query));
    }

    @JsonProperty
    public String getFunction() {
        return this.function;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaScriptTieredBrokerSelectorStrategy that = (JavaScriptTieredBrokerSelectorStrategy)o;
        return this.function.equals(that.function);
    }

    public int hashCode() {
        return this.function.hashCode();
    }

    public String toString() {
        return "JavascriptTieredBrokerSelectorStrategy{function='" + this.function + "'}";
    }

    public static interface SelectorFunction {
        public String apply(TieredBrokerConfig var1, Query var2);
    }
}

