/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.scheduledbatch;

import javax.annotation.Nullable;
import org.apache.druid.indexing.overlord.DataSourceMetadata;
import org.apache.druid.indexing.overlord.supervisor.Supervisor;
import org.apache.druid.indexing.overlord.supervisor.SupervisorReport;
import org.apache.druid.indexing.overlord.supervisor.SupervisorStateManager;
import org.apache.druid.indexing.scheduledbatch.ScheduledBatchSupervisorSpec;
import org.apache.druid.indexing.scheduledbatch.ScheduledBatchSupervisorStatus;
import org.apache.druid.indexing.scheduledbatch.ScheduledBatchTaskManager;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.logger.Logger;

public class ScheduledBatchSupervisor
implements Supervisor {
    private static final Logger log = new Logger(ScheduledBatchSupervisor.class);
    private final ScheduledBatchSupervisorSpec supervisorSpec;
    private final ScheduledBatchTaskManager batchTaskManager;

    public ScheduledBatchSupervisor(ScheduledBatchSupervisorSpec supervisorSpec, ScheduledBatchTaskManager batchTaskManager) {
        this.supervisorSpec = supervisorSpec;
        this.batchTaskManager = batchTaskManager;
    }

    public void start() {
        if (this.supervisorSpec.isSuspended()) {
            this.batchTaskManager.stopScheduledIngestion(this.supervisorSpec.getId());
        } else {
            this.batchTaskManager.startScheduledIngestion(this.supervisorSpec.getId(), this.supervisorSpec.getDataSources().get(0), this.supervisorSpec.getSchedulerConfig(), this.supervisorSpec.getSpec());
        }
    }

    public void stop(boolean stopGracefully) {
        this.batchTaskManager.stopScheduledIngestion(this.supervisorSpec.getId());
    }

    public SupervisorReport<ScheduledBatchSupervisorStatus> getStatus() {
        return new SupervisorReport(this.supervisorSpec.getId(), DateTimes.nowUtc(), (Object)this.batchTaskManager.getSupervisorStatus(this.supervisorSpec.getId()));
    }

    public SupervisorStateManager.State getState() {
        if (this.supervisorSpec.isSuspended()) {
            return State.SUSPENDED;
        }
        return State.RUNNING;
    }

    public void reset(@Nullable DataSourceMetadata dataSourceMetadata) {
    }

    public static enum State implements SupervisorStateManager.State
    {
        RUNNING(true),
        SUSPENDED(true);

        private final boolean healthy;

        private State(boolean healthy) {
            this.healthy = healthy;
        }

        public boolean isFirstRunOnly() {
            return false;
        }

        public boolean isHealthy() {
            return this.healthy;
        }
    }
}

