/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Set;
import org.apache.druid.common.utils.IdUtils;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionToolbox;
import org.apache.druid.indexing.common.actions.UpgradedFromSegmentsResponse;
import org.apache.druid.indexing.common.task.Task;

public class RetrieveUpgradedFromSegmentIdsAction
implements TaskAction<UpgradedFromSegmentsResponse> {
    private final String dataSource;
    private final Set<String> segmentIds;

    @JsonCreator
    public RetrieveUpgradedFromSegmentIdsAction(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="segmentIds") Set<String> segmentIds) {
        this.dataSource = dataSource;
        this.segmentIds = segmentIds;
        IdUtils.getValidSegmentIds((String)dataSource, segmentIds);
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty
    public Set<String> getSegmentIds() {
        return this.segmentIds;
    }

    @Override
    public TypeReference<UpgradedFromSegmentsResponse> getReturnTypeReference() {
        return new TypeReference<UpgradedFromSegmentsResponse>(){};
    }

    @Override
    public UpgradedFromSegmentsResponse perform(Task task, TaskActionToolbox toolbox) {
        return new UpgradedFromSegmentsResponse(toolbox.getIndexerMetadataStorageCoordinator().retrieveUpgradedFromSegmentIds(this.dataSource, this.segmentIds));
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{dataSource='" + this.dataSource + "', segmentIds=" + String.valueOf(this.segmentIds) + "}";
    }
}

