/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.loading.LeastBytesUsedStorageLocationSelectorStrategy;
import org.apache.druid.segment.loading.SegmentCacheManager;
import org.apache.druid.segment.loading.SegmentLoaderConfig;
import org.apache.druid.segment.loading.SegmentLocalCacheManager;
import org.apache.druid.segment.loading.StorageLocationConfig;
import org.apache.druid.segment.loading.StorageLocationSelectorStrategy;

public class SegmentCacheManagerFactory {
    private final IndexIO indexIO;
    private final ObjectMapper jsonMapper;

    @Inject
    public SegmentCacheManagerFactory(IndexIO indexIO, @Json ObjectMapper mapper) {
        this.indexIO = indexIO;
        this.jsonMapper = mapper;
    }

    public SegmentCacheManager manufacturate(File storageDir) {
        SegmentLoaderConfig loaderConfig = new SegmentLoaderConfig().withLocations(Collections.singletonList(new StorageLocationConfig(storageDir, null, null)));
        List storageLocations = loaderConfig.toStorageLocations();
        return new SegmentLocalCacheManager(storageLocations, loaderConfig, (StorageLocationSelectorStrategy)new LeastBytesUsedStorageLocationSelectorStrategy(storageLocations), this.indexIO, this.jsonMapper);
    }
}

