/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.jdbc;

import com.google.common.base.Optional;
import java.sql.Array;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import org.apache.calcite.avatica.AvaticaUtils;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.SqlType;
import org.apache.calcite.avatica.jdbc.JdbcMeta;
import org.apache.calcite.avatica.jdbc.StatementInfo;
import org.apache.calcite.avatica.util.DateTimeUtils;

class JdbcResultSet
extends Meta.MetaResultSet {
    protected JdbcResultSet(String connectionId, int statementId, boolean ownStatement, Meta.Signature signature, Meta.Frame firstFrame) {
        this(connectionId, statementId, ownStatement, signature, firstFrame, -1L);
    }

    protected JdbcResultSet(String connectionId, int statementId, boolean ownStatement, Meta.Signature signature, Meta.Frame firstFrame, long updateCount) {
        super(connectionId, statementId, ownStatement, signature, firstFrame, updateCount);
    }

    public static JdbcResultSet create(String connectionId, int statementId, ResultSet resultSet) {
        return JdbcResultSet.create(connectionId, statementId, resultSet, -2);
    }

    public static JdbcResultSet create(String connectionId, int statementId, ResultSet resultSet, int maxRowCount) {
        try {
            Meta.Signature sig = JdbcMeta.signature(resultSet.getMetaData());
            return JdbcResultSet.create(connectionId, statementId, resultSet, maxRowCount, sig);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static JdbcResultSet create(String connectionId, int statementId, ResultSet resultSet, int maxRowCount, Meta.Signature signature) {
        try {
            Calendar calendar = DateTimeUtils.calendar();
            int fetchRowCount = maxRowCount == -2 ? -1 : ((long)maxRowCount < 0L ? 100 : (maxRowCount > 100 ? 100 : maxRowCount));
            Meta.Frame firstFrame = JdbcResultSet.frame(null, resultSet, 0L, fetchRowCount, calendar, (Optional<Meta.Signature>)Optional.of((Object)signature));
            if (firstFrame.done) {
                resultSet.close();
            }
            return new JdbcResultSet(connectionId, statementId, true, signature, firstFrame);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static JdbcResultSet empty(String connectionId, int statementId, Meta.Signature signature) {
        return new JdbcResultSet(connectionId, statementId, true, signature, Meta.Frame.EMPTY);
    }

    public static JdbcResultSet count(String connectionId, int statementId, int updateCount) {
        return new JdbcResultSet(connectionId, statementId, true, null, null, updateCount);
    }

    static Meta.Frame frame(StatementInfo info, ResultSet resultSet, long offset, int fetchMaxRowCount, Calendar calendar, Optional<Meta.Signature> sig) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        int columnCount = metaData.getColumnCount();
        int[] types = new int[columnCount];
        HashSet<Integer> arrayOffsets = new HashSet<Integer>();
        for (int i = 0; i < types.length; ++i) {
            types[i] = metaData.getColumnType(i + 1);
            if (2003 != types[i]) continue;
            arrayOffsets.add(i);
        }
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        boolean done = fetchMaxRowCount == 0;
        for (int i = 0; fetchMaxRowCount < 0 || i < fetchMaxRowCount; ++i) {
            boolean hasRow = null != info ? info.next() : resultSet.next();
            if (!hasRow) {
                done = true;
                resultSet.close();
                break;
            }
            Object[] columns = new Object[columnCount];
            for (int j = 0; j < columnCount; ++j) {
                Array array;
                columns[j] = JdbcResultSet.getValue(resultSet, types[j], j, calendar);
                if (!arrayOffsets.contains(j) || null == (array = resultSet.getArray(j + 1)) || !sig.isPresent()) continue;
                ColumnMetaData columnMetaData = (ColumnMetaData)((Meta.Signature)sig.get()).columns.get(j);
                ColumnMetaData.ArrayType arrayType = (ColumnMetaData.ArrayType)columnMetaData.type;
                SqlType componentSqlType = SqlType.valueOf((int)array.getBaseType());
                ColumnMetaData.Rep rep = ColumnMetaData.Rep.serialRepOf((SqlType)componentSqlType);
                ColumnMetaData.ScalarType componentType = ColumnMetaData.scalar((int)array.getBaseType(), (String)array.getBaseTypeName(), (ColumnMetaData.Rep)rep);
                arrayType.updateComponentType((ColumnMetaData.AvaticaType)componentType);
                arrayOffsets.remove(j);
            }
            rows.add(columns);
        }
        return new Meta.Frame(offset, done, rows);
    }

    private static Object getValue(ResultSet resultSet, int type, int j, Calendar calendar) throws SQLException {
        switch (type) {
            case -5: {
                long aLong = resultSet.getLong(j + 1);
                return aLong == 0L && resultSet.wasNull() ? null : Long.valueOf(aLong);
            }
            case 4: {
                int anInt = resultSet.getInt(j + 1);
                return anInt == 0 && resultSet.wasNull() ? null : Integer.valueOf(anInt);
            }
            case 5: {
                short aShort = resultSet.getShort(j + 1);
                return aShort == 0 && resultSet.wasNull() ? null : Short.valueOf(aShort);
            }
            case -6: {
                byte aByte = resultSet.getByte(j + 1);
                return aByte == 0 && resultSet.wasNull() ? null : Byte.valueOf(aByte);
            }
            case 6: 
            case 8: {
                double aDouble = resultSet.getDouble(j + 1);
                return aDouble == 0.0 && resultSet.wasNull() ? null : Double.valueOf(aDouble);
            }
            case 7: {
                float aFloat = resultSet.getFloat(j + 1);
                return (double)aFloat == 0.0 && resultSet.wasNull() ? null : Float.valueOf(aFloat);
            }
            case 91: {
                Date aDate = resultSet.getDate(j + 1, calendar);
                return aDate == null ? null : Integer.valueOf((int)(aDate.getTime() / 86400000L));
            }
            case 92: {
                Time aTime = resultSet.getTime(j + 1, calendar);
                return aTime == null ? null : Integer.valueOf((int)(aTime.getTime() % 86400000L));
            }
            case 93: {
                Timestamp aTimestamp = resultSet.getTimestamp(j + 1, calendar);
                return aTimestamp == null ? null : Long.valueOf(aTimestamp.getTime());
            }
            case 2003: {
                Array array = resultSet.getArray(j + 1);
                if (null == array) {
                    return null;
                }
                try {
                    return JdbcResultSet.extractUsingResultSet(array, calendar);
                }
                catch (UnsupportedOperationException | SQLFeatureNotSupportedException e) {
                    return JdbcResultSet.extractUsingArray(array, calendar);
                }
            }
            case 2002: {
                Struct struct = resultSet.getObject(j + 1, Struct.class);
                Object[] attrs = struct.getAttributes();
                ArrayList<Object> list = new ArrayList<Object>(attrs.length);
                for (Object o : attrs) {
                    list.add(o);
                }
                return list;
            }
        }
        return resultSet.getObject(j + 1);
    }

    static List<?> extractUsingResultSet(Array array, Calendar calendar) throws SQLException {
        ResultSet arrayValues = array.getResultSet();
        TreeMap<Integer, Object> map = new TreeMap<Integer, Object>();
        while (arrayValues.next()) {
            map.put(arrayValues.getInt(1), JdbcResultSet.getValue(arrayValues, array.getBaseType(), 1, calendar));
        }
        return new ArrayList(map.values());
    }

    static List<?> extractUsingArray(Array array, Calendar calendar) throws SQLException {
        Object o = array.getArray();
        if (o instanceof List) {
            return (List)o;
        }
        return AvaticaUtils.primitiveList((Object)o);
    }
}

