/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.event;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.metrics.EventTypeMetrics;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.MonotonicClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class EventDispatcher<T extends Event>
extends AbstractService
implements EventHandler<T> {
    private final EventHandler<T> handler;
    private final BlockingQueue<T> eventQueue = new LinkedBlockingDeque<T>();
    private final Thread eventProcessor;
    private volatile boolean stopped = false;
    private boolean shouldExitOnError = true;
    private EventTypeMetrics metrics;
    private static final Logger LOG = LoggerFactory.getLogger(EventDispatcher.class);
    private static final Marker FATAL = MarkerFactory.getMarker((String)"FATAL");
    private Clock clock = new MonotonicClock();

    public EventDispatcher(EventHandler<T> handler, String name) {
        super(name);
        this.handler = handler;
        this.eventProcessor = new Thread(new EventProcessor());
        this.eventProcessor.setName(this.getName() + ":Event Processor");
    }

    @Override
    protected void serviceStart() throws Exception {
        this.eventProcessor.start();
        super.serviceStart();
    }

    @Override
    protected void serviceStop() throws Exception {
        this.stopped = true;
        this.eventProcessor.interrupt();
        try {
            this.eventProcessor.join();
        }
        catch (InterruptedException e) {
            throw new YarnRuntimeException(e);
        }
        super.serviceStop();
    }

    @Override
    public void handle(T event) {
        try {
            int remCapacity;
            int qSize = this.eventQueue.size();
            if (qSize != 0 && qSize % 1000 == 0) {
                LOG.info("Size of " + this.getName() + " event-queue is " + qSize);
            }
            if ((remCapacity = this.eventQueue.remainingCapacity()) < 1000) {
                LOG.info("Very low remaining capacity on " + this.getName() + "event queue: " + remCapacity);
            }
            this.eventQueue.put(event);
        }
        catch (InterruptedException e) {
            LOG.info("Interrupted. Trying to exit gracefully.");
        }
    }

    @VisibleForTesting
    public void disableExitOnError() {
        this.shouldExitOnError = false;
    }

    protected long getEventProcessorId() {
        return this.eventProcessor.getId();
    }

    protected boolean isStopped() {
        return this.stopped;
    }

    public void setMetrics(EventTypeMetrics metrics) {
        this.metrics = metrics;
    }

    private final class EventProcessor
    implements Runnable {
        private EventProcessor() {
        }

        @Override
        public void run() {
            while (!EventDispatcher.this.stopped && !Thread.currentThread().isInterrupted()) {
                Event event;
                try {
                    event = (Event)EventDispatcher.this.eventQueue.take();
                }
                catch (InterruptedException e) {
                    LOG.error("Returning, interrupted : " + e);
                    return;
                }
                try {
                    if (EventDispatcher.this.metrics != null) {
                        long startTime = EventDispatcher.this.clock.getTime();
                        EventDispatcher.this.handler.handle(event);
                        EventDispatcher.this.metrics.increment(event.getType(), EventDispatcher.this.clock.getTime() - startTime);
                        continue;
                    }
                    EventDispatcher.this.handler.handle(event);
                }
                catch (Throwable t) {
                    if (EventDispatcher.this.stopped) {
                        LOG.warn("Exception during shutdown: ", t);
                        break;
                    }
                    LOG.error(FATAL, "Error in handling event type " + event.getType() + " to the Event Dispatcher", t);
                    if (!EventDispatcher.this.shouldExitOnError || ShutdownHookManager.get().isShutdownInProgress()) continue;
                    LOG.info("Exiting, bbye..");
                    System.exit(-1);
                }
            }
        }
    }
}

