/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.virtual.ExpressionPlan;

public class ExpressionPlanner {
    private ExpressionPlanner() {
    }

    public static ExpressionPlan plan(ColumnInspector inspector, Expr expression) {
        boolean supportsVector;
        boolean shouldComputeOutput;
        String column;
        ColumnCapabilities capabilities;
        Expr.BindingAnalysis analysis = expression.analyzeInputs();
        EnumSet<ExpressionPlan.Trait> traits = EnumSet.noneOf(ExpressionPlan.Trait.class);
        HashSet<String> noCapabilities = new HashSet<String>();
        HashSet<String> maybeMultiValued = new HashSet<String>();
        Object needsApplied = ImmutableList.of();
        ColumnType singleInputType = null;
        ExpressionType outputType = null;
        Set<String> columns = analysis.getRequiredBindings();
        if (columns.isEmpty()) {
            traits.add(ExpressionPlan.Trait.CONSTANT);
        } else if (expression.isIdentifier()) {
            traits.add(ExpressionPlan.Trait.IDENTIFIER);
        } else if (columns.size() == 1 && (capabilities = inspector.getColumnCapabilities(column = (String)Iterables.getOnlyElement(columns))) != null && !analysis.hasInputArrays() && !analysis.isOutputArray()) {
            boolean isSingleInputMappable = false;
            boolean isSingleInputScalar = capabilities.hasMultipleValues().isFalse();
            if (capabilities.is(ValueType.STRING)) {
                isSingleInputScalar = isSingleInputScalar && capabilities.isDictionaryEncoded().isTrue();
                boolean bl = isSingleInputMappable = capabilities.isDictionaryEncoded().isTrue() && !capabilities.hasMultipleValues().isUnknown();
            }
            if (isSingleInputScalar || isSingleInputMappable) {
                singleInputType = capabilities.toColumnType();
                if (isSingleInputScalar) {
                    traits.add(ExpressionPlan.Trait.SINGLE_INPUT_SCALAR);
                }
                if (isSingleInputMappable) {
                    traits.add(ExpressionPlan.Trait.SINGLE_INPUT_MAPPABLE);
                }
            }
        }
        if (ExpressionPlan.none(traits, ExpressionPlan.Trait.SINGLE_INPUT_SCALAR, ExpressionPlan.Trait.CONSTANT, ExpressionPlan.Trait.IDENTIFIER)) {
            HashSet<String> definitelyMultiValued = new HashSet<String>();
            HashSet<String> definitelyArray = new HashSet<String>();
            for (String column2 : analysis.getRequiredBindings()) {
                ColumnCapabilities capabilities2 = inspector.getColumnCapabilities(column2);
                if (capabilities2 != null) {
                    if (capabilities2.isArray()) {
                        definitelyArray.add(column2);
                        continue;
                    }
                    if (capabilities2.is(ValueType.STRING) && capabilities2.hasMultipleValues().isTrue()) {
                        definitelyMultiValued.add(column2);
                        continue;
                    }
                    if (!capabilities2.is(ValueType.STRING) || !capabilities2.hasMultipleValues().isMaybeTrue() || analysis.getArrayBindings().contains(column2)) continue;
                    maybeMultiValued.add(column2);
                    continue;
                }
                noCapabilities.add(column2);
            }
            needsApplied = columns.stream().filter(c -> !definitelyArray.contains(c) && definitelyMultiValued.contains(c) && !analysis.getArrayBindings().contains(c)).collect(Collectors.toList());
            if (analysis.hasInputArrays()) {
                traits.add(ExpressionPlan.Trait.NON_SCALAR_INPUTS);
            }
            if (!noCapabilities.isEmpty()) {
                traits.add(ExpressionPlan.Trait.UNKNOWN_INPUTS);
            }
            if (!maybeMultiValued.isEmpty()) {
                traits.add(ExpressionPlan.Trait.INCOMPLETE_INPUTS);
            }
            if (!needsApplied.isEmpty()) {
                traits.add(ExpressionPlan.Trait.NEEDS_APPLIED);
            }
        }
        if (shouldComputeOutput = ExpressionPlan.none(traits, ExpressionPlan.Trait.UNKNOWN_INPUTS, ExpressionPlan.Trait.INCOMPLETE_INPUTS)) {
            outputType = expression.getOutputType(inspector);
        }
        if (analysis.isOutputArray() || outputType != null && outputType.isArray()) {
            traits.add(ExpressionPlan.Trait.NON_SCALAR_OUTPUT);
            traits.remove((Object)ExpressionPlan.Trait.SINGLE_INPUT_SCALAR);
            traits.remove((Object)ExpressionPlan.Trait.SINGLE_INPUT_MAPPABLE);
        }
        if ((supportsVector = ExpressionPlan.none(traits, ExpressionPlan.Trait.INCOMPLETE_INPUTS, ExpressionPlan.Trait.NEEDS_APPLIED)) && expression.canVectorize(inspector)) {
            outputType = expression.getOutputType(inspector);
            traits.add(ExpressionPlan.Trait.VECTORIZABLE);
        }
        return new ExpressionPlan(inspector, expression, analysis, traits, outputType, singleInputType, (Set<String>)Sets.union(noCapabilities, maybeMultiValued), (List<String>)needsApplied);
    }
}

