/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.query.policy.PolicyEnforcer;
import org.apache.druid.segment.ReferenceCountedObjectProvider;
import org.apache.druid.segment.ReferenceCountingCloseableObject;
import org.apache.druid.segment.Segment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.utils.CloseableUtils;
import org.joda.time.Interval;

public class ReferenceCountedSegmentProvider
extends ReferenceCountingCloseableObject<Segment>
implements ReferenceCountedObjectProvider<Segment> {
    public static ReferenceCountedSegmentProvider of(Segment segment) {
        return new ReferenceCountedSegmentProvider(segment);
    }

    public static Optional<Segment> unmanaged(Segment segment) {
        return Optional.of(new UnmanagedReference(segment));
    }

    public static Optional<Segment> wrapCloseable(LeafReference segment, Closeable closeable) {
        return Optional.of(new CloseableWrappedReference(segment, closeable));
    }

    public ReferenceCountedSegmentProvider(Segment baseSegment) {
        super(baseSegment);
        if (baseSegment instanceof ReferenceClosingSegment) {
            throw DruidException.defensive("Cannot use a ReferenceClosingSegment[%s] as baseSegment for a ReferenceCountedSegmentProvider", baseSegment.getDebugString());
        }
    }

    @Nullable
    public Segment getBaseSegment() {
        return !this.isClosed() ? (Segment)this.baseObject : null;
    }

    @Override
    public Optional<Segment> acquireReference() {
        Optional<Closeable> reference = this.incrementReferenceAndDecrementOnceCloseable();
        return reference.map(x$0 -> new ReferenceClosingSegment((Closeable)x$0));
    }

    public static final class UnmanagedReference
    extends LeafReference {
        public UnmanagedReference(Segment delegate) {
            super(delegate);
        }

        @Override
        @Nullable
        public <T> T as(@Nonnull Class<T> clazz) {
            return this.baseSegment.as(clazz);
        }

        @Override
        public void close() {
        }
    }

    public static final class CloseableWrappedReference
    extends LeafReference {
        private final Closeable closeable;

        public CloseableWrappedReference(LeafReference delegate, Closeable closeable) {
            super(delegate);
            this.closeable = closeable;
        }

        @Override
        @Nullable
        public <T> T as(@Nonnull Class<T> clazz) {
            return this.baseSegment.as(clazz);
        }

        @Override
        public void close() throws IOException {
            CloseableUtils.closeAll(this.baseSegment, this.closeable);
        }
    }

    public static abstract class LeafReference
    implements Segment {
        protected final Segment baseSegment;

        public LeafReference(Segment baseSegment) {
            this.baseSegment = baseSegment;
        }

        @Override
        @Nullable
        public SegmentId getId() {
            return this.baseSegment.getId();
        }

        @Override
        public Interval getDataInterval() {
            return this.baseSegment.getDataInterval();
        }

        @Override
        public boolean isTombstone() {
            return this.baseSegment.isTombstone();
        }

        @Override
        public String getDebugString() {
            return this.baseSegment.getDebugString();
        }

        @Override
        public void validateOrElseThrow(PolicyEnforcer policyEnforcer) {
            policyEnforcer.validateOrElseThrow(this.baseSegment, null);
        }
    }

    public final class ReferenceClosingSegment
    extends LeafReference {
        private final Closeable referenceCloseable;
        private final AtomicBoolean isClosed;

        private ReferenceClosingSegment(Closeable referenceCloseable) {
            super((Segment)ReferenceCountedSegmentProvider.this.baseObject);
            this.isClosed = new AtomicBoolean(false);
            this.referenceCloseable = referenceCloseable;
        }

        @Override
        @Nullable
        public <T> T as(@Nonnull Class<T> clazz) {
            if (this.isClosed.get()) {
                throw DruidException.defensive("Segment[%s] reference is already released, cannot get[%s]", ((Segment)ReferenceCountedSegmentProvider.this.baseObject).getId(), clazz);
            }
            return ((Segment)ReferenceCountedSegmentProvider.this.baseObject).as(clazz);
        }

        @Override
        public void close() throws IOException {
            if (this.isClosed.compareAndSet(false, true)) {
                this.referenceCloseable.close();
            }
        }

        @VisibleForTesting
        public ReferenceCountedSegmentProvider getProvider() {
            return ReferenceCountedSegmentProvider.this;
        }
    }
}

