/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.firstlast;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.query.aggregation.SerializablePairLongFloat;
import org.apache.druid.query.aggregation.firstlast.FirstLastUtils;
import org.apache.druid.query.aggregation.firstlast.FirstLastVectorAggregator;
import org.apache.druid.query.aggregation.firstlast.SelectionPredicate;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;

public class FloatFirstLastVectorAggregator
extends FirstLastVectorAggregator<Float, SerializablePairLongFloat> {
    private final SelectionPredicate selectionPredicate;

    protected FloatFirstLastVectorAggregator(VectorValueSelector timeSelector, VectorObjectSelector objectSelector, SelectionPredicate selectionPredicate) {
        super(timeSelector, null, objectSelector, selectionPredicate);
        this.selectionPredicate = selectionPredicate;
    }

    protected FloatFirstLastVectorAggregator(VectorValueSelector timeSelector, VectorValueSelector valueSelector, SelectionPredicate selectionPredicate) {
        super(timeSelector, valueSelector, null, selectionPredicate);
        this.selectionPredicate = selectionPredicate;
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        buf.putLong(position, this.selectionPredicate.initValue());
        buf.put(position + 8, (byte)1);
        buf.putFloat(position + 9, 0.0f);
    }

    @Override
    @Nullable
    public Object get(ByteBuffer buf, int position) {
        long time = buf.getLong(position);
        if (buf.get(position + 8) == 1) {
            return new SerializablePairLongFloat(time, null);
        }
        return new SerializablePairLongFloat(time, Float.valueOf(buf.getFloat(position + 9)));
    }

    @Override
    protected void putValue(ByteBuffer buf, int position, long time, Float value) {
        buf.putLong(position, time);
        buf.put(position + 8, (byte)0);
        buf.putFloat(position + 9, value.floatValue());
    }

    @Override
    protected void putValue(ByteBuffer buf, int position, long time, VectorValueSelector valueSelector, int index) {
        buf.putLong(position, time);
        buf.put(position + 8, (byte)0);
        buf.putFloat(position + 9, valueSelector.getFloatVector()[index]);
    }

    @Override
    protected void putNull(ByteBuffer buf, int position, long time) {
        buf.putLong(position, time);
        buf.put(position + 8, (byte)1);
        buf.putFloat(position + 9, 0.0f);
    }

    @Override
    protected SerializablePairLongFloat readPairFromVectorSelectors(boolean[] timeNullityVector, long[] timeVector, Object[] maybeFoldedObjects, int index) {
        return FirstLastUtils.readFloatPairFromVectorSelectors(timeNullityVector, timeVector, maybeFoldedObjects, index);
    }
}

