/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.guava.MergeSequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Queries;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.UnionDataSource;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.planning.ExecutionVertex;

public class UnionDataSourceQueryRunner<T>
implements QueryRunner<T> {
    private final QueryRunner<T> baseRunner;

    public UnionDataSourceQueryRunner(QueryRunner<T> baseRunner) {
        this.baseRunner = baseRunner;
    }

    @Override
    public Sequence<T> run(QueryPlus<T> queryPlus, ResponseContext responseContext) {
        Query<T> query = queryPlus.getQuery();
        ExecutionVertex ev = ExecutionVertex.of(query);
        DataSource baseDataSource = ev.getBaseDataSource();
        if (ev.isProcessable() && ev.isTableBased() && baseDataSource instanceof UnionDataSource) {
            UnionDataSource unionDataSource = (UnionDataSource)baseDataSource;
            if (unionDataSource.getChildren().isEmpty()) {
                throw new ISE("Unexpectedly received empty union", new Object[0]);
            }
            if (unionDataSource.getChildren().size() == 1) {
                return this.baseRunner.run(queryPlus.withQuery(Queries.withBaseDataSource(query, (DataSource)Iterables.getOnlyElement(unionDataSource.getChildren()))), responseContext);
            }
            return new MergeSequence<T>(query.getResultOrdering(), Sequences.simple(Lists.transform(IntStream.range(0, unionDataSource.getChildren().size()).mapToObj(i -> new Pair<DataSource, Integer>(unionDataSource.getChildren().get(i), i + 1)).collect(Collectors.toList()), singleSourceWithIndex -> this.baseRunner.run(queryPlus.withQuery(ev.buildQueryWithBaseDataSource((DataSource)singleSourceWithIndex.lhs).withSubQueryId(this.generateSubqueryId(query.getSubQueryId(), ((DataSource)singleSourceWithIndex.lhs).getTableNames(), (Integer)singleSourceWithIndex.rhs))), responseContext))));
        }
        return this.baseRunner.run(queryPlus, responseContext);
    }

    private String generateSubqueryId(String parentSubqueryId, Set<String> tableNames, int dataSourceIndex) {
        String dataSourceNameIndex = (String)Iterables.getOnlyElement(tableNames) + "." + dataSourceIndex;
        if (StringUtils.isEmpty((CharSequence)parentSubqueryId)) {
            return dataSourceNameIndex;
        }
        return parentSubqueryId + "." + dataSourceNameIndex;
    }
}

