/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.basic.authentication.validator;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheStats;
import com.google.common.hash.Hashing;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.security.basic.BasicAuthUtils;

public class PasswordHashGenerator {
    private static final Logger log = new Logger(PasswordHashGenerator.class);
    public static final int KEY_LENGTH = 512;
    public static final String HASH_ALGORITHM = "PBKDF2WithHmacSHA512";
    private final byte[] shaSalt = BasicAuthUtils.generateSalt();
    private final Cache<CacheKey, byte[]> cache = CacheBuilder.newBuilder().maximumSize(1000L).recordStats().expireAfterAccess(Duration.ofMinutes(60L)).build();

    public byte[] getOrComputePasswordHash(char[] password, byte[] salt, int numIterations) {
        try {
            return (byte[])this.cache.get((Object)CacheKey.of(password, salt, numIterations, this.shaSalt), () -> PasswordHashGenerator.computePasswordHash(password, salt, numIterations));
        }
        catch (ExecutionException e) {
            throw DruidException.defensive().build((Throwable)e, "Could not compute hash of password", new Object[0]);
        }
    }

    public CacheStats getCacheStats() {
        return this.cache.stats();
    }

    public static byte[] computePasswordHash(char[] password, byte[] salt, int iterations) {
        try {
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(HASH_ALGORITHM);
            SecretKey key = keyFactory.generateSecret(new PBEKeySpec(password, salt, iterations, 512));
            return key.getEncoded();
        }
        catch (InvalidKeySpecException ikse) {
            log.error("Invalid keyspec", new Object[0]);
            throw new RuntimeException("Invalid keyspec", ikse);
        }
        catch (NoSuchAlgorithmException nsae) {
            log.error("Hash algorithm[%s] is not supported on this system.", new Object[]{HASH_ALGORITHM});
            throw new RE((Throwable)nsae, "Hash algorithm[%s] is not supported on this system.", new Object[]{HASH_ALGORITHM});
        }
    }

    private static class CacheKey {
        final byte[] passwordSha;
        final byte[] salt;
        final int numIterations;

        CacheKey(byte[] passwordSha, byte[] salt, int numIterations) {
            this.passwordSha = passwordSha;
            this.salt = salt;
            this.numIterations = numIterations;
        }

        static CacheKey of(char[] password, byte[] salt, int numIterations, byte[] md5Salt) {
            byte[] passwordSha = Hashing.sha256().newHasher().putBytes(StringUtils.toUtf8((String)new String(password))).putBytes(md5Salt).hash().asBytes();
            return new CacheKey(passwordSha, salt, numIterations);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.numIterations == cacheKey.numIterations && Arrays.equals(this.passwordSha, cacheKey.passwordSha) && Arrays.equals(this.salt, cacheKey.salt);
        }

        public int hashCode() {
            int result = Objects.hash(this.numIterations);
            result = 31 * result + Arrays.hashCode(this.passwordSha);
            result = 31 * result + Arrays.hashCode(this.salt);
            return result;
        }
    }
}

