/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.loading;

import org.apache.druid.server.coordinator.loading.SegmentAction;

public class SegmentReplicaCount {
    private int requiredAndLoadable;
    private int required;
    private int loaded;
    private int loadedNonHistorical;
    private int loading;
    private int dropping;
    private int movingTo;
    private int movingFrom;

    void incrementLoaded() {
        ++this.loaded;
    }

    void incrementLoadedOnNonHistoricalServer() {
        ++this.loadedNonHistorical;
    }

    void incrementQueued(SegmentAction action) {
        switch (action) {
            case REPLICATE: 
            case LOAD: {
                ++this.loading;
                break;
            }
            case MOVE_TO: {
                ++this.movingTo;
                break;
            }
            case MOVE_FROM: {
                ++this.movingFrom;
                break;
            }
            case DROP: {
                ++this.dropping;
                break;
            }
        }
    }

    void setRequired(int required, int numLoadingServers) {
        this.required = required;
        this.requiredAndLoadable = Math.min(required, numLoadingServers);
    }

    public int required() {
        return this.required;
    }

    public int requiredAndLoadable() {
        return this.requiredAndLoadable;
    }

    int loading() {
        return this.loading;
    }

    int moving() {
        return this.movingTo;
    }

    int moveCompletedPendingDrop() {
        return this.movingFrom - this.movingTo;
    }

    public int totalLoaded() {
        return this.loaded + this.loadedNonHistorical;
    }

    int loadedNotDropping() {
        return this.loaded - this.dropping;
    }

    int missing() {
        return Math.max(this.required() - this.totalLoaded(), 0);
    }

    int missingAndLoadable() {
        return Math.max(this.requiredAndLoadable() - this.totalLoaded(), 0);
    }

    void accumulate(SegmentReplicaCount other) {
        this.required += other.required;
        this.requiredAndLoadable += other.requiredAndLoadable;
        this.loaded += other.loaded;
        this.loadedNonHistorical += other.loadedNonHistorical;
        this.loading += other.loading;
        this.dropping += other.dropping;
        this.movingTo += other.movingTo;
        this.movingFrom += other.movingFrom;
    }
}

