/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.balancer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.server.coordinator.balancer.ClusterCostCache;
import org.apache.druid.server.coordinator.balancer.CostBalancerStrategy;
import org.apache.druid.timeline.DataSegment;

@Deprecated
public class CachingCostBalancerStrategy
extends CostBalancerStrategy {
    private final ClusterCostCache clusterCostCache;

    public CachingCostBalancerStrategy(ClusterCostCache clusterCostCache, ListeningExecutorService exec) {
        super(exec);
        this.clusterCostCache = (ClusterCostCache)Preconditions.checkNotNull((Object)clusterCostCache);
    }

    @Override
    protected double computePlacementCost(DataSegment proposalSegment, ServerHolder server) {
        String serverName = server.getServer().getName();
        double cost = this.clusterCostCache.computeCost(serverName, proposalSegment);
        cost += this.costCacheForLoadingSegments(server).computeCost(serverName, proposalSegment);
        if (server.isServingSegment(proposalSegment) || server.isLoadingSegment(proposalSegment)) {
            cost -= this.costCacheForSegments(server, Collections.singleton(proposalSegment)).computeCost(serverName, proposalSegment);
        }
        cost -= this.costCacheForSegments(server, server.getPeon().getSegmentsToDrop()).computeCost(serverName, proposalSegment);
        cost -= this.costCacheForSegments(server, server.getPeon().getSegmentsMarkedToDrop()).computeCost(serverName, proposalSegment);
        if (server.getAvailableSize() <= 0L) {
            return Double.POSITIVE_INFINITY;
        }
        return cost * (double)(server.getMaxSize() / server.getAvailableSize());
    }

    private ClusterCostCache costCacheForLoadingSegments(ServerHolder server) {
        return this.costCacheForSegments(server, server.getPeon().getSegmentsToLoad());
    }

    private ClusterCostCache costCacheForSegments(ServerHolder server, Set<DataSegment> segments) {
        return ClusterCostCache.builder((Map<String, Set<DataSegment>>)ImmutableMap.of((Object)server.getServer().getName(), segments)).build();
    }
}

