/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.common.config.Configs;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.indexer.CompactionEngine;
import org.apache.druid.server.compaction.CompactionCandidateSearchPolicy;
import org.apache.druid.server.compaction.NewestSegmentFirstPolicy;

public class ClusterCompactionConfig {
    private static final CompactionCandidateSearchPolicy DEFAULT_COMPACTION_POLICY = new NewestSegmentFirstPolicy(null);
    private final double compactionTaskSlotRatio;
    private final int maxCompactionTaskSlots;
    private final boolean useSupervisors;
    private final CompactionEngine engine;
    private final CompactionCandidateSearchPolicy compactionPolicy;

    @JsonCreator
    public ClusterCompactionConfig(@JsonProperty(value="compactionTaskSlotRatio") @Nullable Double compactionTaskSlotRatio, @JsonProperty(value="maxCompactionTaskSlots") @Nullable Integer maxCompactionTaskSlots, @JsonProperty(value="compactionPolicy") @Nullable CompactionCandidateSearchPolicy compactionPolicy, @JsonProperty(value="useSupervisors") @Nullable Boolean useSupervisors, @JsonProperty(value="engine") @Nullable CompactionEngine engine) {
        this.compactionTaskSlotRatio = (Double)Configs.valueOrDefault((Object)compactionTaskSlotRatio, (Object)0.1);
        this.maxCompactionTaskSlots = Configs.valueOrDefault((Integer)maxCompactionTaskSlots, (int)Integer.MAX_VALUE);
        this.compactionPolicy = (CompactionCandidateSearchPolicy)Configs.valueOrDefault((Object)compactionPolicy, (Object)DEFAULT_COMPACTION_POLICY);
        this.engine = (CompactionEngine)Configs.valueOrDefault((Object)engine, (Object)CompactionEngine.NATIVE);
        this.useSupervisors = Configs.valueOrDefault((Boolean)useSupervisors, (boolean)false);
        if (!this.useSupervisors && this.engine == CompactionEngine.MSQ) {
            throw InvalidInput.exception((String)"MSQ Compaction engine can be used only with compaction supervisors.", (Object[])new Object[0]);
        }
    }

    @JsonProperty
    public double getCompactionTaskSlotRatio() {
        return this.compactionTaskSlotRatio;
    }

    @JsonProperty
    public int getMaxCompactionTaskSlots() {
        return this.maxCompactionTaskSlots;
    }

    @JsonProperty
    public CompactionCandidateSearchPolicy getCompactionPolicy() {
        return this.compactionPolicy;
    }

    @JsonProperty
    public boolean isUseSupervisors() {
        return this.useSupervisors;
    }

    @JsonProperty
    public CompactionEngine getEngine() {
        return this.engine;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterCompactionConfig that = (ClusterCompactionConfig)o;
        return Objects.equals(this.compactionTaskSlotRatio, that.compactionTaskSlotRatio) && Objects.equals(this.maxCompactionTaskSlots, that.maxCompactionTaskSlots) && Objects.equals(this.compactionPolicy, that.compactionPolicy) && Objects.equals(this.useSupervisors, that.useSupervisors) && Objects.equals(this.engine, that.engine);
    }

    public int hashCode() {
        return Objects.hash(this.compactionTaskSlotRatio, this.maxCompactionTaskSlots, this.compactionPolicy, this.useSupervisors, this.engine);
    }

    public String toString() {
        return "ClusterCompactionConfig{compactionTaskSlotRatio=" + this.compactionTaskSlotRatio + ", maxCompactionTaskSlots=" + this.maxCompactionTaskSlots + ", useSupervisors=" + this.useSupervisors + ", engine=" + String.valueOf(this.engine) + ", compactionPolicy=" + String.valueOf(this.compactionPolicy) + "}";
    }
}

