/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.druid.discovery.DruidService;
import org.apache.druid.jackson.StringObjectPairList;
import org.apache.druid.java.util.common.NonnullPair;

public class ToStringObjectPairListDeserializer
extends StdDeserializer<StringObjectPairList> {
    public ToStringObjectPairListDeserializer() {
        super(StringObjectPairList.class);
    }

    public StringObjectPairList deserialize(JsonParser parser, DeserializationContext ctx) throws IOException {
        if (parser.currentToken() != JsonToken.START_OBJECT) {
            throw ctx.wrongTokenException(parser, DruidService.class, JsonToken.START_OBJECT, null);
        }
        ArrayList<NonnullPair<String, Object>> pairs = new ArrayList<NonnullPair<String, Object>>();
        parser.nextToken();
        while (parser.currentToken() == JsonToken.FIELD_NAME) {
            String key = parser.getText();
            parser.nextToken();
            Object val = ctx.readValue(parser, Object.class);
            pairs.add((NonnullPair<String, Object>)new NonnullPair((Object)key, val));
            parser.nextToken();
        }
        if (parser.currentToken() != JsonToken.END_OBJECT) {
            throw ctx.wrongTokenException(parser, DruidService.class, JsonToken.END_OBJECT, null);
        }
        return new StringObjectPairList(pairs);
    }
}

