/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice.http;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.utils.JvmUtils;
import org.joda.time.Duration;
import org.joda.time.Period;
import org.joda.time.ReadableDuration;

public class DruidHttpClientConfig {
    private static final String DEFAULT_COMPRESSION_CODEC = "gzip";
    private static final double DEFAULT_MAX_QUEUED_BYTES_HEAP_FRACTION = 0.02;
    private static final Logger LOG = new Logger(DruidHttpClientConfig.class);
    @JsonProperty
    @Min(value=0L)
    private @Min(value=0L) int numConnections = 20;
    @JsonProperty
    private Period readTimeout = new Period((Object)"PT15M");
    @JsonProperty
    @Min(value=1L)
    private @Min(value=1L) int numMaxThreads = JvmUtils.getRuntimeInfo().getAvailableProcessors() * 3 / 2 + 1;
    @JsonProperty
    @Min(value=1L)
    private @Min(value=1L) int numRequestsQueued = 1024;
    @JsonProperty
    private String compressionCodec = "gzip";
    @JsonProperty
    private int requestBuffersize = 8192;
    @JsonProperty
    private Period unusedConnectionTimeout = new Period((Object)"PT4M");
    @JsonProperty
    private HumanReadableBytes maxQueuedBytes = DruidHttpClientConfig.computeDefaultMaxQueuedBytes();
    @JsonProperty
    private Boolean eagerInitialization = null;
    @JsonProperty
    private long clientConnectTimeout = TimeUnit.MILLISECONDS.toMillis(500L);

    public int getNumConnections() {
        return this.numConnections;
    }

    public Duration getReadTimeout() {
        return this.readTimeout == null ? null : this.readTimeout.toStandardDuration();
    }

    public int getNumMaxThreads() {
        return this.numMaxThreads;
    }

    public String getCompressionCodec() {
        return this.compressionCodec;
    }

    public int getNumRequestsQueued() {
        return this.numRequestsQueued;
    }

    public int getRequestBuffersize() {
        return this.requestBuffersize;
    }

    public Duration getUnusedConnectionTimeout() {
        if (this.unusedConnectionTimeout != null && this.readTimeout != null && this.unusedConnectionTimeout.toStandardDuration().compareTo((ReadableDuration)this.readTimeout.toStandardDuration()) >= 0) {
            LOG.warn("Ohh no! UnusedConnectionTimeout[%s] is longer than readTimeout[%s], please correct the configuration, this might not be supported in future.", new Object[]{this.unusedConnectionTimeout, this.readTimeout});
        }
        return this.unusedConnectionTimeout == null ? null : this.unusedConnectionTimeout.toStandardDuration();
    }

    public long getMaxQueuedBytes() {
        return this.maxQueuedBytes.getBytes();
    }

    public boolean isEagerInitialization(boolean defaultValue) {
        if (null == this.eagerInitialization) {
            return defaultValue;
        }
        return this.eagerInitialization;
    }

    public long getClientConnectTimeout() {
        return this.clientConnectTimeout;
    }

    private static HumanReadableBytes computeDefaultMaxQueuedBytes() {
        return HumanReadableBytes.valueOf((long)Math.max(25000000L, (long)((double)JvmUtils.getRuntimeInfo().getMaxHeapSizeBytes() * 0.02)));
    }
}

