/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.restrictions.common;

import com.github.rvesse.airline.help.sections.HelpFormat;
import com.github.rvesse.airline.help.sections.HelpHint;
import com.github.rvesse.airline.model.ArgumentsMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.parser.ParseState;
import com.github.rvesse.airline.restrictions.AbstractCommonRestriction;
import com.github.rvesse.airline.restrictions.ArgumentsRestriction;
import com.github.rvesse.airline.restrictions.OptionRestriction;
import com.github.rvesse.airline.utils.AirlineUtils;
import com.github.rvesse.airline.utils.predicates.parser.ParsedOptionFinder;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;

public class PartialRestriction
extends AbstractCommonRestriction
implements HelpHint {
    private final Set<Integer> indices = new TreeSet<Integer>();
    private final OptionRestriction optionRestriction;
    private final ArgumentsRestriction argumentsRestriction;
    private final HelpHint hint;

    private PartialRestriction(OptionRestriction optionRestriction) {
        this.optionRestriction = optionRestriction;
        this.argumentsRestriction = optionRestriction instanceof ArgumentsRestriction ? (ArgumentsRestriction)((Object)optionRestriction) : null;
        this.hint = optionRestriction instanceof HelpHint ? (HelpHint)((Object)optionRestriction) : null;
    }

    private PartialRestriction(ArgumentsRestriction argumentsRestriction) {
        this.optionRestriction = argumentsRestriction instanceof OptionRestriction ? (OptionRestriction)((Object)argumentsRestriction) : null;
        this.argumentsRestriction = argumentsRestriction;
        this.hint = argumentsRestriction instanceof HelpHint ? (HelpHint)((Object)argumentsRestriction) : null;
    }

    public PartialRestriction(int[] indices, OptionRestriction optionRestriction) {
        this(optionRestriction);
        for (int i : indices) {
            this.indices.add(i);
        }
    }

    public PartialRestriction(int[] indices, ArgumentsRestriction argumentsRestriction) {
        this(argumentsRestriction);
        for (int i : indices) {
            this.indices.add(i);
        }
    }

    public PartialRestriction(Collection<Integer> indices, OptionRestriction optionRestriction) {
        this(optionRestriction);
        this.indices.addAll(indices);
    }

    public PartialRestriction(Collection<Integer> indices, ArgumentsRestriction argumentsRestriction) {
        this(argumentsRestriction);
        this.indices.addAll(indices);
    }

    private <T> boolean isApplicableToOption(ParseState<T> state, OptionMetadata option) {
        int index = CollectionUtils.countMatches(state.getParsedOptions(), (Predicate)new ParsedOptionFinder(option)) % option.getArity();
        return this.indices.contains(index);
    }

    @Override
    public <T> void preValidate(ParseState<T> state, OptionMetadata option, String value) {
        if (this.optionRestriction == null) {
            return;
        }
        if (!this.isApplicableToOption(state, option)) {
            return;
        }
        this.optionRestriction.preValidate(state, option, value);
    }

    @Override
    public <T> void postValidate(ParseState<T> state, OptionMetadata option, Object value) {
        if (this.optionRestriction == null) {
            return;
        }
        if (!this.isApplicableToOption(state, option)) {
            return;
        }
        this.optionRestriction.postValidate(state, option, value);
    }

    private <T> boolean isApplicableToArgument(ParseState<T> state) {
        int index = state.getParsedArguments().size();
        return this.indices.contains(index);
    }

    @Override
    public <T> void preValidate(ParseState<T> state, ArgumentsMetadata arguments, String value) {
        if (this.argumentsRestriction == null) {
            return;
        }
        if (!this.isApplicableToArgument(state)) {
            return;
        }
        this.argumentsRestriction.preValidate(state, arguments, value);
    }

    @Override
    public <T> void postValidate(ParseState<T> state, ArgumentsMetadata arguments, Object value) {
        if (this.argumentsRestriction == null) {
            return;
        }
        if (!this.isApplicableToArgument(state)) {
            return;
        }
        this.argumentsRestriction.postValidate(state, arguments, value);
    }

    @Override
    public String getPreamble() {
        if (this.hint == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("The following restriction only applies to the ");
        int count = 0;
        for (int i : this.indices) {
            if (count > 0) {
                builder.append(", ");
            }
            builder.append(AirlineUtils.toOrdinal(i + 1));
            ++count;
        }
        builder.append(" value");
        if (this.indices.size() > 1) {
            builder.append('s');
        }
        builder.append(": ");
        if (this.hint.getPreamble() != null) {
            builder.append(this.hint.getPreamble());
        }
        return builder.toString();
    }

    @Override
    public HelpFormat getFormat() {
        return this.hint != null ? this.hint.getFormat() : HelpFormat.NONE_PRINTABLE;
    }

    @Override
    public int numContentBlocks() {
        return this.hint != null ? this.hint.numContentBlocks() : 0;
    }

    @Override
    public String[] getContentBlock(int blockNumber) {
        if (this.hint != null) {
            return this.hint.getContentBlock(blockNumber);
        }
        throw new IndexOutOfBoundsException();
    }
}

