/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.parser.aliases;

import com.github.rvesse.airline.parser.errors.ParseException;
import java.util.ArrayList;
import java.util.List;

public class AliasArgumentsParser {
    private CharSequence sequence;

    public static List<String> parse(String value) {
        AliasArgumentsParser parser = new AliasArgumentsParser(value);
        return parser.parse();
    }

    AliasArgumentsParser(String value) {
        this.sequence = value;
    }

    public List<String> parse() {
        ArrayList<String> args = new ArrayList<String>();
        block3: for (int i = 0; i < this.sequence.length(); ++i) {
            char c = this.sequence.charAt(i);
            switch (c) {
                case '\"': {
                    i = this.parseQuotedArgument(i, args);
                    continue block3;
                }
                default: {
                    if (Character.isWhitespace(c)) continue block3;
                    i = this.parseUnquotedArgument(i, args);
                }
            }
        }
        return args;
    }

    private int parseQuotedArgument(int start, List<String> args) {
        StringBuilder arg = new StringBuilder();
        block4: for (int i = start + 1; i < this.sequence.length(); ++i) {
            char c = this.sequence.charAt(i);
            switch (c) {
                case '\"': {
                    args.add(arg.toString());
                    return i;
                }
                case '\\': {
                    char next;
                    if (i + 1 < this.sequence.length() && (next = this.sequence.charAt(i + 1)) == '\"') {
                        arg.append(next);
                        ++i;
                        continue block4;
                    }
                }
                default: {
                    arg.append(c);
                }
            }
        }
        throw new ParseException("Mismatched quotes in alias definition: %s", this.sequence);
    }

    private int parseUnquotedArgument(int start, List<String> args) {
        StringBuilder arg = new StringBuilder();
        for (int i = start; i < this.sequence.length(); ++i) {
            char c = this.sequence.charAt(i);
            if (c == '\\') {
                char next;
                if (i + 1 < this.sequence.length() && Character.isWhitespace(next = this.sequence.charAt(i + 1))) {
                    arg.append(next);
                    ++i;
                    continue;
                }
            } else if (Character.isWhitespace(c)) {
                args.add(arg.toString());
                return i;
            }
            arg.append(c);
        }
        args.add(arg.toString());
        return this.sequence.length() - 1;
    }
}

