/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import net.spy.memcached.OperationTimeoutException;
import net.spy.memcached.compat.log.Logger;
import net.spy.memcached.compat.log.LoggerFactory;

public class TLSConnectionHandler {
    protected ByteBuffer myAppData;
    protected ByteBuffer myNetData;
    protected ByteBuffer peerAppData;
    protected ByteBuffer peerNetData;
    private SocketChannel socketChannel;
    private SSLEngine sslEngine;
    private SSLEngineResult.HandshakeStatus handshakeStatus;
    private Logger log = LoggerFactory.getLogger(TLSConnectionHandler.class);

    public TLSConnectionHandler(SocketChannel socketChannel, SSLEngine sslEngine) {
        this.socketChannel = socketChannel;
        this.sslEngine = sslEngine;
    }

    public boolean doTlsHandshake(long timeoutInMillis) throws IOException {
        SSLSession session = this.sslEngine.getSession();
        int packetBufferSize = session.getPacketBufferSize();
        this.myNetData = ByteBuffer.allocate(packetBufferSize);
        this.peerNetData = ByteBuffer.allocate(packetBufferSize);
        int appBufferSize = session.getApplicationBufferSize();
        this.myAppData = ByteBuffer.allocate(appBufferSize);
        this.peerAppData = ByteBuffer.allocate(appBufferSize);
        this.myNetData.clear();
        this.peerNetData.clear();
        this.myAppData.clear();
        this.peerAppData.clear();
        long startTimeDoTlsHandshake = System.nanoTime();
        this.sslEngine.beginHandshake();
        this.handshakeStatus = this.sslEngine.getHandshakeStatus();
        block9: while (this.handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED && this.handshakeStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            if (System.nanoTime() - startTimeDoTlsHandshake > TimeUnit.MILLISECONDS.toNanos(timeoutInMillis)) {
                throw new OperationTimeoutException("Timeout during TLS handshake");
            }
            switch (this.handshakeStatus) {
                case NEED_UNWRAP: {
                    SSLEngineResult result;
                    if (this.socketChannel.read(this.peerNetData) < 0) {
                        if (this.sslEngine.isInboundDone() && this.sslEngine.isOutboundDone()) {
                            return false;
                        }
                        this.handleEndOfStream();
                        this.handshakeStatus = this.sslEngine.getHandshakeStatus();
                        continue block9;
                    }
                    this.peerNetData.flip();
                    try {
                        result = this.sslEngine.unwrap(this.peerNetData, this.peerAppData);
                        this.peerAppData.clear();
                        this.peerNetData.compact();
                        this.handshakeStatus = result.getHandshakeStatus();
                    }
                    catch (SSLException sslException) {
                        this.log.debug((Object)"A problem that caused the SSLEngine to abort", sslException);
                        this.sslEngine.closeOutbound();
                        this.handshakeStatus = this.sslEngine.getHandshakeStatus();
                        continue block9;
                    }
                    boolean shouldContinue = this.handleUnwrapResultForHandshake(result, session);
                    if (shouldContinue) continue block9;
                    return false;
                }
                case NEED_WRAP: {
                    SSLEngineResult result;
                    this.myNetData.clear();
                    try {
                        result = this.sslEngine.wrap(this.myAppData, this.myNetData);
                        this.handshakeStatus = result.getHandshakeStatus();
                    }
                    catch (SSLException sslException) {
                        this.log.debug((Object)"Cannot process the data through SSLEngine. Will close the connection", sslException);
                        this.sslEngine.closeOutbound();
                        this.handshakeStatus = this.sslEngine.getHandshakeStatus();
                        continue block9;
                    }
                    this.handleWrapResultForHandshake(result, session);
                    continue block9;
                }
                case NEED_TASK: {
                    Runnable task;
                    while ((task = this.sslEngine.getDelegatedTask()) != null) {
                        task.run();
                    }
                    this.handshakeStatus = this.sslEngine.getHandshakeStatus();
                    continue block9;
                }
            }
            throw new IllegalArgumentException("Invalid handshake status: " + (Object)((Object)this.handshakeStatus));
        }
        if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED) {
            this.peerNetData.compact();
            return true;
        }
        return false;
    }

    public int encryptNextTLSDataRecord(ByteBuffer obuf, ByteBuffer wbuf) throws IOException {
        if (obuf.hasRemaining() && wbuf.hasRemaining()) {
            SSLEngineResult result = this.sslEngine.wrap(obuf, wbuf);
            switch (result.getStatus()) {
                case OK: {
                    return result.bytesProduced();
                }
                case BUFFER_OVERFLOW: {
                    return -1;
                }
                case CLOSED: {
                    throw new RuntimeException("TLS connection is closed...");
                }
            }
            throw new IllegalArgumentException("Invalid result status after wrap(): " + (Object)((Object)result.getStatus()));
        }
        return 0;
    }

    public ByteBuffer decryptNextTLSDataRecord(ByteBuffer rbuf) throws IOException {
        SSLEngineResult result;
        SSLSession session = this.sslEngine.getSession();
        this.peerAppData.clear();
        block6: while (true) {
            result = this.sslEngine.unwrap(rbuf, this.peerAppData);
            switch (result.getStatus()) {
                case OK: {
                    this.peerAppData.flip();
                    return this.peerAppData;
                }
                case BUFFER_OVERFLOW: {
                    this.peerAppData = this.enlargeBuffer(this.peerAppData, session.getApplicationBufferSize());
                    continue block6;
                }
                case BUFFER_UNDERFLOW: {
                    return null;
                }
                case CLOSED: {
                    this.sslEngine.closeOutbound();
                    this.socketChannel.close();
                    throw new IOException("The operation could not be completed because it was already closed");
                }
            }
            break;
        }
        throw new IllegalArgumentException("Invalid result status after unwrap(): " + (Object)((Object)result.getStatus()));
    }

    private ByteBuffer enlargeBuffer(ByteBuffer buffer, int requiredBufferSize) {
        if (requiredBufferSize > buffer.capacity()) {
            ByteBuffer newBuffer = ByteBuffer.allocate(requiredBufferSize);
            buffer.flip();
            newBuffer.put(buffer);
            return newBuffer;
        }
        return buffer;
    }

    private void handleEndOfStream() throws IOException {
        try {
            this.sslEngine.closeInbound();
        }
        catch (SSLException e) {
            this.log.error((Object)"This engine has not received the proper SSL/TLS close notification message from the peer due to end of stream.", e);
        }
        this.sslEngine.closeOutbound();
    }

    private boolean handleUnwrapResultForHandshake(SSLEngineResult result, SSLSession session) throws IOException {
        switch (result.getStatus()) {
            case OK: {
                break;
            }
            case BUFFER_OVERFLOW: {
                this.peerAppData = this.enlargeBuffer(this.peerAppData, session.getApplicationBufferSize());
                break;
            }
            case BUFFER_UNDERFLOW: {
                break;
            }
            case CLOSED: {
                if (this.sslEngine.isOutboundDone()) {
                    return false;
                }
                this.sslEngine.closeOutbound();
                this.handshakeStatus = this.sslEngine.getHandshakeStatus();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid result status after unwrap(): " + (Object)((Object)result.getStatus()));
            }
        }
        return true;
    }

    private void writeDataToSocketChannel(ByteBuffer buf) throws IOException {
        if (buf.hasRemaining()) {
            this.socketChannel.write(buf);
        }
    }

    private void handleWrapResultForHandshake(SSLEngineResult result, SSLSession session) throws IOException {
        switch (result.getStatus()) {
            case OK: {
                this.myNetData.flip();
                this.writeDataToSocketChannel(this.myNetData);
                break;
            }
            case BUFFER_OVERFLOW: {
                this.myNetData = this.enlargeBuffer(this.myNetData, session.getPacketBufferSize());
                break;
            }
            case BUFFER_UNDERFLOW: {
                throw new SSLException("Buffer underflow occured after a wrap");
            }
            case CLOSED: {
                try {
                    this.myNetData.flip();
                    this.writeDataToSocketChannel(this.myNetData);
                    this.handshakeStatus = this.sslEngine.getHandshakeStatus();
                    this.peerNetData.clear();
                }
                catch (Exception e) {
                    this.log.error((Object)"Failed to send server's CLOSE message due to socket channel's failure", e);
                    this.handshakeStatus = this.sslEngine.getHandshakeStatus();
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid result status after wrap(): " + (Object)((Object)result.getStatus()));
            }
        }
    }
}

