/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import java.util.LinkedHashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.ResponseContextConfig;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.sql.HttpStatement;
import org.apache.druid.sql.http.SqlQuery;
import org.apache.druid.sql.http.SqlResourceQueryResultPusher;

public class SqlResourceQueryResultPusherFactory {
    private final ObjectMapper jsonMapper;
    private final ServerConfig serverConfig;
    private final ResponseContextConfig responseContextConfig;
    private final DruidNode selfNode;

    @Inject
    public SqlResourceQueryResultPusherFactory(ObjectMapper jsonMapper, ServerConfig serverConfig, ResponseContextConfig responseContextConfig, @Self DruidNode selfNode) {
        this.jsonMapper = jsonMapper;
        this.serverConfig = serverConfig;
        this.responseContextConfig = responseContextConfig;
        this.selfNode = selfNode;
    }

    public SqlResourceQueryResultPusher factorize(HttpServletRequest req, HttpStatement stmt, SqlQuery sqlQuery) {
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        String sqlQueryId = stmt.sqlQueryId();
        headers.put("X-Druid-SQL-Query-Id", sqlQueryId);
        if (sqlQuery.includeHeader()) {
            headers.put("X-Druid-SQL-Header-Included", "yes");
        }
        return new SqlResourceQueryResultPusher(this.jsonMapper, this.responseContextConfig, this.selfNode, this.serverConfig, req, stmt, sqlQuery, headers);
    }
}

