/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import com.google.common.collect.ImmutableList;
import java.io.Reader;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCostFactory;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.metadata.CachingRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.util.SqlOperatorTables;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql2rel.RelDecorrelator;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Planner;
import org.apache.calcite.tools.Program;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.ValidationException;
import org.apache.calcite.util.Pair;
import org.apache.druid.sql.calcite.planner.DruidHint;
import org.apache.druid.sql.calcite.planner.DruidSqlToRelConverter;
import org.apache.druid.sql.calcite.planner.DruidSqlValidator;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.planner.PlannerFactory;

public class CalcitePlanner
implements Planner,
RelOptTable.ViewExpander {
    private final SqlOperatorTable operatorTable;
    private final ImmutableList<Program> programs;
    @Nullable
    private final RelOptCostFactory costFactory;
    private final Context context;
    private final CalciteConnectionConfig connectionConfig;
    private final RelDataTypeSystem typeSystem;
    @Nullable
    private final ImmutableList<RelTraitDef> traitDefs;
    private final SqlParser.Config parserConfig;
    private final SqlToRelConverter.Config sqlToRelConverterConfig;
    private final SqlRexConvertletTable convertletTable;
    private State state;
    private boolean open;
    @Nullable
    private SchemaPlus defaultSchema;
    @Nullable
    private JavaTypeFactory typeFactory;
    @Nullable
    private RelOptPlanner planner;
    @Nullable
    private RexExecutor executor;
    @Nullable
    private SqlValidator validator;
    @Nullable
    private SqlNode validatedSqlNode;

    public CalcitePlanner(FrameworkConfig config) {
        this.costFactory = config.getCostFactory();
        this.defaultSchema = config.getDefaultSchema();
        this.operatorTable = config.getOperatorTable();
        this.programs = config.getPrograms();
        this.parserConfig = config.getParserConfig();
        this.sqlToRelConverterConfig = config.getSqlToRelConverterConfig();
        this.state = State.STATE_0_CLOSED;
        this.traitDefs = config.getTraitDefs();
        this.convertletTable = config.getConvertletTable();
        this.executor = config.getExecutor();
        this.context = config.getContext();
        this.connectionConfig = CalcitePlanner.connConfig(this.context);
        this.typeSystem = config.getTypeSystem();
        this.reset();
    }

    private static CalciteConnectionConfig connConfig(Context context) {
        return (CalciteConnectionConfig)context.maybeUnwrap(CalciteConnectionConfig.class).orElse(new PlannerFactory.DruidCalciteConnectionConfigImpl(new Properties()));
    }

    private void ensure(State state) {
        if (state == this.state) {
            return;
        }
        if (state.ordinal() < this.state.ordinal()) {
            throw new IllegalArgumentException("cannot move to " + String.valueOf((Object)state) + " from " + String.valueOf((Object)this.state));
        }
        state.from(this);
    }

    public RelTraitSet getEmptyTraitSet() {
        return Objects.requireNonNull(this.planner, "planner").emptyTraitSet();
    }

    public void close() {
        this.open = false;
        this.typeFactory = null;
        this.state = State.STATE_0_CLOSED;
    }

    public void reset() {
        this.ensure(State.STATE_0_CLOSED);
        this.open = true;
        this.state = State.STATE_1_RESET;
    }

    private void ready() {
        switch (this.state.ordinal()) {
            case 0: {
                this.reset();
                break;
            }
        }
        this.ensure(State.STATE_1_RESET);
        this.typeFactory = new JavaTypeFactoryImpl(this.typeSystem);
        this.planner = new VolcanoPlanner(this.costFactory, this.context);
        VolcanoPlanner planner = this.planner;
        planner.setExecutor(this.executor);
        this.state = State.STATE_2_READY;
        if (this.traitDefs == null) {
            planner.addRelTraitDef((RelTraitDef)ConventionTraitDef.INSTANCE);
            if (((Boolean)CalciteSystemProperty.ENABLE_COLLATION_TRAIT.value()).booleanValue()) {
                planner.addRelTraitDef((RelTraitDef)RelCollationTraitDef.INSTANCE);
            }
        } else {
            for (RelTraitDef def : this.traitDefs) {
                planner.addRelTraitDef(def);
            }
        }
    }

    public SqlNode parse(Reader reader) throws SqlParseException {
        switch (this.state.ordinal()) {
            case 0: 
            case 1: {
                this.ready();
                break;
            }
        }
        this.ensure(State.STATE_2_READY);
        SqlParser parser = SqlParser.create((Reader)reader, (SqlParser.Config)this.parserConfig);
        SqlNodeList sqlNode = parser.parseStmtList();
        this.state = State.STATE_3_PARSED;
        return sqlNode;
    }

    public void skipParse() {
        switch (this.state.ordinal()) {
            case 0: 
            case 1: {
                this.ready();
                break;
            }
        }
        this.ensure(State.STATE_2_READY);
        this.state = State.STATE_3_PARSED;
    }

    public SqlNode validate(SqlNode sqlNode) throws ValidationException {
        Hook.PARSE_TREE.run((Object)new Object[]{null, sqlNode});
        this.ensure(State.STATE_3_PARSED);
        this.validator = this.createSqlValidator(this.createCatalogReader());
        try {
            this.validatedSqlNode = this.validator.validate(sqlNode);
        }
        catch (RuntimeException e) {
            throw new ValidationException((Throwable)e);
        }
        this.state = State.STATE_4_VALIDATED;
        return this.validatedSqlNode;
    }

    public SqlValidator getValidator() {
        return this.validator;
    }

    public Pair<SqlNode, RelDataType> validateAndGetType(SqlNode sqlNode) throws ValidationException {
        SqlNode validatedNode = this.validate(sqlNode);
        RelDataType type = this.validator.getValidatedNodeType(validatedNode);
        return Pair.of((Object)validatedNode, (Object)type);
    }

    public RelDataType getParameterRowType() {
        if (this.state.ordinal() < State.STATE_4_VALIDATED.ordinal()) {
            throw new RuntimeException("Need to call #validate() first");
        }
        return Objects.requireNonNull(this.validator, "validator").getParameterRowType(Objects.requireNonNull(this.validatedSqlNode, "validatedSqlNode"));
    }

    public final RelNode convert(SqlNode sql) {
        return this.rel((SqlNode)sql).rel;
    }

    public RelRoot rel(SqlNode sql) {
        this.ensure(State.STATE_4_VALIDATED);
        Objects.requireNonNull(this.validatedSqlNode, "validatedSqlNode is null. Need to call #validate() first");
        RexBuilder rexBuilder = this.createRexBuilder();
        RelOptCluster cluster = RelOptCluster.create((RelOptPlanner)Objects.requireNonNull(this.planner, "planner"), (RexBuilder)rexBuilder);
        SqlToRelConverter.Config config = this.sqlToRelConverterConfig.withTrimUnusedFields(false).withHintStrategyTable(DruidHint.HINT_STRATEGY_TABLE);
        DruidSqlToRelConverter sqlToRelConverter = new DruidSqlToRelConverter(this, this.validator, (Prepare.CatalogReader)this.createCatalogReader(), cluster, this.convertletTable, config);
        RelRoot root = sqlToRelConverter.convertQuery(sql, false, true);
        root = root.withRel(sqlToRelConverter.flattenTypes(root.rel, true));
        RelBuilder relBuilder = config.getRelBuilderFactory().create(cluster, null);
        root = root.withRel(RelDecorrelator.decorrelateQuery((RelNode)root.rel, (RelBuilder)relBuilder));
        this.state = State.STATE_5_CONVERTED;
        return root;
    }

    public RelRoot expandView(RelDataType rowType, String queryString, List<String> schemaPath, @Nullable List<String> viewPath) {
        SqlNode sqlNode;
        RelOptPlanner planner = this.planner;
        if (planner == null) {
            this.ready();
            planner = Objects.requireNonNull(this.planner, "planner");
        }
        SqlParser parser = SqlParser.create((String)queryString, (SqlParser.Config)this.parserConfig);
        try {
            sqlNode = parser.parseQuery();
        }
        catch (SqlParseException e) {
            throw new RuntimeException("parse failed", e);
        }
        CalciteCatalogReader catalogReader = this.createCatalogReader().withSchemaPath(schemaPath);
        SqlValidator validator = this.createSqlValidator(catalogReader);
        RexBuilder rexBuilder = this.createRexBuilder();
        RelOptCluster cluster = RelOptCluster.create((RelOptPlanner)planner, (RexBuilder)rexBuilder);
        SqlToRelConverter.Config config = this.sqlToRelConverterConfig.withTrimUnusedFields(false);
        SqlToRelConverter sqlToRelConverter = new SqlToRelConverter((RelOptTable.ViewExpander)this, validator, (Prepare.CatalogReader)catalogReader, cluster, this.convertletTable, config);
        RelRoot root = sqlToRelConverter.convertQuery(sqlNode, true, false);
        RelRoot root2 = root.withRel(sqlToRelConverter.flattenTypes(root.rel, true));
        RelBuilder relBuilder = config.getRelBuilderFactory().create(cluster, null);
        return root2.withRel(RelDecorrelator.decorrelateQuery((RelNode)root.rel, (RelBuilder)relBuilder));
    }

    private CalciteCatalogReader createCatalogReader() {
        SchemaPlus defaultSchema = Objects.requireNonNull(this.defaultSchema, "defaultSchema");
        SchemaPlus rootSchema = CalcitePlanner.rootSchema(defaultSchema);
        return new CalciteCatalogReader(CalciteSchema.from((SchemaPlus)rootSchema), CalciteSchema.from((SchemaPlus)defaultSchema).path(null), (RelDataTypeFactory)this.getTypeFactory(), this.connectionConfig);
    }

    private SqlValidator createSqlValidator(CalciteCatalogReader catalogReader) {
        SqlOperatorTable opTab = SqlOperatorTables.chain((SqlOperatorTable[])new SqlOperatorTable[]{this.operatorTable, catalogReader});
        SqlValidator.Config validatorConfig = SqlValidator.Config.DEFAULT.withConformance(this.connectionConfig.conformance()).withLenientOperatorLookup(this.connectionConfig.lenientOperatorLookup()).withIdentifierExpansion(true);
        return new DruidSqlValidator(opTab, catalogReader, this.getTypeFactory(), validatorConfig, (PlannerContext)this.context.unwrapOrThrow(PlannerContext.class));
    }

    private static SchemaPlus rootSchema(SchemaPlus schema) {
        SchemaPlus parentSchema;
        while ((parentSchema = schema.getParentSchema()) != null) {
            schema = parentSchema;
        }
        return schema;
    }

    private RexBuilder createRexBuilder() {
        return new RexBuilder((RelDataTypeFactory)this.getTypeFactory());
    }

    public JavaTypeFactory getTypeFactory() {
        return Objects.requireNonNull(this.typeFactory, "typeFactory");
    }

    public RelNode transform(int ruleSetIndex, RelTraitSet requiredOutputTraits, RelNode rel) {
        this.ensure(State.STATE_5_CONVERTED);
        rel.getCluster().setMetadataProvider((RelMetadataProvider)new CachingRelMetadataProvider(Objects.requireNonNull(rel.getCluster().getMetadataProvider(), "metadataProvider"), rel.getCluster().getPlanner()));
        Program program = (Program)this.programs.get(ruleSetIndex);
        return program.run(Objects.requireNonNull(this.planner, "planner"), rel, requiredOutputTraits, (List)ImmutableList.of(), (List)ImmutableList.of());
    }

    private static enum State {
        STATE_0_CLOSED{

            @Override
            void from(CalcitePlanner planner) {
                planner.close();
            }
        }
        ,
        STATE_1_RESET{

            @Override
            void from(CalcitePlanner planner) {
                planner.ensure(STATE_0_CLOSED);
                planner.reset();
            }
        }
        ,
        STATE_2_READY{

            @Override
            void from(CalcitePlanner planner) {
                STATE_1_RESET.from(planner);
                planner.ready();
            }
        }
        ,
        STATE_3_PARSED,
        STATE_4_VALIDATED,
        STATE_5_CONVERTED;


        void from(CalcitePlanner planner) {
            throw new IllegalArgumentException("cannot move from " + String.valueOf((Object)planner.state) + " to " + String.valueOf((Object)this));
        }
    }

    @Deprecated
    public class ViewExpanderImpl
    implements RelOptTable.ViewExpander {
        ViewExpanderImpl() {
        }

        public RelRoot expandView(RelDataType rowType, String queryString, List<String> schemaPath, @Nullable List<String> viewPath) {
            return CalcitePlanner.this.expandView(rowType, queryString, schemaPath, viewPath);
        }
    }
}

