/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.avatica;

import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.metrics.MetricsSystem;
import org.apache.calcite.avatica.metrics.Timer;
import org.apache.calcite.avatica.remote.LocalService;
import org.apache.calcite.avatica.remote.MetricsHelper;
import org.apache.calcite.avatica.remote.Service;
import org.apache.calcite.avatica.server.MetricsAwareAvaticaHandler;
import org.apache.calcite.avatica.util.UnsynchronizedBuffer;
import org.apache.druid.sql.avatica.AvaticaMonitor;
import org.apache.druid.sql.avatica.DruidMeta;
import org.eclipse.jetty.server.Handler;

public abstract class DruidAvaticaHandler
extends Handler.Abstract
implements MetricsAwareAvaticaHandler {
    protected final Service service;
    protected final MetricsSystem metrics;
    protected final Timer requestTimer;
    protected final ThreadLocal<UnsynchronizedBuffer> threadLocalBuffer;

    protected DruidAvaticaHandler(DruidMeta druidMeta, AvaticaMonitor avaticaMonitor, Class<?> timerClass) {
        this.service = new LocalService((Meta)druidMeta);
        this.metrics = avaticaMonitor;
        this.threadLocalBuffer = ThreadLocal.withInitial(UnsynchronizedBuffer::new);
        this.requestTimer = this.metrics.getTimer(MetricsHelper.concat(timerClass, (String)"Handler.RequestTimings"));
    }

    public MetricsSystem getMetrics() {
        return this.metrics;
    }

    public void setServerRpcMetadata(Service.RpcMetadataResponse metadata) {
        this.service.setRpcMetadata(metadata);
    }
}

