/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.sync;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.concurrent.TimeUnit;

public class CatalogClientConfig {
    private static final long DEFAULT_POLLING_PERIOD = TimeUnit.MINUTES.toMillis(1L);
    private static final long DEFAULT_MAX_RANDOM_DELAY = TimeUnit.SECONDS.toMillis(10L);
    private static final int DEFAULT_MAX_SYNC_RETRIES = 5;
    @JsonProperty
    private final long pollingPeriod;
    @JsonProperty
    private final long maxRandomDelay;
    @JsonProperty
    private final int maxSyncRetries;

    @JsonCreator
    public CatalogClientConfig(@JsonProperty(value="pollingPeriod") Long pollingPeriod, @JsonProperty(value="maxRandomDelay") Long maxRandomDelay, @JsonProperty(value="maxSyncRetries") Integer maxSyncRetries) {
        this.pollingPeriod = pollingPeriod == null ? DEFAULT_POLLING_PERIOD : pollingPeriod;
        this.maxRandomDelay = maxRandomDelay == null ? DEFAULT_MAX_RANDOM_DELAY : maxRandomDelay;
        this.maxSyncRetries = maxSyncRetries == null ? 5 : maxSyncRetries;
    }

    @JsonProperty
    public long getPollingPeriod() {
        return this.pollingPeriod;
    }

    @JsonProperty
    public long getMaxRandomDelay() {
        return this.maxRandomDelay;
    }

    @JsonProperty
    public int getMaxSyncRetries() {
        return this.maxSyncRetries;
    }
}

