/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.opencsv.RFC4180Parser;
import com.opencsv.RFC4180ParserBuilder;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.frame.FrameType;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.msq.exec.ClusterStatisticsMergeMode;
import org.apache.druid.msq.exec.SegmentSource;
import org.apache.druid.msq.indexing.destination.MSQSelectDestination;
import org.apache.druid.msq.indexing.error.MSQWarnings;
import org.apache.druid.msq.kernel.WorkerAssignmentStrategy;
import org.apache.druid.msq.rpc.SketchEncoding;
import org.apache.druid.msq.sql.MSQMode;
import org.apache.druid.msq.util.ArrayIngestMode;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.segment.IndexSpec;
import org.joda.time.DateTime;

public class MultiStageQueryContext {
    private static final Logger log = new Logger(MultiStageQueryContext.class);
    public static final String CTX_MSQ_MODE = "mode";
    public static final String DEFAULT_MSQ_MODE = MSQMode.STRICT_MODE.toString();
    public static final String CTX_MAX_NUM_TASKS = "maxNumTasks";
    @VisibleForTesting
    static final int DEFAULT_MAX_NUM_TASKS = 2;
    public static final String CTX_TASK_ASSIGNMENT_STRATEGY = "taskAssignment";
    private static final String DEFAULT_TASK_ASSIGNMENT_STRATEGY = WorkerAssignmentStrategy.MAX.toString();
    public static final String CTX_FINALIZE_AGGREGATIONS = "finalizeAggregations";
    private static final boolean DEFAULT_FINALIZE_AGGREGATIONS = true;
    public static final String CTX_INCLUDE_SEGMENT_SOURCE = "includeSegmentSource";
    public static final String CTX_MAX_CONCURRENT_STAGES = "maxConcurrentStages";
    public static final String CTX_DURABLE_SHUFFLE_STORAGE = "durableShuffleStorage";
    private static final boolean DEFAULT_DURABLE_SHUFFLE_STORAGE = false;
    public static final String CTX_SELECT_DESTINATION = "selectDestination";
    private static final String DEFAULT_SELECT_DESTINATION = MSQSelectDestination.TASKREPORT.getName();
    public static final String CTX_FAULT_TOLERANCE = "faultTolerance";
    public static final boolean DEFAULT_FAULT_TOLERANCE = false;
    public static final String CTX_FAIL_ON_EMPTY_INSERT = "failOnEmptyInsert";
    public static final boolean DEFAULT_FAIL_ON_EMPTY_INSERT = false;
    public static final String CTX_SEGMENT_LOAD_WAIT = "waitUntilSegmentsLoad";
    public static final boolean DEFAULT_SEGMENT_LOAD_WAIT = false;
    public static final String CTX_MAX_INPUT_BYTES_PER_WORKER = "maxInputBytesPerWorker";
    public static final String CTX_CLUSTER_STATISTICS_MERGE_MODE = "clusterStatisticsMergeMode";
    public static final String DEFAULT_CLUSTER_STATISTICS_MERGE_MODE = ClusterStatisticsMergeMode.SEQUENTIAL.toString();
    public static final String CTX_SKETCH_ENCODING_MODE = "sketchEncoding";
    public static final String DEFAULT_CTX_SKETCH_ENCODING_MODE = SketchEncoding.OCTET_STREAM.toString();
    public static final String CTX_ROWS_PER_SEGMENT = "rowsPerSegment";
    public static final int DEFAULT_ROWS_PER_SEGMENT = 3000000;
    public static final String CTX_ROWS_PER_PAGE = "rowsPerPage";
    public static final int DEFAULT_ROWS_PER_PAGE = 100000;
    public static final String CTX_REMOVE_NULL_BYTES = "removeNullBytes";
    public static final boolean DEFAULT_REMOVE_NULL_BYTES = false;
    public static final String CTX_ROWS_IN_MEMORY = "rowsInMemory";
    public static final int DEFAULT_ROWS_IN_MEMORY = 100000;
    public static final String CTX_IS_REINDEX = "isReindex";
    public static final String CTX_MAX_NUM_SEGMENTS = "maxNumSegments";
    public static final String CTX_START_TIME = "startTime";
    public static final String CTX_SORT_ORDER = "segmentSortOrder";
    public static final String CTX_INDEX_SPEC = "indexSpec";
    public static final String CTX_USE_AUTO_SCHEMAS = "useAutoColumnSchemas";
    public static final boolean DEFAULT_USE_AUTO_SCHEMAS = false;
    public static final String CTX_ARRAY_INGEST_MODE = "arrayIngestMode";
    public static final ArrayIngestMode DEFAULT_ARRAY_INGEST_MODE = ArrayIngestMode.ARRAY;
    public static final String CTX_INCLUDE_ALL_COUNTERS = "includeAllCounters";
    public static final boolean DEFAULT_INCLUDE_ALL_COUNTERS = false;
    public static final String CTX_FORCE_TIME_SORT = "forceSegmentSortByTime";
    private static final boolean DEFAULT_FORCE_TIME_SORT = true;
    public static final String CTX_ROW_BASED_FRAME_TYPE = "rowBasedFrameType";
    private static final FrameType DEFAULT_ROW_BASED_FRAME_TYPE = FrameType.ROW_BASED_V1;
    public static final String MAX_ROWS_MATERIALIZED_IN_WINDOW = "maxRowsMaterializedInWindow";
    public static final String WINDOW_FUNCTION_OPERATOR_TRANSFORMATION = "windowFunctionOperatorTransformation";
    public static final String CTX_SKIP_TYPE_VERIFICATION = "skipTypeVerification";
    public static final String CTX_TARGET_PARTITIONS_PER_WORKER = "targetPartitionsPerWorker";
    public static final String CTX_MAX_FRAME_SIZE = "maxFrameSize";
    public static final String CTX_MAX_THREADS = "maxThreads";
    private static final Pattern LOOKS_LIKE_JSON_ARRAY = Pattern.compile("^\\s*\\[.*", 32);

    public static String getMSQMode(QueryContext queryContext) {
        return queryContext.getString(CTX_MSQ_MODE, DEFAULT_MSQ_MODE);
    }

    public static int getMaxRowsMaterializedInWindow(QueryContext queryContext) {
        return queryContext.getInt(MAX_ROWS_MATERIALIZED_IN_WINDOW, 100000);
    }

    public static boolean isWindowFunctionOperatorTransformationEnabled(QueryContext queryContext) {
        return queryContext.getBoolean(WINDOW_FUNCTION_OPERATOR_TRANSFORMATION, false);
    }

    public static int getMaxConcurrentStagesWithDefault(QueryContext queryContext, int defaultMaxConcurrentStages) {
        return queryContext.getInt(CTX_MAX_CONCURRENT_STAGES, defaultMaxConcurrentStages);
    }

    public static boolean isDurableStorageEnabled(QueryContext queryContext) {
        return queryContext.getBoolean(CTX_DURABLE_SHUFFLE_STORAGE, false);
    }

    public static boolean isFaultToleranceEnabled(QueryContext queryContext) {
        return queryContext.getBoolean(CTX_FAULT_TOLERANCE, false);
    }

    public static boolean isFailOnEmptyInsertEnabled(QueryContext queryContext) {
        return queryContext.getBoolean(CTX_FAIL_ON_EMPTY_INSERT, false);
    }

    public static boolean shouldWaitForSegmentLoad(QueryContext queryContext) {
        return queryContext.getBoolean(CTX_SEGMENT_LOAD_WAIT, false);
    }

    public static boolean isReindex(QueryContext queryContext) {
        return queryContext.getBoolean(CTX_IS_REINDEX, false);
    }

    public static long getMaxInputBytesPerWorker(QueryContext queryContext) {
        return queryContext.getLong(CTX_MAX_INPUT_BYTES_PER_WORKER, 0x20000000L);
    }

    public static ClusterStatisticsMergeMode getClusterStatisticsMergeMode(QueryContext queryContext) {
        return (ClusterStatisticsMergeMode)QueryContexts.getAsEnum((String)CTX_CLUSTER_STATISTICS_MERGE_MODE, (Object)queryContext.getString(CTX_CLUSTER_STATISTICS_MERGE_MODE, DEFAULT_CLUSTER_STATISTICS_MERGE_MODE), ClusterStatisticsMergeMode.class);
    }

    public static SketchEncoding getSketchEncoding(QueryContext queryContext) {
        return (SketchEncoding)QueryContexts.getAsEnum((String)CTX_SKETCH_ENCODING_MODE, (Object)queryContext.getString(CTX_SKETCH_ENCODING_MODE, DEFAULT_CTX_SKETCH_ENCODING_MODE), SketchEncoding.class);
    }

    public static boolean isFinalizeAggregations(QueryContext queryContext) {
        return queryContext.getBoolean(CTX_FINALIZE_AGGREGATIONS, true);
    }

    public static SegmentSource getSegmentSources(QueryContext queryContext, SegmentSource defaultSource) {
        return (SegmentSource)queryContext.getEnum(CTX_INCLUDE_SEGMENT_SOURCE, SegmentSource.class, (Enum)defaultSource);
    }

    public static WorkerAssignmentStrategy getAssignmentStrategy(QueryContext queryContext) {
        return (WorkerAssignmentStrategy)QueryContexts.getAsEnum((String)CTX_TASK_ASSIGNMENT_STRATEGY, (Object)queryContext.getString(CTX_TASK_ASSIGNMENT_STRATEGY, DEFAULT_TASK_ASSIGNMENT_STRATEGY), WorkerAssignmentStrategy.class);
    }

    public static int getMaxNumTasks(QueryContext queryContext) {
        return queryContext.getInt(CTX_MAX_NUM_TASKS, 2);
    }

    public static int getRowsPerSegment(QueryContext queryContext) {
        return queryContext.getInt(CTX_ROWS_PER_SEGMENT, 3000000);
    }

    public static int getRowsPerPage(QueryContext queryContext) {
        return queryContext.getInt(CTX_ROWS_PER_PAGE, 100000);
    }

    public static boolean removeNullBytes(QueryContext queryContext) {
        return queryContext.getBoolean(CTX_REMOVE_NULL_BYTES, false);
    }

    public static boolean isDartQuery(QueryContext queryContext) {
        return queryContext.get("dartQueryId") != null;
    }

    public static MSQSelectDestination getSelectDestination(QueryContext queryContext) {
        MSQSelectDestination destination = (MSQSelectDestination)QueryContexts.getAsEnum((String)CTX_SELECT_DESTINATION, (Object)queryContext.getString(CTX_SELECT_DESTINATION, DEFAULT_SELECT_DESTINATION), MSQSelectDestination.class);
        if (MultiStageQueryContext.isDartQuery(queryContext)) {
            if (!MSQSelectDestination.TASKREPORT.equals((Object)destination)) {
                log.warn("Dart does not support [%s]. Using [%s] instead.", new Object[]{destination, MSQSelectDestination.TASKREPORT});
            }
            return MSQSelectDestination.TASKREPORT;
        }
        return destination;
    }

    public static int getRowsInMemory(QueryContext queryContext) {
        return queryContext.getInt(CTX_ROWS_IN_MEMORY, 100000);
    }

    public static Integer getMaxNumSegments(QueryContext queryContext) {
        return queryContext.getInt(CTX_MAX_NUM_SEGMENTS);
    }

    public static List<String> getSortOrder(QueryContext queryContext) {
        return MultiStageQueryContext.decodeList(CTX_SORT_ORDER, queryContext.getString(CTX_SORT_ORDER));
    }

    @Nullable
    public static IndexSpec getIndexSpec(QueryContext queryContext, ObjectMapper objectMapper) {
        return MultiStageQueryContext.decodeIndexSpec(queryContext.get(CTX_INDEX_SPEC), objectMapper);
    }

    public static long getMaxParseExceptions(QueryContext queryContext) {
        return queryContext.getLong("maxParseExceptions", MSQWarnings.DEFAULT_MAX_PARSE_EXCEPTIONS_ALLOWED.longValue());
    }

    public static boolean useAutoColumnSchemas(QueryContext queryContext) {
        return queryContext.getBoolean(CTX_USE_AUTO_SCHEMAS, false);
    }

    public static ArrayIngestMode getArrayIngestMode(QueryContext queryContext) {
        return (ArrayIngestMode)queryContext.getEnum(CTX_ARRAY_INGEST_MODE, ArrayIngestMode.class, (Enum)DEFAULT_ARRAY_INGEST_MODE);
    }

    public static int getTargetPartitionsPerWorkerWithDefault(QueryContext queryContext, int defaultValue) {
        return queryContext.getInt(CTX_TARGET_PARTITIONS_PER_WORKER, defaultValue);
    }

    public static boolean getIncludeAllCounters(QueryContext queryContext) {
        return queryContext.getBoolean(CTX_INCLUDE_ALL_COUNTERS, false);
    }

    public static boolean isForceSegmentSortByTime(QueryContext queryContext) {
        return queryContext.getBoolean(CTX_FORCE_TIME_SORT, true);
    }

    public static FrameType getRowBasedFrameType(QueryContext queryContext) {
        return FrameType.forVersion((byte)((byte)queryContext.getInt(CTX_ROW_BASED_FRAME_TYPE, (int)DEFAULT_ROW_BASED_FRAME_TYPE.version())));
    }

    public static DateTime getStartTime(QueryContext queryContext) {
        if (!queryContext.containsKey(CTX_START_TIME)) {
            DateTime startTime = DateTimes.nowUtc();
            log.warn("Query context does not contain start time. Defaulting to the current time[%s] instead.", new Object[]{startTime});
            return startTime;
        }
        return DateTimes.of((String)queryContext.getString(CTX_START_TIME));
    }

    public static Set<String> getColumnsExcludedFromTypeVerification(QueryContext queryContext) {
        return new HashSet<String>(MultiStageQueryContext.decodeList(CTX_SKIP_TYPE_VERIFICATION, queryContext.getString(CTX_SKIP_TYPE_VERIFICATION)));
    }

    public static int getFrameSize(QueryContext queryContext) {
        return queryContext.getInt(CTX_MAX_FRAME_SIZE, 1000000);
    }

    public static Integer getMaxThreads(QueryContext queryContext) {
        return queryContext.getInt(CTX_MAX_THREADS);
    }

    @VisibleForTesting
    static List<String> decodeList(String keyName, @Nullable String listString) {
        if (listString == null) {
            return Collections.emptyList();
        }
        if (LOOKS_LIKE_JSON_ARRAY.matcher(listString).matches()) {
            try {
                return (List)new ObjectMapper().readValue(listString, (TypeReference)new TypeReference<List<String>>(){});
            }
            catch (JsonProcessingException e) {
                throw QueryContexts.badValueException((String)keyName, (String)"CSV or JSON array", (Object)listString);
            }
        }
        RFC4180Parser csvParser = new RFC4180ParserBuilder().withSeparator(',').build();
        try {
            return Arrays.stream(csvParser.parseLine(listString)).filter(s -> s != null && !s.isEmpty()).map(String::trim).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw QueryContexts.badValueException((String)keyName, (String)"CSV or JSON array", (Object)listString);
        }
    }

    @Nullable
    @VisibleForTesting
    static IndexSpec decodeIndexSpec(@Nullable Object indexSpecObject, ObjectMapper objectMapper) {
        try {
            if (indexSpecObject == null) {
                return null;
            }
            if (indexSpecObject instanceof String) {
                return (IndexSpec)objectMapper.readValue((String)indexSpecObject, IndexSpec.class);
            }
            return (IndexSpec)objectMapper.convertValue(indexSpecObject, IndexSpec.class);
        }
        catch (Exception e) {
            throw QueryContexts.badValueException((String)CTX_INDEX_SPEC, (String)"an indexSpec", (Object)indexSpecObject);
        }
    }

    public static TaskLockType validateAndGetTaskLockType(QueryContext queryContext, boolean isReplaceQuery) {
        boolean useConcurrentLocks = queryContext.getBoolean("useConcurrentLocks", false);
        if (useConcurrentLocks) {
            return isReplaceQuery ? TaskLockType.REPLACE : TaskLockType.APPEND;
        }
        TaskLockType taskLockType = (TaskLockType)QueryContexts.getAsEnum((String)"taskLockType", (Object)queryContext.getString("taskLockType", null), TaskLockType.class);
        if (taskLockType == null) {
            if (isReplaceQuery) {
                return TaskLockType.EXCLUSIVE;
            }
            return TaskLockType.SHARED;
        }
        String appendErrorMessage = StringUtils.format((String)" Please use [%s] key in the context parameter and use one of the TaskLock types as mentioned earlier or remove this key for automatic lock type selection", (Object[])new Object[]{"taskLockType"});
        if (isReplaceQuery && !taskLockType.equals((Object)TaskLockType.EXCLUSIVE) && !taskLockType.equals((Object)TaskLockType.REPLACE)) {
            throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.USER).ofCategory(DruidException.Category.INVALID_INPUT).build("TaskLock must be of type [%s] or [%s] for a REPLACE query. Found invalid type [%s] set." + appendErrorMessage, new Object[]{TaskLockType.EXCLUSIVE, TaskLockType.REPLACE, taskLockType});
        }
        if (!(isReplaceQuery || taskLockType.equals((Object)TaskLockType.SHARED) || taskLockType.equals((Object)TaskLockType.APPEND))) {
            throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.USER).ofCategory(DruidException.Category.INVALID_INPUT).build("TaskLock must be of type [%s] or [%s] for an INSERT query. Found invalid type [%s] set." + appendErrorMessage, new Object[]{TaskLockType.SHARED, TaskLockType.APPEND, taskLockType});
        }
        return taskLockType;
    }
}

