/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.util;

import javax.annotation.Nullable;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.data.input.impl.DoubleDimensionSchema;
import org.apache.druid.data.input.impl.FloatDimensionSchema;
import org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.AlertEvent;
import org.apache.druid.msq.util.ArrayIngestMode;
import org.apache.druid.segment.AutoTypeColumnSchema;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.ValueType;

public class DimensionSchemaUtils {
    private static final EmittingLogger LOG = new EmittingLogger(DimensionSchemaUtils.class);

    public static DimensionSchema createDimensionSchemaForExtern(String column, @Nullable ColumnType type) {
        return DimensionSchemaUtils.createDimensionSchema(column, type, false, ArrayIngestMode.ARRAY);
    }

    public static DimensionSchema createDimensionSchema(String column, @Nullable ColumnType queryType, boolean useAutoType, ArrayIngestMode arrayIngestMode) {
        if (useAutoType) {
            if (queryType != null && queryType.is((TypeDescriptor)ValueType.COMPLEX) && !ColumnType.NESTED_DATA.equals((Object)queryType)) {
                ColumnCapabilitiesImpl capabilities = ColumnCapabilitiesImpl.createDefault().setType(queryType);
                return DimensionHandlerUtils.getHandlerFromCapabilities((String)column, (ColumnCapabilities)capabilities, null).getDimensionSchema((ColumnCapabilities)capabilities);
            }
            if (queryType != null && (queryType.isPrimitive() || queryType.isPrimitiveArray())) {
                return new AutoTypeColumnSchema(column, queryType, null);
            }
            return AutoTypeColumnSchema.of((String)column);
        }
        ColumnType dimensionType = DimensionSchemaUtils.getDimensionType(column, queryType, arrayIngestMode);
        if (dimensionType.getType() == ValueType.STRING) {
            return new StringDimensionSchema(column, queryType != null && queryType.isArray() ? DimensionSchema.MultiValueHandling.ARRAY : DimensionSchema.MultiValueHandling.SORTED_ARRAY, null);
        }
        if (dimensionType.getType() == ValueType.LONG) {
            return new LongDimensionSchema(column);
        }
        if (dimensionType.getType() == ValueType.FLOAT) {
            return new FloatDimensionSchema(column);
        }
        if (dimensionType.getType() == ValueType.DOUBLE) {
            return new DoubleDimensionSchema(column);
        }
        if (dimensionType.getType() == ValueType.ARRAY) {
            return new AutoTypeColumnSchema(column, dimensionType, null);
        }
        ColumnCapabilitiesImpl capabilities = ColumnCapabilitiesImpl.createDefault().setType(dimensionType);
        return DimensionHandlerUtils.getHandlerFromCapabilities((String)column, (ColumnCapabilities)capabilities, null).getDimensionSchema((ColumnCapabilities)capabilities);
    }

    public static ColumnType getDimensionType(String columnName, @Nullable ColumnType queryType, ArrayIngestMode arrayIngestMode) {
        if (queryType == null) {
            return ColumnType.STRING;
        }
        if (queryType.getType() == ValueType.ARRAY) {
            ValueType elementType = (ValueType)queryType.getElementType().getType();
            if (elementType == ValueType.STRING) {
                if (arrayIngestMode == ArrayIngestMode.MVD) {
                    String msgFormat = "Inserting a multi-value string column[%s] relying on deprecated ArrayIngestMode.MVD. This query should be rewritten to use the ARRAY_TO_MV operator to insert ARRAY types as multi-value strings.";
                    LOG.makeWarningAlert("Inserting a multi-value string column[%s] relying on deprecated ArrayIngestMode.MVD. This query should be rewritten to use the ARRAY_TO_MV operator to insert ARRAY types as multi-value strings.", new Object[]{columnName}).severity(AlertEvent.Severity.DEPRECATED).addData("feature", (Object)"ArrayIngestMode.MVD").emit();
                    return ColumnType.STRING;
                }
                return queryType;
            }
            if (elementType.isNumeric()) {
                if (arrayIngestMode == ArrayIngestMode.ARRAY) {
                    return queryType;
                }
                throw InvalidInput.exception((String)"Numeric arrays can only be ingested when '%s' is set to 'array'. Current value of the parameter is[%s]", (Object[])new Object[]{"arrayIngestMode", StringUtils.toLowerCase((String)arrayIngestMode.name())});
            }
            throw new ISE("Cannot create dimension for type[%s]", new Object[]{queryType.toString()});
        }
        return queryType;
    }
}

