/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.shuffle.output;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.Closeable;
import java.io.InputStream;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.frame.channel.ReadableFileFrameChannel;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.ReadableNilFrameChannel;
import org.apache.druid.frame.file.FrameFile;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.msq.shuffle.output.ChannelStageOutputReader;
import org.apache.druid.msq.shuffle.output.FileStageOutputReader;
import org.apache.druid.msq.shuffle.output.FutureReadableFrameChannel;
import org.apache.druid.msq.shuffle.output.NilStageOutputReader;
import org.apache.druid.msq.shuffle.output.StageOutputReader;
import org.apache.druid.utils.CloseableUtils;

public class StageOutputHolder
implements Closeable {
    private final SettableFuture<ReadableFrameChannel> channelFuture = SettableFuture.create();
    private final ListenableFuture<StageOutputReader> readerFuture = FutureUtils.transform(this.channelFuture, StageOutputHolder::createReader);

    public ListenableFuture<InputStream> readRemotelyFrom(long offset) {
        return FutureUtils.transformAsync(this.readerFuture, reader -> reader.readRemotelyFrom(offset));
    }

    public ReadableFrameChannel readLocally() {
        return new FutureReadableFrameChannel((ListenableFuture<ReadableFrameChannel>)FutureUtils.transform(this.readerFuture, StageOutputReader::readLocally));
    }

    public void setChannel(ReadableFrameChannel channel) {
        if (!this.channelFuture.set((Object)channel)) {
            if (FutureUtils.getUncheckedImmediately(this.channelFuture) == null) {
                throw new ISE("Closed", new Object[0]);
            }
            throw new ISE("Channel already set", new Object[0]);
        }
    }

    @Override
    public void close() {
        StageOutputReader reader;
        this.channelFuture.set(null);
        try {
            reader = (StageOutputReader)FutureUtils.getUnchecked(this.readerFuture, (boolean)true);
        }
        catch (Throwable e) {
            return;
        }
        if (reader != null) {
            CloseableUtils.closeAndWrapExceptions((Closeable)reader);
        }
    }

    private static StageOutputReader createReader(ReadableFrameChannel channel) {
        ReadableFileFrameChannel fileChannel;
        if (channel == null) {
            throw new ISE("Closed", new Object[0]);
        }
        if (channel instanceof ReadableNilFrameChannel) {
            return NilStageOutputReader.INSTANCE;
        }
        if (channel instanceof ReadableFileFrameChannel && (fileChannel = (ReadableFileFrameChannel)channel).isEntireFile()) {
            FrameFile frameFile = fileChannel.newFrameFileReference();
            channel.close();
            return new FileStageOutputReader(frameFile);
        }
        return new ChannelStageOutputReader(channel);
    }
}

