/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.shuffle.output;

import java.io.File;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.apache.druid.frame.allocation.ArenaMemoryAllocator;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.apache.druid.frame.channel.ByteTracker;
import org.apache.druid.frame.channel.ReadableNilFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameFileChannel;
import org.apache.druid.frame.file.FrameFileWriter;
import org.apache.druid.frame.processor.OutputChannel;
import org.apache.druid.frame.processor.PartitionedOutputChannel;
import org.apache.druid.frame.util.DurableStorageUtils;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.msq.shuffle.output.DurableStorageOutputChannelFactory;
import org.apache.druid.storage.StorageConnector;

public class DurableStorageQueryResultsOutputChannelFactory
extends DurableStorageOutputChannelFactory {
    public DurableStorageQueryResultsOutputChannelFactory(String controllerTaskId, int workerNumber, int stageNumber, String taskId, int frameSize, StorageConnector storageConnector, File tmpDir) {
        super(controllerTaskId, workerNumber, stageNumber, taskId, frameSize, storageConnector, tmpDir);
    }

    @Override
    public String getSuccessFilePath() {
        return DurableStorageUtils.getQueryResultsSuccessFilePath((String)this.controllerTaskId, (int)this.stageNumber, (int)this.workerNumber);
    }

    @Override
    protected String getFileNameWithPathForPartition(int partitionNumber) {
        return DurableStorageUtils.getQueryResultsFileNameWithPathForPartition((String)this.controllerTaskId, (int)this.stageNumber, (int)this.workerNumber, (String)this.taskId, (int)partitionNumber);
    }

    public OutputChannel openChannel(int partitionNumber) throws IOException {
        String fileName = this.getFileNameWithPathForPartition(partitionNumber);
        WritableFrameFileChannel writableChannel = new WritableFrameFileChannel(FrameFileWriter.open((WritableByteChannel)Channels.newChannel(this.storageConnector.write(fileName)), null, (ByteTracker)ByteTracker.unboundedTracker()));
        return OutputChannel.pair((WritableFrameChannel)writableChannel, (MemoryAllocator)ArenaMemoryAllocator.createOnHeap((int)this.frameSize), () -> ReadableNilFrameChannel.INSTANCE, (int)partitionNumber);
    }

    public PartitionedOutputChannel openPartitionedChannel(String name, boolean deleteAfterRead) {
        throw new UOE("%s does not support this call", new Object[]{DurableStorageQueryResultsOutputChannelFactory.class.getSimpleName()});
    }
}

