/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.querykit;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.error.DruidException;
import org.apache.druid.frame.channel.ReadableConcatFrameChannel;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.processor.FrameProcessor;
import org.apache.druid.frame.processor.OutputChannel;
import org.apache.druid.frame.processor.OutputChannelFactory;
import org.apache.druid.frame.processor.OutputChannels;
import org.apache.druid.frame.processor.manager.ProcessorManager;
import org.apache.druid.frame.processor.manager.ProcessorManagers;
import org.apache.druid.frame.write.FrameWriterFactory;
import org.apache.druid.msq.counters.CounterTracker;
import org.apache.druid.msq.exec.FrameContext;
import org.apache.druid.msq.exec.std.BasicStandardStageProcessor;
import org.apache.druid.msq.exec.std.ProcessorsAndChannels;
import org.apache.druid.msq.input.InputSlice;
import org.apache.druid.msq.input.InputSliceReader;
import org.apache.druid.msq.input.InputSlices;
import org.apache.druid.msq.input.ReadableInput;
import org.apache.druid.msq.input.ReadableInputs;
import org.apache.druid.msq.input.external.ExternalInputSlice;
import org.apache.druid.msq.input.stage.StageInputSlice;
import org.apache.druid.msq.input.table.SegmentsInputSlice;
import org.apache.druid.msq.kernel.StageDefinition;
import org.apache.druid.msq.querykit.BaseLeafFrameProcessorManager;
import org.apache.druid.msq.querykit.BroadcastJoinSegmentMapFnProcessor;
import org.apache.druid.msq.querykit.ChainedProcessorManager;
import org.apache.druid.msq.querykit.SimpleSegmentMapFnProcessor;
import org.apache.druid.query.Query;
import org.apache.druid.query.planning.ExecutionVertex;
import org.apache.druid.segment.SegmentMapFunction;
import org.apache.druid.utils.CollectionUtils;

public abstract class BaseLeafStageProcessor
extends BasicStandardStageProcessor {
    private final Query<?> query;

    protected BaseLeafStageProcessor(Query<?> query) {
        this.query = query;
    }

    @Override
    public ProcessorsAndChannels<Object, Long> makeProcessors(StageDefinition stageDefinition, int workerNumber, List<InputSlice> inputSlices, InputSliceReader inputSliceReader, @Nullable Object extra, OutputChannelFactory outputChannelFactory, FrameContext frameContext, int maxOutstandingProcessors, CounterTracker counters, Consumer<Throwable> warningPublisher) throws IOException {
        ChainedProcessorManager processorManager;
        int totalProcessors = InputSlices.getNumNonBroadcastReadableInputs(inputSlices, inputSliceReader, stageDefinition.getBroadcastInputNumbers());
        if (totalProcessors == 0) {
            return new ProcessorsAndChannels<Object, Long>(ProcessorManagers.none(), OutputChannels.none());
        }
        int outstandingProcessors = BaseLeafStageProcessor.hasParquet(inputSlices) ? 1 : Math.min(totalProcessors, maxOutstandingProcessors);
        ArrayDeque<FrameWriterFactory> frameWriterFactoryQueue = new ArrayDeque<FrameWriterFactory>(outstandingProcessors);
        ArrayDeque<WritableFrameChannel> channelQueue = new ArrayDeque<WritableFrameChannel>(outstandingProcessors);
        ArrayList<OutputChannel> outputChannels = new ArrayList<OutputChannel>(outstandingProcessors);
        for (int i = 0; i < outstandingProcessors; ++i) {
            OutputChannel outputChannel = outputChannelFactory.openChannel(0);
            outputChannels.add(outputChannel);
            channelQueue.add(outputChannel.getWritableChannel());
            frameWriterFactoryQueue.add(stageDefinition.createFrameWriterFactory(frameContext.frameWriterSpec(), outputChannel.getFrameMemoryAllocator()));
        }
        FrameProcessor<SegmentMapFunction> segmentMapFnProcessor = this.makeSegmentMapFnProcessor(stageDefinition, inputSlices, inputSliceReader, frameContext, counters, warningPublisher);
        Function processorManagerFn = segmentMapFnList -> {
            SegmentMapFunction segmentMapFunction = (SegmentMapFunction)CollectionUtils.getOnlyElement((Iterable)segmentMapFnList, throwable -> DruidException.defensive((String)"Only one segment map function expected", (Object[])new Object[0]));
            return this.createBaseLeafProcessorManagerWithHandoff(stageDefinition, inputSlices, inputSliceReader, counters, warningPublisher, segmentMapFunction, frameWriterFactoryQueue, channelQueue, frameContext);
        };
        if (segmentMapFnProcessor == null) {
            SegmentMapFunction segmentMapFn = ExecutionVertex.of(this.query).createSegmentMapFunction(frameContext.policyEnforcer());
            processorManager = processorManagerFn.apply(ImmutableList.of((Object)segmentMapFn));
        } else {
            processorManager = new ChainedProcessorManager(ProcessorManagers.of(() -> segmentMapFnProcessor), processorManagerFn);
        }
        return new ProcessorsAndChannels<Object, Long>(processorManager, OutputChannels.wrap(outputChannels));
    }

    private ProcessorManager<Object, Long> createBaseLeafProcessorManagerWithHandoff(StageDefinition stageDefinition, List<InputSlice> inputSlices, InputSliceReader inputSliceReader, CounterTracker counters, Consumer<Throwable> warningPublisher, SegmentMapFunction segmentMapFunction, Queue<FrameWriterFactory> frameWriterFactoryQueue, Queue<WritableFrameChannel> channelQueue, FrameContext frameContext) {
        BaseLeafStageProcessor factory = this;
        Iterable<ReadableInput> processorBaseInputs = BaseLeafStageProcessor.readBaseInputs(stageDefinition, inputSlices, inputSliceReader, counters, warningPublisher);
        return new ChainedProcessorManager(new BaseLeafFrameProcessorManager(processorBaseInputs, segmentMapFunction, frameWriterFactoryQueue, channelQueue, frameContext, factory), objects -> {
            if (objects == null || objects.isEmpty()) {
                return ProcessorManagers.none();
            }
            ArrayList<InputSlice> handedOffSegments = new ArrayList<InputSlice>();
            for (Object o : objects) {
                if (o == null || !(o instanceof SegmentsInputSlice)) continue;
                SegmentsInputSlice slice = (SegmentsInputSlice)o;
                handedOffSegments.add(slice);
            }
            return new BaseLeafFrameProcessorManager(BaseLeafStageProcessor.readBaseInputs(stageDefinition, handedOffSegments, inputSliceReader, counters, warningPublisher), segmentMapFunction, frameWriterFactoryQueue, channelQueue, frameContext, factory);
        });
    }

    protected abstract FrameProcessor<Object> makeProcessor(ReadableInput var1, SegmentMapFunction var2, ResourceHolder<WritableFrameChannel> var3, ResourceHolder<FrameWriterFactory> var4, FrameContext var5);

    private static Iterable<ReadableInput> readBaseInputs(StageDefinition stageDef, List<InputSlice> inputSlices, InputSliceReader inputSliceReader, CounterTracker counters, Consumer<Throwable> warningPublisher) {
        ArrayList<ReadableInputs> inputss = new ArrayList<ReadableInputs>();
        for (int inputNumber = 0; inputNumber < inputSlices.size(); ++inputNumber) {
            if (stageDef.getBroadcastInputNumbers().contains(inputNumber)) continue;
            ReadableInputs inputs = inputSliceReader.attach(inputNumber, inputSlices.get(inputNumber), counters, warningPublisher);
            inputss.add(inputs);
        }
        return Iterables.concat(inputss);
    }

    private static Int2ObjectMap<ReadableInput> readBroadcastInputsFromEarlierStages(StageDefinition stageDef, List<InputSlice> inputSlices, InputSliceReader inputSliceReader, CounterTracker counterTracker, Consumer<Throwable> warningPublisher) {
        Int2ObjectAVLTreeMap broadcastInputs = new Int2ObjectAVLTreeMap();
        try {
            for (int inputNumber = 0; inputNumber < inputSlices.size(); ++inputNumber) {
                if (!stageDef.getBroadcastInputNumbers().contains(inputNumber) || !(inputSlices.get(inputNumber) instanceof StageInputSlice)) continue;
                StageInputSlice slice = (StageInputSlice)inputSlices.get(inputNumber);
                ReadableInputs readableInputs = inputSliceReader.attach(inputNumber, slice, counterTracker, warningPublisher);
                ReadableConcatFrameChannel channel = ReadableConcatFrameChannel.open((Iterator)Iterators.transform(readableInputs.iterator(), ReadableInput::getChannel));
                broadcastInputs.put(inputNumber, (Object)ReadableInput.channel((ReadableFrameChannel)channel, readableInputs.frameReader(), null));
            }
            return broadcastInputs;
        }
        catch (Throwable e) {
            try {
                broadcastInputs.values().forEach(input -> input.getChannel().close());
            }
            catch (Throwable e2) {
                e.addSuppressed(e2);
            }
            throw e;
        }
    }

    @Nullable
    private FrameProcessor<SegmentMapFunction> makeSegmentMapFnProcessor(StageDefinition stageDefinition, List<InputSlice> inputSlices, InputSliceReader inputSliceReader, FrameContext frameContext, CounterTracker counters, Consumer<Throwable> warningPublisher) {
        Int2ObjectMap<ReadableInput> broadcastInputs = BaseLeafStageProcessor.readBroadcastInputsFromEarlierStages(stageDefinition, inputSlices, inputSliceReader, counters, warningPublisher);
        if (broadcastInputs.isEmpty()) {
            if (ExecutionVertex.of(this.query).isSegmentMapFunctionExpensive()) {
                return new SimpleSegmentMapFnProcessor(this.query, frameContext.policyEnforcer());
            }
            return null;
        }
        return BroadcastJoinSegmentMapFnProcessor.create(this.query, frameContext.policyEnforcer(), broadcastInputs, frameContext.memoryParameters().getBroadcastBufferMemory());
    }

    private static boolean hasParquet(List<InputSlice> slices) {
        return slices.stream().anyMatch(slice -> slice instanceof ExternalInputSlice && ((ExternalInputSlice)slice).getInputFormat().getClass().getName().contains("Parquet"));
    }
}

