/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.logical;

import java.util.Collections;
import java.util.Set;
import org.apache.druid.msq.input.InputSpec;
import org.apache.druid.msq.input.stage.StageInputSpec;
import org.apache.druid.msq.kernel.StageDefinitionBuilder;
import org.apache.druid.msq.logical.StageMaker;
import org.apache.druid.msq.logical.stages.LogicalStage;
import org.apache.druid.msq.querykit.InputNumberDataSource;
import org.apache.druid.query.DataSource;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.planner.querygen.SourceDescProducer;

public abstract class LogicalInputSpec {
    final int inputIndex;
    final Set<InputProperty> props;

    public LogicalInputSpec(int inputIndex, Set<InputProperty> props) {
        this.inputIndex = inputIndex;
        this.props = props;
    }

    public abstract InputSpec toInputSpec(StageMaker var1);

    public abstract RowSignature getRowSignature();

    public final SourceDescProducer.SourceDesc getSourceDesc() {
        InputNumberDataSource ds = new InputNumberDataSource(this.inputIndex);
        return new SourceDescProducer.SourceDesc((DataSource)ds, this.getRowSignature());
    }

    public final boolean hasProperty(InputProperty prop) {
        return this.props.contains((Object)prop);
    }

    public static LogicalInputSpec of(LogicalStage inputStage) {
        return LogicalInputSpec.of(inputStage, 0, Collections.emptySet());
    }

    public static LogicalInputSpec of(InputSpec inputSpec, RowSignature rowSignature) {
        return new PhysicalInputSpec(inputSpec, 0, rowSignature, Collections.emptySet());
    }

    public static LogicalInputSpec of(LogicalStage logicalStage, int inputIndex, InputProperty prop) {
        return LogicalInputSpec.of(logicalStage, inputIndex, Collections.singleton(prop));
    }

    public static LogicalInputSpec of(LogicalStage logicalStage, int inputIndex, Set<InputProperty> props) {
        return new DagStageInputSpec(logicalStage, inputIndex, props);
    }

    static class PhysicalInputSpec
    extends LogicalInputSpec {
        private InputSpec inputSpec;
        private RowSignature rowSignature;

        public PhysicalInputSpec(InputSpec inputSpec, int inputIndex, RowSignature rowSignature, Set<InputProperty> props) {
            super(inputIndex, props);
            this.inputSpec = inputSpec;
            this.rowSignature = rowSignature;
        }

        @Override
        public InputSpec toInputSpec(StageMaker maker) {
            return this.inputSpec;
        }

        @Override
        public RowSignature getRowSignature() {
            return this.rowSignature;
        }
    }

    static class DagStageInputSpec
    extends LogicalInputSpec {
        protected LogicalStage inputStage;

        public DagStageInputSpec(LogicalStage inputStage, int inputIndex, Set<InputProperty> props) {
            super(inputIndex, props);
            this.inputStage = inputStage;
        }

        @Override
        public InputSpec toInputSpec(StageMaker maker) {
            StageDefinitionBuilder stage = maker.buildStage(this.inputStage);
            return new StageInputSpec(stage.getStageNumber());
        }

        public LogicalStage getStage() {
            return this.inputStage;
        }

        @Override
        public RowSignature getRowSignature() {
            return this.inputStage.getLogicalRowSignature();
        }
    }

    public static enum InputProperty {
        BROADCAST;

    }
}

