/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;
import org.apache.druid.msq.indexing.error.BaseMSQFault;

@JsonTypeName(value="TooManyClusteredByColumns")
public class TooManyClusteredByColumnsFault
extends BaseMSQFault {
    static final String CODE = "TooManyClusteredByColumns";
    private final int numColumns;
    private final int maxColumns;
    private final int stage;

    @JsonCreator
    public TooManyClusteredByColumnsFault(@JsonProperty(value="numColumns") int numColumns, @JsonProperty(value="maxColumns") int maxColumns, @JsonProperty(value="stage") int stage) {
        super(CODE, "Too many cluster by columns present in stage [%s] (requested = %d, max = %d)", stage, numColumns, maxColumns);
        this.numColumns = numColumns;
        this.maxColumns = maxColumns;
        this.stage = stage;
    }

    @JsonProperty
    public int getNumColumns() {
        return this.numColumns;
    }

    @JsonProperty
    public int getMaxColumns() {
        return this.maxColumns;
    }

    @JsonProperty
    public int getStage() {
        return this.stage;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TooManyClusteredByColumnsFault that = (TooManyClusteredByColumnsFault)o;
        return this.numColumns == that.numColumns && this.maxColumns == that.maxColumns && this.stage == that.stage;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.numColumns, this.maxColumns, this.stage);
    }
}

