/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.druid.msq.indexing.MSQTuningConfig;
import org.apache.druid.msq.indexing.destination.MSQDestination;
import org.apache.druid.msq.kernel.WorkerAssignmentStrategy;
import org.apache.druid.query.QueryContext;
import org.apache.druid.sql.calcite.planner.ColumnMappings;

public abstract class MSQSpec {
    protected final ColumnMappings columnMappings;
    protected final MSQDestination destination;
    protected final WorkerAssignmentStrategy assignmentStrategy;
    protected final MSQTuningConfig tuningConfig;

    public MSQSpec() {
        this.columnMappings = null;
        this.destination = null;
        this.assignmentStrategy = null;
        this.tuningConfig = null;
    }

    @JsonCreator
    public MSQSpec(@JsonProperty(value="columnMappings") ColumnMappings columnMappings, @JsonProperty(value="destination") MSQDestination destination, @JsonProperty(value="assignmentStrategy") WorkerAssignmentStrategy assignmentStrategy, @JsonProperty(value="tuningConfig") MSQTuningConfig tuningConfig) {
        this.columnMappings = (ColumnMappings)Preconditions.checkNotNull((Object)columnMappings, (Object)"columnMappings");
        this.destination = (MSQDestination)Preconditions.checkNotNull((Object)destination, (Object)"destination");
        this.assignmentStrategy = (WorkerAssignmentStrategy)((Object)Preconditions.checkNotNull((Object)((Object)assignmentStrategy), (Object)"assignmentStrategy"));
        this.tuningConfig = (MSQTuningConfig)Preconditions.checkNotNull((Object)tuningConfig, (Object)"tuningConfig");
    }

    public abstract QueryContext getContext();

    @JsonProperty(value="columnMappings")
    public ColumnMappings getColumnMappings() {
        return this.columnMappings;
    }

    @JsonProperty
    public MSQDestination getDestination() {
        return this.destination;
    }

    @JsonProperty
    public WorkerAssignmentStrategy getAssignmentStrategy() {
        return this.assignmentStrategy;
    }

    @JsonProperty
    public MSQTuningConfig getTuningConfig() {
        return this.tuningConfig;
    }

    public String getId() {
        return this.getContext().getString("queryId");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MSQSpec that = (MSQSpec)o;
        return Objects.equals(this.columnMappings, that.columnMappings) && Objects.equals(this.destination, that.destination) && Objects.equals((Object)this.assignmentStrategy, (Object)that.assignmentStrategy) && Objects.equals(this.tuningConfig, that.tuningConfig);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.columnMappings, this.destination, this.assignmentStrategy, this.tuningConfig});
    }
}

