/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.druid.frame.FrameType;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.msq.exec.Controller;
import org.apache.druid.msq.exec.ControllerContext;
import org.apache.druid.msq.exec.ControllerMemoryParameters;
import org.apache.druid.msq.exec.MSQMetriceEventBuilder;
import org.apache.druid.msq.exec.MemoryIntrospector;
import org.apache.druid.msq.exec.SegmentSource;
import org.apache.druid.msq.exec.WorkerClient;
import org.apache.druid.msq.exec.WorkerFailureListener;
import org.apache.druid.msq.exec.WorkerManager;
import org.apache.druid.msq.guice.MultiStageQuery;
import org.apache.druid.msq.indexing.IndexerTableInputSpecSlicer;
import org.apache.druid.msq.indexing.MSQControllerTask;
import org.apache.druid.msq.indexing.MSQSpec;
import org.apache.druid.msq.indexing.MSQWorkerTaskLauncher;
import org.apache.druid.msq.indexing.client.ControllerChatHandler;
import org.apache.druid.msq.indexing.client.IndexerWorkerClient;
import org.apache.druid.msq.indexing.destination.MSQDestination;
import org.apache.druid.msq.indexing.error.MSQException;
import org.apache.druid.msq.indexing.error.UnknownFault;
import org.apache.druid.msq.input.InputSpecSlicer;
import org.apache.druid.msq.kernel.controller.ControllerQueryKernelConfig;
import org.apache.druid.msq.util.MultiStageQueryContext;
import org.apache.druid.query.QueryContext;
import org.apache.druid.rpc.ServiceClientFactory;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.segment.realtime.ChatHandler;
import org.apache.druid.server.DruidNode;
import org.apache.druid.storage.StorageConnector;
import org.apache.druid.storage.StorageConnectorProvider;

public class IndexerControllerContext
implements ControllerContext {
    public static final int DEFAULT_MAX_CONCURRENT_STAGES = 1;
    public static final SegmentSource DEFAULT_SEGMENT_SOURCE = SegmentSource.NONE;
    private static final Logger log = new Logger(IndexerControllerContext.class);
    private final MSQControllerTask task;
    private final TaskLockType taskLockType;
    private final String taskDataSource;
    private final QueryContext taskQuerySpecContext;
    private final Map<String, Object> taskContext;
    private final TaskToolbox toolbox;
    private final Injector injector;
    private final ServiceClientFactory clientFactory;
    private final OverlordClient overlordClient;
    private final MemoryIntrospector memoryIntrospector;

    public IndexerControllerContext(MSQControllerTask task, TaskToolbox toolbox, Injector injector, ServiceClientFactory clientFactory, OverlordClient overlordClient) {
        this.task = task;
        this.taskLockType = task.getTaskLockType();
        this.taskDataSource = task.getDataSource();
        this.taskQuerySpecContext = task.getQuerySpec().getContext();
        this.taskContext = task.getContext();
        this.toolbox = toolbox;
        this.clientFactory = clientFactory;
        this.overlordClient = overlordClient;
        this.memoryIntrospector = (MemoryIntrospector)injector.getInstance(MemoryIntrospector.class);
        StorageConnectorProvider storageConnectorProvider = (StorageConnectorProvider)injector.getInstance(Key.get(StorageConnectorProvider.class, MultiStageQuery.class));
        StorageConnector storageConnector = storageConnectorProvider.createStorageConnector(toolbox.getIndexingTmpDir());
        this.injector = injector.createChildInjector(new Module[]{binder -> binder.bind(Key.get(StorageConnector.class, MultiStageQuery.class)).toInstance((Object)storageConnector)});
    }

    @Override
    public String queryId() {
        return this.task.getId();
    }

    @Override
    public ControllerQueryKernelConfig queryKernelConfig(MSQSpec querySpec) {
        ControllerMemoryParameters memoryParameters = ControllerMemoryParameters.createProductionInstance(this.memoryIntrospector, querySpec.getTuningConfig().getMaxNumWorkers(), MultiStageQueryContext.getFrameSize(querySpec.getContext()));
        ControllerQueryKernelConfig config = IndexerControllerContext.makeQueryKernelConfig(querySpec, memoryParameters);
        log.debug("Query[%s] using %s[%s], %s[%s], %s[%s].", new Object[]{this.queryId(), "durableShuffleStorage", config.isDurableStorage(), "faultTolerance", config.isFaultTolerant(), "maxConcurrentStages", config.getMaxConcurrentStages()});
        return config;
    }

    @Override
    public void emitMetric(MSQMetriceEventBuilder metricBuilder) {
        metricBuilder.setTaskDimensions((Task)this.task, this.taskQuerySpecContext);
        this.toolbox.getEmitter().emit((ServiceEventBuilder)metricBuilder);
    }

    @Override
    public ObjectMapper jsonMapper() {
        return this.toolbox.getJsonMapper();
    }

    @Override
    public Injector injector() {
        return this.injector;
    }

    @Override
    public DruidNode selfNode() {
        return (DruidNode)this.injector.getInstance(Key.get(DruidNode.class, Self.class));
    }

    @Override
    public InputSpecSlicer newTableInputSpecSlicer(WorkerManager workerManager) {
        SegmentSource includeSegmentSource = MultiStageQueryContext.getSegmentSources(this.taskQuerySpecContext, DEFAULT_SEGMENT_SOURCE);
        return new IndexerTableInputSpecSlicer(this.toolbox.getCoordinatorClient(), this.toolbox.getTaskActionClient(), includeSegmentSource);
    }

    @Override
    public TaskActionClient taskActionClient() {
        return this.toolbox.getTaskActionClient();
    }

    @Override
    public TaskLockType taskLockType() {
        return this.taskLockType;
    }

    @Override
    public WorkerClient newWorkerClient() {
        return new IndexerWorkerClient(this.clientFactory, this.overlordClient, this.jsonMapper());
    }

    @Override
    public void registerController(Controller controller, Closer closer) {
        ControllerChatHandler chatHandler = new ControllerChatHandler(controller, this.taskDataSource, this.toolbox.getAuthorizerMapper());
        this.toolbox.getChatHandlerProvider().register(controller.queryId(), (ChatHandler)chatHandler, false);
        closer.register(() -> this.toolbox.getChatHandlerProvider().unregister(controller.queryId()));
    }

    @Override
    public WorkerManager newWorkerManager(String queryId, MSQSpec querySpec, ControllerQueryKernelConfig queryKernelConfig, WorkerFailureListener workerFailureListener) {
        return new MSQWorkerTaskLauncher(queryId, this.taskDataSource, this.overlordClient, workerFailureListener, IndexerControllerContext.makeTaskContext(querySpec, queryKernelConfig, this.taskContext), TimeUnit.SECONDS.toMillis(600L + (long)ThreadLocalRandom.current().nextInt(-4, 5) * 30L), new MSQWorkerTaskLauncher.MSQWorkerTaskLauncherConfig());
    }

    @Override
    public File taskTempDir() {
        return this.toolbox.getIndexingTmpDir();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ControllerQueryKernelConfig makeQueryKernelConfig(MSQSpec querySpec, ControllerMemoryParameters memoryParameters) {
        boolean isDurableStorageEnabled;
        QueryContext queryContext = querySpec.getContext();
        int maxConcurrentStages = MultiStageQueryContext.getMaxConcurrentStagesWithDefault(queryContext, 1);
        boolean isFaultToleranceEnabled = MultiStageQueryContext.isFaultToleranceEnabled(queryContext);
        if (isFaultToleranceEnabled) {
            if (!queryContext.containsKey("durableShuffleStorage")) {
                isDurableStorageEnabled = true;
                return ControllerQueryKernelConfig.builder().pipeline(maxConcurrentStages > 1).durableStorage(isDurableStorageEnabled).faultTolerance(isFaultToleranceEnabled).destination(querySpec.getDestination()).maxConcurrentStages(maxConcurrentStages).maxRetainedPartitionSketchBytes(memoryParameters.getPartitionStatisticsMaxRetainedBytes()).workerContextMap(IndexerControllerContext.makeWorkerContextMap(querySpec, isDurableStorageEnabled, maxConcurrentStages)).build();
            } else {
                if (!MultiStageQueryContext.isDurableStorageEnabled(queryContext)) throw new MSQException(UnknownFault.forMessage(StringUtils.format((String)"Context param[%s] cannot be explicitly set to false when context param[%s] is set to true. Either remove the context param[%s] or explicitly set it to true.", (Object[])new Object[]{"durableShuffleStorage", "faultTolerance", "durableShuffleStorage"})));
                isDurableStorageEnabled = true;
            }
            return ControllerQueryKernelConfig.builder().pipeline(maxConcurrentStages > 1).durableStorage(isDurableStorageEnabled).faultTolerance(isFaultToleranceEnabled).destination(querySpec.getDestination()).maxConcurrentStages(maxConcurrentStages).maxRetainedPartitionSketchBytes(memoryParameters.getPartitionStatisticsMaxRetainedBytes()).workerContextMap(IndexerControllerContext.makeWorkerContextMap(querySpec, isDurableStorageEnabled, maxConcurrentStages)).build();
        } else {
            isDurableStorageEnabled = MultiStageQueryContext.isDurableStorageEnabled(queryContext);
        }
        return ControllerQueryKernelConfig.builder().pipeline(maxConcurrentStages > 1).durableStorage(isDurableStorageEnabled).faultTolerance(isFaultToleranceEnabled).destination(querySpec.getDestination()).maxConcurrentStages(maxConcurrentStages).maxRetainedPartitionSketchBytes(memoryParameters.getPartitionStatisticsMaxRetainedBytes()).workerContextMap(IndexerControllerContext.makeWorkerContextMap(querySpec, isDurableStorageEnabled, maxConcurrentStages)).build();
    }

    public static Map<String, Object> makeWorkerContextMap(MSQSpec querySpec, boolean durableStorageEnabled, int maxConcurrentStages) {
        MSQDestination destination;
        QueryContext queryContext = querySpec.getContext();
        long maxParseExceptions = MultiStageQueryContext.getMaxParseExceptions(queryContext);
        FrameType rowBasedFrameType = MultiStageQueryContext.getRowBasedFrameType(queryContext);
        boolean removeNullBytes = MultiStageQueryContext.removeNullBytes(queryContext);
        boolean includeAllCounters = MultiStageQueryContext.getIncludeAllCounters(queryContext);
        boolean isReindex = MultiStageQueryContext.isReindex(queryContext);
        int frameSize = MultiStageQueryContext.getFrameSize(queryContext);
        Integer maxThreads = MultiStageQueryContext.getMaxThreads(queryContext);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"durableShuffleStorage", (Object)durableStorageEnabled).put((Object)"maxParseExceptions", (Object)maxParseExceptions).put((Object)"isReindex", (Object)isReindex).put((Object)"maxConcurrentStages", (Object)maxConcurrentStages).put((Object)"rowBasedFrameType", (Object)rowBasedFrameType.version()).put((Object)"removeNullBytes", (Object)removeNullBytes).put((Object)"includeAllCounters", (Object)includeAllCounters).put((Object)"maxFrameSize", (Object)frameSize);
        if (maxThreads != null) {
            builder.put((Object)"maxThreads", (Object)maxThreads);
        }
        if (querySpec.getId() != null) {
            builder.put((Object)"queryId", (Object)querySpec.getId());
        }
        if (queryContext.containsKey("sqlQueryId")) {
            builder.put((Object)"sqlQueryId", queryContext.get("sqlQueryId"));
        }
        if ((destination = querySpec.getDestination()).toSelectDestination() != null) {
            builder.put((Object)"selectDestination", (Object)destination.toSelectDestination().getName());
        }
        return builder.build();
    }

    public static Map<String, Object> makeTaskContext(MSQSpec querySpec, ControllerQueryKernelConfig queryKernelConfig, Map<String, Object> controllerTaskContext) {
        Map tags;
        ImmutableMap.Builder taskContextOverridesBuilder = ImmutableMap.builder();
        taskContextOverridesBuilder.putAll(IndexerControllerContext.makeWorkerContextMap(querySpec, queryKernelConfig.isDurableStorage(), queryKernelConfig.getMaxConcurrentStages()));
        if (controllerTaskContext.get("lookupLoadingMode") != null) {
            taskContextOverridesBuilder.put((Object)"lookupLoadingMode", controllerTaskContext.get("lookupLoadingMode"));
        }
        if (controllerTaskContext.get("lookupsToLoad") != null) {
            taskContextOverridesBuilder.put((Object)"lookupsToLoad", controllerTaskContext.get("lookupsToLoad"));
        }
        if ((tags = (Map)controllerTaskContext.get("tags")) != null) {
            taskContextOverridesBuilder.put((Object)"tags", (Object)tags);
        }
        return taskContextOverridesBuilder.build();
    }
}

