/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.util;

import java.io.InputStream;
import java.util.Objects;
import org.apache.hadoop.fs.ByteBufferReadable;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.parquet.hadoop.util.H1SeekableInputStream;
import org.apache.parquet.hadoop.util.H2SeekableInputStream;
import org.apache.parquet.hadoop.util.HadoopPositionOutputStream;
import org.apache.parquet.io.PositionOutputStream;
import org.apache.parquet.io.SeekableInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopStreams {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopStreams.class);

    public static SeekableInputStream wrap(FSDataInputStream stream) {
        Objects.requireNonNull(stream, "Cannot wrap a null input stream");
        if (HadoopStreams.isWrappedStreamByteBufferReadable(stream)) {
            return new H2SeekableInputStream(stream);
        }
        return new H1SeekableInputStream(stream);
    }

    private static boolean isWrappedStreamByteBufferReadable(FSDataInputStream stream) {
        if (stream.hasCapability("in:readbytebuffer")) {
            return true;
        }
        InputStream wrapped = stream.getWrappedStream();
        if (wrapped instanceof FSDataInputStream) {
            LOG.debug("Checking on wrapped stream {} of {} whether is ByteBufferReadable", (Object)wrapped, (Object)stream);
            return HadoopStreams.isWrappedStreamByteBufferReadable((FSDataInputStream)wrapped);
        }
        return wrapped instanceof ByteBufferReadable;
    }

    public static PositionOutputStream wrap(FSDataOutputStream stream) {
        Objects.requireNonNull(stream, "Cannot wrap a null output stream");
        return new HadoopPositionOutputStream(stream);
    }
}

