/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.math.expr.Evals;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.druid.query.filter.DruidFloatPredicate;
import org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.druid.query.filter.DruidObjectPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.DruidPredicateMatch;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.FilterTuning;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcherColumnProcessorFactory;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.filter.ConstantMatcherType;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.index.AllFalseBitmapColumnIndex;
import org.apache.druid.segment.index.AllTrueBitmapColumnIndex;
import org.apache.druid.segment.index.AllUnknownBitmapColumnIndex;
import org.apache.druid.segment.index.BitmapColumnIndex;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.virtual.ExpressionSelectors;
import org.apache.druid.segment.virtual.ExpressionVectorSelectors;

public class ExpressionFilter
implements Filter {
    private final Supplier<Expr> expr;
    private final Supplier<Expr.BindingAnalysis> bindingDetails;
    private final FilterTuning filterTuning;

    public ExpressionFilter(Supplier<Expr> expr, FilterTuning filterTuning) {
        this.expr = expr;
        this.bindingDetails = Suppliers.memoize(() -> ((Expr)expr.get()).analyzeInputs());
        this.filterTuning = filterTuning;
    }

    @Override
    public boolean canVectorizeMatcher(ColumnInspector inspector) {
        return ((Expr)this.expr.get()).canVectorize(inspector);
    }

    @Override
    public VectorValueMatcher makeVectorMatcher(VectorColumnSelectorFactory factory) {
        Expr theExpr = (Expr)this.expr.get();
        DruidPredicateFactory predicateFactory = this.getPredicateFactory();
        ExpressionType outputType = theExpr.getOutputType(factory);
        if (outputType == null) {
            ExprEval constantEval = theExpr.eval(InputBindings.nilBindings());
            ConstantMatcherType constantMatcherType = constantEval.valueOrDefault() == null ? ConstantMatcherType.ALL_UNKNOWN : (constantEval.asBoolean() ? ConstantMatcherType.ALL_TRUE : ConstantMatcherType.ALL_FALSE);
            return constantMatcherType.asVectorMatcher(factory.getReadableVectorInspector());
        }
        switch ((ExprType)outputType.getType()) {
            case LONG: {
                return VectorValueMatcherColumnProcessorFactory.instance().makeLongProcessor(ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities(ColumnType.LONG), ExpressionVectorSelectors.makeVectorValueSelector(factory, theExpr)).makeMatcher(predicateFactory);
            }
            case DOUBLE: {
                return VectorValueMatcherColumnProcessorFactory.instance().makeDoubleProcessor(ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities(ColumnType.DOUBLE), ExpressionVectorSelectors.makeVectorValueSelector(factory, theExpr)).makeMatcher(predicateFactory);
            }
            case STRING: {
                return VectorValueMatcherColumnProcessorFactory.instance().makeObjectProcessor(ColumnCapabilitiesImpl.createSimpleSingleValueStringColumnCapabilities(), ExpressionVectorSelectors.makeVectorObjectSelector(factory, theExpr, null)).makeMatcher(predicateFactory);
            }
            case ARRAY: {
                return VectorValueMatcherColumnProcessorFactory.instance().makeObjectProcessor(ColumnCapabilitiesImpl.createDefault().setType(ExpressionType.toColumnType(outputType)).setHasNulls(true), ExpressionVectorSelectors.makeVectorObjectSelector(factory, theExpr, null)).makeMatcher(predicateFactory);
            }
        }
        if (ExpressionType.NESTED_DATA.equals(outputType)) {
            return VectorValueMatcherColumnProcessorFactory.instance().makeObjectProcessor(ColumnCapabilitiesImpl.createDefault().setType(ExpressionType.toColumnType(outputType)).setHasNulls(true), ExpressionVectorSelectors.makeVectorObjectSelector(factory, theExpr, null)).makeMatcher(predicateFactory);
        }
        throw new UOE("Vectorized expression matchers not implemented for type: [%s]", outputType);
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        final ColumnValueSelector<ExprEval> selector = ExpressionSelectors.makeExprEvalSelector(factory, (Expr)this.expr.get());
        return new ValueMatcher(){

            @Override
            public boolean matches(boolean includeUnknown) {
                ExprEval eval = (ExprEval)selector.getObject();
                if (includeUnknown && eval.value() == null) {
                    return true;
                }
                if (eval.type().isArray()) {
                    switch ((ExprType)eval.elementType().getType()) {
                        case LONG: {
                            Object[] lResult = eval.asArray();
                            if (lResult == null) {
                                return false;
                            }
                            if (includeUnknown) {
                                return Arrays.stream(lResult).anyMatch(o -> o == null || Evals.asBoolean((Long)o));
                            }
                            return Arrays.stream(lResult).filter(Objects::nonNull).anyMatch(o -> Evals.asBoolean((Long)o));
                        }
                        case STRING: {
                            Object[] sResult = eval.asArray();
                            if (sResult == null) {
                                return false;
                            }
                            if (includeUnknown) {
                                return Arrays.stream(sResult).anyMatch(o -> o == null || Evals.asBoolean((String)o));
                            }
                            return Arrays.stream(sResult).anyMatch(o -> Evals.asBoolean((String)o));
                        }
                        case DOUBLE: {
                            Object[] dResult = eval.asArray();
                            if (dResult == null) {
                                return false;
                            }
                            if (includeUnknown) {
                                return Arrays.stream(dResult).anyMatch(o -> o == null || Evals.asBoolean((Double)o));
                            }
                            return Arrays.stream(dResult).filter(Objects::nonNull).anyMatch(o -> Evals.asBoolean((Double)o));
                        }
                    }
                }
                return eval.asBoolean();
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
            }
        };
    }

    @Override
    @Nullable
    public BitmapColumnIndex getBitmapColumnIndex(ColumnIndexSelector selector) {
        String column;
        ColumnCapabilities capabilities;
        Expr.BindingAnalysis details = (Expr.BindingAnalysis)this.bindingDetails.get();
        if (details.getRequiredBindings().isEmpty()) {
            ExprEval eval = ((Expr)this.expr.get()).eval(InputBindings.nilBindings());
            if (eval.valueOrDefault() == null) {
                return new AllUnknownBitmapColumnIndex(selector);
            }
            if (eval.asBoolean()) {
                return new AllTrueBitmapColumnIndex(selector);
            }
            return new AllFalseBitmapColumnIndex(selector.getBitmapFactory());
        }
        if (details.getRequiredBindings().size() == 1 && ExpressionSelectors.canMapOverDictionary(details, capabilities = selector.getColumnCapabilities(column = (String)Iterables.getOnlyElement(details.getRequiredBindings())))) {
            if (!Filters.checkFilterTuningUseIndex(column, selector, this.filterTuning)) {
                return null;
            }
            return Filters.makePredicateIndex(column, selector, this.getBitmapPredicateFactory(capabilities));
        }
        return null;
    }

    @Override
    public Set<String> getRequiredColumns() {
        return ((Expr.BindingAnalysis)this.bindingDetails.get()).getRequiredBindings();
    }

    @Override
    public boolean supportsRequiredColumnRewrite() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpressionFilter that = (ExpressionFilter)o;
        return Objects.equals(this.expr, that.expr) && Objects.equals(this.filterTuning, that.filterTuning);
    }

    public int hashCode() {
        return Objects.hash(this.expr, this.filterTuning);
    }

    public String toString() {
        return new DimFilter.DimFilterToStringBuilder().append(((Expr)this.expr.get()).stringify()).appendFilterTuning(this.filterTuning).build();
    }

    private DruidPredicateFactory getPredicateFactory() {
        return new DruidPredicateFactory(){

            @Override
            public DruidObjectPredicate<String> makeStringPredicate() {
                return input -> {
                    if (input == null) {
                        return DruidPredicateMatch.UNKNOWN;
                    }
                    return DruidPredicateMatch.of(Evals.asBoolean(input));
                };
            }

            @Override
            public DruidLongPredicate makeLongPredicate() {
                return input -> DruidPredicateMatch.of(Evals.asBoolean(input));
            }

            @Override
            public DruidFloatPredicate makeFloatPredicate() {
                return input -> DruidPredicateMatch.of(Evals.asBoolean(input));
            }

            @Override
            public DruidDoublePredicate makeDoublePredicate() {
                return input -> DruidPredicateMatch.of(Evals.asBoolean(input));
            }

            @Override
            public DruidObjectPredicate<Object> makeObjectPredicate() {
                return input -> {
                    if (input == null) {
                        return DruidPredicateMatch.UNKNOWN;
                    }
                    return DruidPredicateMatch.of(Evals.objectAsBoolean(input));
                };
            }

            public int hashCode() {
                return super.hashCode();
            }

            public boolean equals(Object obj) {
                return super.equals(obj);
            }
        };
    }

    private DruidPredicateFactory getBitmapPredicateFactory(final @Nullable ColumnCapabilities inputCapabilites) {
        return new DruidPredicateFactory(){

            @Override
            public DruidObjectPredicate<String> makeStringPredicate() {
                return value -> {
                    ExprEval eval = ((Expr)ExpressionFilter.this.expr.get()).eval(InputBindings.forInputSupplier(ExpressionType.STRING, () -> value));
                    if (eval.value() == null) {
                        return DruidPredicateMatch.UNKNOWN;
                    }
                    return DruidPredicateMatch.of(eval.asBoolean());
                };
            }

            @Override
            public DruidLongPredicate makeLongPredicate() {
                return new DruidLongPredicate(){

                    @Override
                    public DruidPredicateMatch applyLong(long input) {
                        ExprEval eval = ((Expr)ExpressionFilter.this.expr.get()).eval(InputBindings.forInputSupplier(ExpressionType.LONG, () -> input));
                        if (eval.isNumericNull()) {
                            return DruidPredicateMatch.UNKNOWN;
                        }
                        return DruidPredicateMatch.of(eval.asBoolean());
                    }

                    @Override
                    public DruidPredicateMatch applyNull() {
                        ExprEval eval = ((Expr)ExpressionFilter.this.expr.get()).eval(InputBindings.nilBindings());
                        if (eval.isNumericNull()) {
                            return DruidPredicateMatch.UNKNOWN;
                        }
                        return DruidPredicateMatch.of(eval.asBoolean());
                    }
                };
            }

            @Override
            public DruidFloatPredicate makeFloatPredicate() {
                return new DruidFloatPredicate(){

                    @Override
                    public DruidPredicateMatch applyFloat(float input) {
                        ExprEval eval = ((Expr)ExpressionFilter.this.expr.get()).eval(InputBindings.forInputSupplier(ExpressionType.DOUBLE, () -> Float.valueOf(input)));
                        if (eval.isNumericNull()) {
                            return DruidPredicateMatch.UNKNOWN;
                        }
                        return DruidPredicateMatch.of(eval.asBoolean());
                    }

                    @Override
                    public DruidPredicateMatch applyNull() {
                        ExprEval eval = ((Expr)ExpressionFilter.this.expr.get()).eval(InputBindings.nilBindings());
                        if (eval.isNumericNull()) {
                            return DruidPredicateMatch.UNKNOWN;
                        }
                        return DruidPredicateMatch.of(eval.asBoolean());
                    }
                };
            }

            @Override
            public DruidDoublePredicate makeDoublePredicate() {
                return new DruidDoublePredicate(){

                    @Override
                    public DruidPredicateMatch applyDouble(double input) {
                        ExprEval eval = ((Expr)ExpressionFilter.this.expr.get()).eval(InputBindings.forInputSupplier(ExpressionType.DOUBLE, () -> input));
                        if (eval.isNumericNull()) {
                            return DruidPredicateMatch.UNKNOWN;
                        }
                        return DruidPredicateMatch.of(eval.asBoolean());
                    }

                    @Override
                    public DruidPredicateMatch applyNull() {
                        ExprEval eval = ((Expr)ExpressionFilter.this.expr.get()).eval(InputBindings.nilBindings());
                        if (eval.isNumericNull()) {
                            return DruidPredicateMatch.UNKNOWN;
                        }
                        return DruidPredicateMatch.of(eval.asBoolean());
                    }
                };
            }

            @Override
            public DruidObjectPredicate<Object[]> makeArrayPredicate(@Nullable TypeSignature<ValueType> arrayType) {
                if (inputCapabilites == null) {
                    return input -> {
                        ExprEval eval = ((Expr)ExpressionFilter.this.expr.get()).eval(InputBindings.forInputSupplier(ExpressionType.STRING_ARRAY, () -> input));
                        if (eval.value() == null) {
                            return DruidPredicateMatch.UNKNOWN;
                        }
                        return DruidPredicateMatch.of(eval.asBoolean());
                    };
                }
                return input -> {
                    ExprEval eval = ((Expr)ExpressionFilter.this.expr.get()).eval(InputBindings.forInputSupplier(ExpressionType.fromColumnType(inputCapabilites), () -> input));
                    if (eval.value() == null) {
                        return DruidPredicateMatch.UNKNOWN;
                    }
                    return DruidPredicateMatch.of(eval.asBoolean());
                };
            }

            public int hashCode() {
                return super.hashCode();
            }

            public boolean equals(Object obj) {
                return super.equals(obj);
            }
        };
    }
}

