/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.segment.DefaultColumnFormatConfig;
import org.apache.druid.segment.DimensionHandler;
import org.apache.druid.segment.NestedCommonFormatColumnHandler;
import org.apache.druid.segment.NestedDataColumnHandlerV4;
import org.apache.druid.segment.column.ColumnType;

public class NestedDataColumnSchema
extends DimensionSchema {
    final int formatVersion;

    @JsonCreator
    public NestedDataColumnSchema(@JsonProperty(value="name") String name, @JsonProperty(value="formatVersion") @Nullable Integer version, @JacksonInject DefaultColumnFormatConfig defaultFormatConfig) {
        super(name, null, true);
        this.formatVersion = version != null ? version : (defaultFormatConfig.getNestedColumnFormatVersion() != null ? defaultFormatConfig.getNestedColumnFormatVersion() : 5);
        DefaultColumnFormatConfig.validateNestedFormatVersion(this.formatVersion);
    }

    public NestedDataColumnSchema(String name, int version) {
        super(name, null, true);
        this.formatVersion = version;
        DefaultColumnFormatConfig.validateNestedFormatVersion(this.formatVersion);
    }

    @JsonProperty(value="formatVersion")
    public int getFormatVersion() {
        return this.formatVersion;
    }

    @Override
    public String getTypeName() {
        return "json";
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.NESTED_DATA;
    }

    @Override
    public DimensionHandler getDimensionHandler() {
        if (this.formatVersion == 4) {
            return new NestedDataColumnHandlerV4(this.getName());
        }
        return new NestedCommonFormatColumnHandler(this.getName(), null);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NestedDataColumnSchema that = (NestedDataColumnSchema)o;
        return Objects.equals(this.formatVersion, that.formatVersion);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.formatVersion);
    }

    @Override
    public String toString() {
        return "NestedDataColumnSchema{formatVersion=" + this.formatVersion + "}";
    }
}

