/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.segment.column.StringEncodingStrategy;
import org.apache.druid.segment.data.BitmapSerde;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.CompressionFactory;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.loading.SegmentizerFactory;

public class IndexSpec {
    public static final IndexSpec DEFAULT = IndexSpec.builder().build();
    private final BitmapSerdeFactory bitmapSerdeFactory;
    private final CompressionStrategy dimensionCompression;
    private final StringEncodingStrategy stringDictionaryEncoding;
    private final CompressionStrategy metricCompression;
    private final CompressionFactory.LongEncodingStrategy longEncoding;
    @Nullable
    private final CompressionStrategy complexMetricCompression;
    @Nullable
    private final CompressionStrategy jsonCompression;
    @Nullable
    private final SegmentizerFactory segmentLoader;

    public static Builder builder() {
        return new Builder();
    }

    @JsonCreator
    public IndexSpec(@JsonProperty(value="bitmap") @Nullable BitmapSerdeFactory bitmapSerdeFactory, @JsonProperty(value="dimensionCompression") @Nullable CompressionStrategy dimensionCompression, @JsonProperty(value="stringDictionaryEncoding") @Nullable StringEncodingStrategy stringDictionaryEncoding, @JsonProperty(value="metricCompression") @Nullable CompressionStrategy metricCompression, @JsonProperty(value="longEncoding") @Nullable CompressionFactory.LongEncodingStrategy longEncoding, @JsonProperty(value="complexMetricCompression") @Nullable CompressionStrategy complexMetricCompression, @JsonProperty(value="jsonCompression") @Nullable CompressionStrategy jsonCompression, @JsonProperty(value="segmentLoader") @Nullable SegmentizerFactory segmentLoader) {
        this.bitmapSerdeFactory = bitmapSerdeFactory != null ? bitmapSerdeFactory : new BitmapSerde.DefaultBitmapSerdeFactory();
        this.dimensionCompression = dimensionCompression == null ? CompressionStrategy.DEFAULT_COMPRESSION_STRATEGY : dimensionCompression;
        this.stringDictionaryEncoding = stringDictionaryEncoding == null ? StringEncodingStrategy.DEFAULT : stringDictionaryEncoding;
        this.metricCompression = metricCompression == null ? CompressionStrategy.DEFAULT_COMPRESSION_STRATEGY : metricCompression;
        this.complexMetricCompression = complexMetricCompression;
        this.longEncoding = longEncoding == null ? CompressionFactory.DEFAULT_LONG_ENCODING_STRATEGY : longEncoding;
        this.jsonCompression = jsonCompression;
        this.segmentLoader = segmentLoader;
    }

    @JsonProperty(value="bitmap")
    public BitmapSerdeFactory getBitmapSerdeFactory() {
        return this.bitmapSerdeFactory;
    }

    @JsonProperty
    public CompressionStrategy getDimensionCompression() {
        return this.dimensionCompression;
    }

    @JsonProperty
    public StringEncodingStrategy getStringDictionaryEncoding() {
        return this.stringDictionaryEncoding;
    }

    @JsonProperty
    public CompressionStrategy getMetricCompression() {
        return this.metricCompression;
    }

    @JsonProperty
    public CompressionFactory.LongEncodingStrategy getLongEncoding() {
        return this.longEncoding;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public CompressionStrategy getComplexMetricCompression() {
        return this.complexMetricCompression;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public SegmentizerFactory getSegmentLoader() {
        return this.segmentLoader;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public CompressionStrategy getJsonCompression() {
        return this.jsonCompression;
    }

    public Map<String, Object> asMap(ObjectMapper objectMapper) {
        return (Map)objectMapper.convertValue((Object)this, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexSpec indexSpec = (IndexSpec)o;
        return Objects.equals(this.bitmapSerdeFactory, indexSpec.bitmapSerdeFactory) && this.dimensionCompression == indexSpec.dimensionCompression && Objects.equals(this.stringDictionaryEncoding, indexSpec.stringDictionaryEncoding) && this.metricCompression == indexSpec.metricCompression && this.longEncoding == indexSpec.longEncoding && Objects.equals((Object)this.complexMetricCompression, (Object)indexSpec.complexMetricCompression) && Objects.equals((Object)this.jsonCompression, (Object)indexSpec.jsonCompression) && Objects.equals(this.segmentLoader, indexSpec.segmentLoader);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bitmapSerdeFactory, this.dimensionCompression, this.stringDictionaryEncoding, this.metricCompression, this.longEncoding, this.complexMetricCompression, this.jsonCompression, this.segmentLoader});
    }

    public String toString() {
        return "IndexSpec{bitmapSerdeFactory=" + this.bitmapSerdeFactory + ", dimensionCompression=" + this.dimensionCompression + ", stringDictionaryEncoding=" + this.stringDictionaryEncoding + ", metricCompression=" + this.metricCompression + ", longEncoding=" + this.longEncoding + ", complexMetricCompression=" + this.complexMetricCompression + ", jsonCompression=" + this.jsonCompression + ", segmentLoader=" + this.segmentLoader + "}";
    }

    public static class Builder {
        @Nullable
        private BitmapSerdeFactory bitmapSerdeFactory;
        @Nullable
        private CompressionStrategy dimensionCompression;
        @Nullable
        private StringEncodingStrategy stringDictionaryEncoding;
        @Nullable
        private CompressionStrategy metricCompression;
        @Nullable
        private CompressionFactory.LongEncodingStrategy longEncoding;
        @Nullable
        private CompressionStrategy complexMetricCompression;
        @Nullable
        private CompressionStrategy jsonCompression;
        @Nullable
        private SegmentizerFactory segmentLoader;

        public Builder withBitmapSerdeFactory(BitmapSerdeFactory bitmapSerdeFactory) {
            this.bitmapSerdeFactory = bitmapSerdeFactory;
            return this;
        }

        public Builder withDimensionCompression(CompressionStrategy dimensionCompression) {
            this.dimensionCompression = dimensionCompression;
            return this;
        }

        public Builder withStringDictionaryEncoding(StringEncodingStrategy stringDictionaryEncoding) {
            this.stringDictionaryEncoding = stringDictionaryEncoding;
            return this;
        }

        public Builder withMetricCompression(CompressionStrategy metricCompression) {
            this.metricCompression = metricCompression;
            return this;
        }

        public Builder withComplexMetricCompression(CompressionStrategy complexMetricCompression) {
            this.complexMetricCompression = complexMetricCompression;
            return this;
        }

        public Builder withLongEncoding(CompressionFactory.LongEncodingStrategy longEncoding) {
            this.longEncoding = longEncoding;
            return this;
        }

        public Builder withJsonCompression(CompressionStrategy jsonCompression) {
            this.jsonCompression = jsonCompression;
            return this;
        }

        public Builder withSegmentLoader(SegmentizerFactory segmentLoader) {
            this.segmentLoader = segmentLoader;
            return this;
        }

        public IndexSpec build() {
            return new IndexSpec(this.bitmapSerdeFactory, this.dimensionCompression, this.stringDictionaryEncoding, this.metricCompression, this.longEncoding, this.complexMetricCompression, this.jsonCompression, this.segmentLoader);
        }
    }
}

