/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.query.OrderBy;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.projections.Projections;
import org.apache.druid.utils.CollectionUtils;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonTypeName(value="aggregate")
public class AggregateProjectionMetadata {
    private static final Interner<Schema> SCHEMA_INTERNER = Interners.newWeakInterner();
    public static final Comparator<AggregateProjectionMetadata> COMPARATOR = (o1, o2) -> {
        int rowCompare = Integer.compare(o1.numRows, o2.numRows);
        if (rowCompare != 0) {
            return rowCompare;
        }
        return Schema.COMPARATOR.compare(o1.getSchema(), o2.getSchema());
    };
    private final Schema schema;
    private final int numRows;

    @JsonCreator
    public AggregateProjectionMetadata(@JsonProperty(value="schema") Schema schema, @JsonProperty(value="numRows") int numRows) {
        this.schema = (Schema)SCHEMA_INTERNER.intern((Object)schema);
        this.numRows = numRows;
    }

    @JsonProperty
    public Schema getSchema() {
        return this.schema;
    }

    @JsonProperty
    public int getNumRows() {
        return this.numRows;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregateProjectionMetadata that = (AggregateProjectionMetadata)o;
        return this.numRows == that.numRows && Objects.equals(this.schema, that.schema);
    }

    public int hashCode() {
        return Objects.hash(this.schema, this.numRows);
    }

    public static class Schema {
        public static final Comparator<Schema> COMPARATOR = (o1, o2) -> {
            if (o1.getGranularity().isFinerThan(o2.getGranularity())) {
                return 1;
            }
            if (o2.getGranularity().isFinerThan(o1.getGranularity())) {
                return -1;
            }
            int dimsCompare = Integer.compare(o1.groupingColumns.size(), o2.groupingColumns.size());
            if (dimsCompare != 0) {
                return dimsCompare;
            }
            int metCompare = Integer.compare(o2.aggregators.length, o1.aggregators.length);
            if (metCompare != 0) {
                return metCompare;
            }
            int virtCompare = Integer.compare(o2.virtualColumns.getVirtualColumns().length, o1.virtualColumns.getVirtualColumns().length);
            if (virtCompare != 0) {
                return virtCompare;
            }
            return o1.name.compareTo(o2.name);
        };
        private final String name;
        @Nullable
        private final String timeColumnName;
        private final VirtualColumns virtualColumns;
        private final List<String> groupingColumns;
        private final AggregatorFactory[] aggregators;
        private final List<OrderBy> ordering;
        private final List<OrderBy> orderingWithTimeSubstitution;
        private final int timeColumnPosition;
        private final Granularity granularity;

        @JsonCreator
        public Schema(@JsonProperty(value="name") String name, @JsonProperty(value="timeColumnName") @Nullable String timeColumnName, @JsonProperty(value="virtualColumns") @Nullable VirtualColumns virtualColumns, @JsonProperty(value="groupingColumns") @Nullable List<String> groupingColumns, @JsonProperty(value="aggregators") @Nullable AggregatorFactory[] aggregators, @JsonProperty(value="ordering") List<OrderBy> ordering) {
            this.name = name;
            if (CollectionUtils.isNullOrEmpty(groupingColumns) && (aggregators == null || aggregators.length == 0)) {
                throw DruidException.defensive("groupingColumns and aggregators must not both be null or empty", new Object[0]);
            }
            this.virtualColumns = virtualColumns == null ? VirtualColumns.EMPTY : virtualColumns;
            this.groupingColumns = groupingColumns == null ? Collections.emptyList() : groupingColumns;
            this.aggregators = aggregators == null ? new AggregatorFactory[]{} : aggregators;
            this.ordering = ordering;
            int foundTimePosition = -1;
            this.orderingWithTimeSubstitution = Lists.newArrayListWithCapacity((int)ordering.size());
            Granularity granularity = null;
            for (int i = 0; i < ordering.size(); ++i) {
                OrderBy orderBy = ordering.get(i);
                if (orderBy.getColumnName().equals(timeColumnName)) {
                    this.orderingWithTimeSubstitution.add(new OrderBy("__time", orderBy.getOrder()));
                    foundTimePosition = i;
                    timeColumnName = groupingColumns.get(foundTimePosition);
                    VirtualColumn vc = this.virtualColumns.getVirtualColumn(groupingColumns.get(foundTimePosition));
                    if (vc != null) {
                        granularity = Granularities.fromVirtualColumn(vc);
                        continue;
                    }
                    granularity = Granularities.NONE;
                    continue;
                }
                this.orderingWithTimeSubstitution.add(orderBy);
            }
            this.timeColumnName = timeColumnName;
            this.timeColumnPosition = foundTimePosition;
            this.granularity = granularity == null ? Granularities.ALL : granularity;
        }

        @JsonProperty
        public String getName() {
            return this.name;
        }

        @JsonProperty
        @Nullable
        public String getTimeColumnName() {
            return this.timeColumnName;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
        public VirtualColumns getVirtualColumns() {
            return this.virtualColumns;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
        public List<String> getGroupingColumns() {
            return this.groupingColumns;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
        public AggregatorFactory[] getAggregators() {
            return this.aggregators;
        }

        @JsonProperty
        public List<OrderBy> getOrdering() {
            return this.ordering;
        }

        @JsonIgnore
        public List<OrderBy> getOrderingWithTimeColumnSubstitution() {
            return this.orderingWithTimeSubstitution;
        }

        @JsonIgnore
        public int getTimeColumnPosition() {
            return this.timeColumnPosition;
        }

        @JsonIgnore
        public Granularity getGranularity() {
            return this.granularity;
        }

        @Nullable
        public Projections.ProjectionMatch matches(CursorBuildSpec queryCursorBuildSpec, Projections.PhysicalColumnChecker physicalColumnChecker) {
            List<String> queryGrouping;
            if (!queryCursorBuildSpec.isCompatibleOrdering(this.orderingWithTimeSubstitution)) {
                return null;
            }
            Projections.ProjectionMatchBuilder matchBuilder = new Projections.ProjectionMatchBuilder();
            if (this.timeColumnName != null) {
                matchBuilder.remapColumn(this.timeColumnName, "__time").addReferencedPhysicalColumn("__time");
            }
            if ((queryGrouping = queryCursorBuildSpec.getGroupingColumns()) != null) {
                for (String queryColumn : queryGrouping) {
                    if ((matchBuilder = this.matchRequiredColumn(matchBuilder, queryColumn, queryCursorBuildSpec.getVirtualColumns(), physicalColumnChecker)) != null) continue;
                    return null;
                }
            }
            if (queryCursorBuildSpec.getFilter() != null) {
                for (String queryColumn : queryCursorBuildSpec.getFilter().getRequiredColumns()) {
                    if ((matchBuilder = this.matchRequiredColumn(matchBuilder, queryColumn, queryCursorBuildSpec.getVirtualColumns(), physicalColumnChecker)) != null) continue;
                    return null;
                }
            }
            if (!CollectionUtils.isNullOrEmpty(queryCursorBuildSpec.getAggregators())) {
                boolean allMatch = true;
                for (AggregatorFactory queryAgg : queryCursorBuildSpec.getAggregators()) {
                    boolean foundMatch = false;
                    for (AggregatorFactory projectionAgg : this.aggregators) {
                        AggregatorFactory combining = queryAgg.substituteCombiningFactory(projectionAgg);
                        if (combining == null) continue;
                        matchBuilder.remapColumn(queryAgg.getName(), projectionAgg.getName()).addReferencedPhysicalColumn(projectionAgg.getName()).addPreAggregatedAggregator(combining);
                        foundMatch = true;
                        break;
                    }
                    allMatch = allMatch && foundMatch;
                }
                if (!allMatch) {
                    return null;
                }
            }
            return matchBuilder.build(queryCursorBuildSpec);
        }

        @Nullable
        private Projections.ProjectionMatchBuilder matchRequiredColumn(Projections.ProjectionMatchBuilder matchBuilder, String column, VirtualColumns queryVirtualColumns, Projections.PhysicalColumnChecker physicalColumnChecker) {
            VirtualColumn buildSpecVirtualColumn = queryVirtualColumns.getVirtualColumn(column);
            if (buildSpecVirtualColumn != null) {
                VirtualColumn projectionEquivalent = this.virtualColumns.findEquivalent(buildSpecVirtualColumn);
                if (projectionEquivalent != null) {
                    if (!buildSpecVirtualColumn.getOutputName().equals(projectionEquivalent.getOutputName())) {
                        matchBuilder.remapColumn(buildSpecVirtualColumn.getOutputName(), projectionEquivalent.getOutputName());
                    }
                    return matchBuilder.addReferencedPhysicalColumn(projectionEquivalent.getOutputName());
                }
                matchBuilder.addReferenceedVirtualColumn(buildSpecVirtualColumn);
                List<String> requiredInputs = buildSpecVirtualColumn.requiredColumns();
                if (requiredInputs.size() == 1 && "__time".equals(requiredInputs.get(0))) {
                    Granularity virtualGranularity = Granularities.fromVirtualColumn(buildSpecVirtualColumn);
                    if (virtualGranularity != null) {
                        if (virtualGranularity.isFinerThan(this.granularity)) {
                            return null;
                        }
                        return matchBuilder.remapColumn(column, "__time").addReferencedPhysicalColumn("__time");
                    }
                    if (Granularities.NONE.equals(this.granularity)) {
                        return matchBuilder;
                    }
                    return null;
                }
                for (String required : requiredInputs) {
                    if ((matchBuilder = this.matchRequiredColumn(matchBuilder, required, queryVirtualColumns, physicalColumnChecker)) != null) continue;
                    return null;
                }
                return matchBuilder;
            }
            if (physicalColumnChecker.check(this.name, column)) {
                return matchBuilder.addReferencedPhysicalColumn(column);
            }
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Schema schema = (Schema)o;
            return Objects.equals(this.name, schema.name) && Objects.equals(this.timeColumnName, schema.timeColumnName) && Objects.equals(this.virtualColumns, schema.virtualColumns) && Objects.equals(this.groupingColumns, schema.groupingColumns) && Objects.deepEquals(this.aggregators, schema.aggregators) && Objects.equals(this.ordering, schema.ordering);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.timeColumnName, this.virtualColumns, this.groupingColumns, Arrays.hashCode(this.aggregators), this.ordering);
        }
    }
}

