/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.DruidProcessingConfig;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.groupby.DeferExpressionDimensions;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.utils.JvmUtils;

public class GroupByQueryConfig {
    private static final Logger logger = new Logger(GroupByQueryConfig.class);
    public static final long AUTOMATIC = 0L;
    public static final String CTX_KEY_FORCE_LIMIT_PUSH_DOWN = "forceLimitPushDown";
    public static final String CTX_KEY_APPLY_LIMIT_PUSH_DOWN = "applyLimitPushDown";
    public static final String CTX_KEY_APPLY_LIMIT_PUSH_DOWN_TO_SEGMENT = "applyLimitPushDownToSegment";
    public static final String CTX_KEY_FORCE_PUSH_DOWN_NESTED_QUERY = "forcePushDownNestedQuery";
    public static final String CTX_KEY_EXECUTING_NESTED_QUERY = "executingNestedQuery";
    public static final String CTX_KEY_ARRAY_RESULT_ROWS = "resultAsArray";
    public static final String CTX_KEY_ENABLE_MULTI_VALUE_UNNESTING = "groupByEnableMultiValueUnnesting";
    public static final String CTX_KEY_BUFFER_GROUPER_MAX_SIZE = "bufferGrouperMaxSize";
    public static final String CTX_KEY_DEFER_EXPRESSION_DIMENSIONS = "deferExpressionDimensions";
    private static final String CTX_KEY_IS_SINGLE_THREADED = "groupByIsSingleThreaded";
    private static final String CTX_KEY_BUFFER_GROUPER_INITIAL_BUCKETS = "bufferGrouperInitialBuckets";
    private static final String CTX_KEY_BUFFER_GROUPER_MAX_LOAD_FACTOR = "bufferGrouperMaxLoadFactor";
    private static final String CTX_KEY_MAX_ON_DISK_STORAGE = "maxOnDiskStorage";
    private static final String CTX_KEY_MAX_SELECTOR_DICTIONARY_SIZE = "maxSelectorDictionarySize";
    private static final String CTX_KEY_MAX_MERGING_DICTIONARY_SIZE = "maxMergingDictionarySize";
    private static final String CTX_KEY_FORCE_HASH_AGGREGATION = "forceHashAggregation";
    private static final String CTX_KEY_INTERMEDIATE_COMBINE_DEGREE = "intermediateCombineDegree";
    private static final String CTX_KEY_NUM_PARALLEL_COMBINE_THREADS = "numParallelCombineThreads";
    private static final String CTX_KEY_MERGE_THREAD_LOCAL = "mergeThreadLocal";
    private static final double MERGING_DICTIONARY_HEAP_FRACTION = 0.3;
    private static final double SELECTOR_DICTIONARY_HEAP_FRACTION = 0.1;
    private static final long MIN_AUTOMATIC_DICTIONARY_SIZE = 1L;
    private static final long MAX_AUTOMATIC_DICTIONARY_SIZE = 1000000000L;
    @JsonProperty
    private boolean singleThreaded = false;
    @JsonProperty
    private int bufferGrouperMaxSize = Integer.MAX_VALUE;
    @JsonProperty
    private float bufferGrouperMaxLoadFactor = 0.0f;
    @JsonProperty
    private int bufferGrouperInitialBuckets = 0;
    @JsonProperty
    private HumanReadableBytes maxSelectorDictionarySize = HumanReadableBytes.valueOf(0L);
    @JsonProperty
    private HumanReadableBytes maxMergingDictionarySize = HumanReadableBytes.valueOf(0L);
    @JsonProperty
    private HumanReadableBytes maxOnDiskStorage = HumanReadableBytes.valueOf(0);
    @JsonProperty
    private HumanReadableBytes defaultOnDiskStorage = HumanReadableBytes.valueOf(-1);
    @JsonProperty
    private boolean forcePushDownLimit = false;
    @JsonProperty
    private boolean applyLimitPushDownToSegment = false;
    @JsonProperty
    private boolean forcePushDownNestedQuery = false;
    @JsonProperty
    private boolean forceHashAggregation = false;
    @JsonProperty
    private int intermediateCombineDegree = 8;
    @JsonProperty
    private int numParallelCombineThreads = 1;
    @JsonProperty
    private boolean mergeThreadLocal = false;
    @JsonProperty
    private DeferExpressionDimensions deferExpressionDimensions = DeferExpressionDimensions.FIXED_WIDTH_NON_NUMERIC;
    @JsonProperty
    private boolean vectorize = true;
    @JsonProperty
    private boolean intermediateResultAsMapCompat = false;
    @JsonProperty
    private boolean enableMultiValueUnnesting = true;

    public boolean isSingleThreaded() {
        return this.singleThreaded;
    }

    public void setSingleThreaded(boolean singleThreaded) {
        this.singleThreaded = singleThreaded;
    }

    public int getBufferGrouperMaxSize() {
        return this.bufferGrouperMaxSize;
    }

    public float getBufferGrouperMaxLoadFactor() {
        return this.bufferGrouperMaxLoadFactor;
    }

    public int getBufferGrouperInitialBuckets() {
        return this.bufferGrouperInitialBuckets;
    }

    long getConfiguredMaxSelectorDictionarySize() {
        return this.maxSelectorDictionarySize.getBytes();
    }

    long getActualMaxSelectorDictionarySize(long maxHeapSize, int numConcurrentQueries) {
        if (this.getConfiguredMaxSelectorDictionarySize() == 0L) {
            long heapForDictionaries = (long)((double)maxHeapSize * 0.1);
            return Math.max(1L, Math.min(1000000000L, heapForDictionaries / (long)numConcurrentQueries));
        }
        return this.getConfiguredMaxSelectorDictionarySize();
    }

    public long getActualMaxSelectorDictionarySize(DruidProcessingConfig processingConfig) {
        return this.getActualMaxSelectorDictionarySize(JvmUtils.getRuntimeInfo().getMaxHeapSizeBytes(), processingConfig.getNumMergeBuffers());
    }

    long getConfiguredMaxMergingDictionarySize() {
        return this.maxMergingDictionarySize.getBytes();
    }

    public long getActualMaxMergingDictionarySize(long maxHeapSize, int numConcurrentQueries) {
        if (this.maxMergingDictionarySize.getBytes() == 0L) {
            long heapForDictionaries = (long)((double)maxHeapSize * 0.3);
            return Math.max(1L, Math.min(1000000000L, heapForDictionaries / (long)numConcurrentQueries));
        }
        return this.maxMergingDictionarySize.getBytes();
    }

    public long getActualMaxMergingDictionarySize(DruidProcessingConfig processingConfig) {
        return this.getActualMaxMergingDictionarySize(JvmUtils.getRuntimeInfo().getMaxHeapSizeBytes(), processingConfig.getNumMergeBuffers());
    }

    public HumanReadableBytes getMaxOnDiskStorage() {
        return this.maxOnDiskStorage;
    }

    public HumanReadableBytes getDefaultOnDiskStorage() {
        return this.defaultOnDiskStorage.getBytes() < 0L ? this.getMaxOnDiskStorage() : this.defaultOnDiskStorage;
    }

    public boolean isForcePushDownLimit() {
        return this.forcePushDownLimit;
    }

    public boolean isApplyLimitPushDownToSegment() {
        return this.applyLimitPushDownToSegment;
    }

    public boolean isForceHashAggregation() {
        return this.forceHashAggregation;
    }

    public int getIntermediateCombineDegree() {
        return this.intermediateCombineDegree;
    }

    public int getNumParallelCombineThreads() {
        return this.numParallelCombineThreads;
    }

    public boolean isMergeThreadLocal() {
        return this.mergeThreadLocal;
    }

    public DeferExpressionDimensions getDeferExpressionDimensions() {
        return this.deferExpressionDimensions;
    }

    public boolean isVectorize() {
        return this.vectorize;
    }

    public boolean isIntermediateResultAsMapCompat() {
        return this.intermediateResultAsMapCompat;
    }

    public boolean isForcePushDownNestedQuery() {
        return this.forcePushDownNestedQuery;
    }

    public boolean isMultiValueUnnestingEnabled() {
        return this.enableMultiValueUnnesting;
    }

    public GroupByQueryConfig withOverrides(GroupByQuery query) {
        GroupByQueryConfig newConfig = new GroupByQueryConfig();
        QueryContext queryContext = query.context();
        newConfig.singleThreaded = queryContext.getBoolean(CTX_KEY_IS_SINGLE_THREADED, this.isSingleThreaded());
        newConfig.bufferGrouperMaxSize = Math.min(queryContext.getInt(CTX_KEY_BUFFER_GROUPER_MAX_SIZE, this.getBufferGrouperMaxSize()), this.getBufferGrouperMaxSize());
        newConfig.bufferGrouperMaxLoadFactor = queryContext.getFloat(CTX_KEY_BUFFER_GROUPER_MAX_LOAD_FACTOR, this.getBufferGrouperMaxLoadFactor());
        newConfig.bufferGrouperInitialBuckets = queryContext.getInt(CTX_KEY_BUFFER_GROUPER_INITIAL_BUCKETS, this.getBufferGrouperInitialBuckets());
        newConfig.maxOnDiskStorage = HumanReadableBytes.valueOf(Math.min(queryContext.getHumanReadableBytes(CTX_KEY_MAX_ON_DISK_STORAGE, this.getDefaultOnDiskStorage()).getBytes(), this.getMaxOnDiskStorage().getBytes()));
        newConfig.maxSelectorDictionarySize = queryContext.getHumanReadableBytes(CTX_KEY_MAX_SELECTOR_DICTIONARY_SIZE, this.getConfiguredMaxSelectorDictionarySize());
        newConfig.maxMergingDictionarySize = queryContext.getHumanReadableBytes(CTX_KEY_MAX_MERGING_DICTIONARY_SIZE, this.getConfiguredMaxMergingDictionarySize());
        newConfig.forcePushDownLimit = queryContext.getBoolean(CTX_KEY_FORCE_LIMIT_PUSH_DOWN, this.isForcePushDownLimit());
        newConfig.applyLimitPushDownToSegment = queryContext.getBoolean(CTX_KEY_APPLY_LIMIT_PUSH_DOWN_TO_SEGMENT, this.isApplyLimitPushDownToSegment());
        newConfig.forceHashAggregation = queryContext.getBoolean(CTX_KEY_FORCE_HASH_AGGREGATION, this.isForceHashAggregation());
        newConfig.forcePushDownNestedQuery = queryContext.getBoolean(CTX_KEY_FORCE_PUSH_DOWN_NESTED_QUERY, this.isForcePushDownNestedQuery());
        newConfig.intermediateCombineDegree = queryContext.getInt(CTX_KEY_INTERMEDIATE_COMBINE_DEGREE, this.getIntermediateCombineDegree());
        newConfig.numParallelCombineThreads = queryContext.getInt(CTX_KEY_NUM_PARALLEL_COMBINE_THREADS, this.getNumParallelCombineThreads());
        newConfig.mergeThreadLocal = queryContext.getBoolean(CTX_KEY_MERGE_THREAD_LOCAL, this.isMergeThreadLocal());
        newConfig.deferExpressionDimensions = Optional.ofNullable(queryContext.getString(CTX_KEY_DEFER_EXPRESSION_DIMENSIONS)).map(DeferExpressionDimensions::fromString).orElse(this.getDeferExpressionDimensions());
        newConfig.vectorize = queryContext.getBoolean("vectorize", this.isVectorize());
        newConfig.enableMultiValueUnnesting = queryContext.getBoolean(CTX_KEY_ENABLE_MULTI_VALUE_UNNESTING, this.isMultiValueUnnestingEnabled());
        logger.debug("Override config for GroupBy query %s - %s", query.getId(), newConfig);
        return newConfig;
    }

    public String toString() {
        return "GroupByQueryConfig{singleThreaded=" + this.singleThreaded + ", bufferGrouperMaxSize=" + this.bufferGrouperMaxSize + ", bufferGrouperMaxLoadFactor=" + this.bufferGrouperMaxLoadFactor + ", bufferGrouperInitialBuckets=" + this.bufferGrouperInitialBuckets + ", maxMergingDictionarySize=" + this.maxMergingDictionarySize + ", maxOnDiskStorage=" + this.maxOnDiskStorage.getBytes() + ", defaultOnDiskStorage=" + this.getDefaultOnDiskStorage().getBytes() + ", forcePushDownLimit=" + this.forcePushDownLimit + ", forceHashAggregation=" + this.forceHashAggregation + ", intermediateCombineDegree=" + this.intermediateCombineDegree + ", numParallelCombineThreads=" + this.numParallelCombineThreads + ", vectorize=" + this.vectorize + ", forcePushDownNestedQuery=" + this.forcePushDownNestedQuery + ", enableMultiValueUnnesting=" + this.enableMultiValueUnnesting + ", mergeThreadLocal=" + this.mergeThreadLocal + ", deferExpressionDimensions=" + this.deferExpressionDimensions + "}";
    }
}

