/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Longs;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.BaseQuery;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.DimensionComparisonUtils;
import org.apache.druid.query.Queries;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.having.HavingSpec;
import org.apache.druid.query.groupby.orderby.DefaultLimitSpec;
import org.apache.druid.query.groupby.orderby.LimitSpec;
import org.apache.druid.query.groupby.orderby.NoopLimitSpec;
import org.apache.druid.query.groupby.orderby.OrderByColumnSpec;
import org.apache.druid.query.ordering.StringComparator;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.query.spec.LegacySegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class GroupByQuery
extends BaseQuery<ResultRow> {
    public static final String CTX_KEY_SORT_BY_DIMS_FIRST = "sortByDimsFirst";
    public static final String CTX_TIMESTAMP_RESULT_FIELD = "timestampResultField";
    public static final String CTX_TIMESTAMP_RESULT_FIELD_GRANULARITY = "timestampResultFieldGranularity";
    public static final String CTX_TIMESTAMP_RESULT_FIELD_INDEX = "timestampResultFieldInOriginalDimensions";
    private static final String CTX_KEY_FUDGE_TIMESTAMP = "fudgeTimestamp";
    private static final Comparator<ResultRow> NON_GRANULAR_TIME_COMP = (lhs, rhs) -> Longs.compare((long)lhs.getLong(0), (long)rhs.getLong(0));
    private final VirtualColumns virtualColumns;
    private final LimitSpec limitSpec;
    @Nullable
    private final HavingSpec havingSpec;
    @Nullable
    private final DimFilter dimFilter;
    private final List<DimensionSpec> dimensions;
    private final List<String> groupingColumns;
    private final List<AggregatorFactory> aggregatorSpecs;
    private final List<PostAggregator> postAggregatorSpecs;
    @Nullable
    private final List<List<String>> subtotalsSpec;
    private final Function<Sequence<ResultRow>, Sequence<ResultRow>> postProcessingFn;
    private final RowSignature resultRowSignature;
    @Nullable
    private final DateTime universalTimestamp;
    private final boolean canDoLimitPushDown;
    @Nullable
    private Boolean forceLimitPushDown;

    public static Builder builder() {
        return new Builder();
    }

    @JsonCreator
    public GroupByQuery(@JsonProperty(value="dataSource") DataSource dataSource, @JsonProperty(value="intervals") QuerySegmentSpec querySegmentSpec, @JsonProperty(value="virtualColumns") VirtualColumns virtualColumns, @JsonProperty(value="filter") @Nullable DimFilter dimFilter, @JsonProperty(value="granularity") Granularity granularity, @JsonProperty(value="dimensions") List<DimensionSpec> dimensions, @JsonProperty(value="aggregations") List<AggregatorFactory> aggregatorSpecs, @JsonProperty(value="postAggregations") List<PostAggregator> postAggregatorSpecs, @JsonProperty(value="having") @Nullable HavingSpec havingSpec, @JsonProperty(value="limitSpec") @Nullable LimitSpec limitSpec, @JsonProperty(value="subtotalsSpec") @Nullable List<List<String>> subtotalsSpec, @JsonProperty(value="context") Map<String, Object> context) {
        this(dataSource, querySegmentSpec, virtualColumns, dimFilter, granularity, dimensions, aggregatorSpecs, postAggregatorSpecs, havingSpec, limitSpec, subtotalsSpec, null, context);
    }

    private Function<Sequence<ResultRow>, Sequence<ResultRow>> makePostProcessingFn() {
        Function postProcessingFn = this.limitSpec.build(this);
        if (this.havingSpec != null) {
            postProcessingFn = Functions.compose(postProcessingFn, input -> {
                this.havingSpec.setQuery(this);
                return Sequences.filter(input, this.havingSpec::eval);
            });
        }
        return postProcessingFn;
    }

    private GroupByQuery(DataSource dataSource, QuerySegmentSpec querySegmentSpec, VirtualColumns virtualColumns, @Nullable DimFilter dimFilter, Granularity granularity, @Nullable List<DimensionSpec> dimensions, @Nullable List<AggregatorFactory> aggregatorSpecs, @Nullable List<PostAggregator> postAggregatorSpecs, @Nullable HavingSpec havingSpec, @Nullable LimitSpec limitSpec, @Nullable List<List<String>> subtotalsSpec, @Nullable Function<Sequence<ResultRow>, Sequence<ResultRow>> postProcessingFn, Map<String, Object> context) {
        super(dataSource, querySegmentSpec, context, granularity);
        this.virtualColumns = VirtualColumns.nullToEmpty(virtualColumns);
        this.dimFilter = dimFilter;
        this.dimensions = dimensions == null ? ImmutableList.of() : dimensions;
        this.groupingColumns = new ArrayList<String>();
        for (DimensionSpec spec : this.dimensions) {
            Preconditions.checkArgument((spec != null ? 1 : 0) != 0, (Object)"dimensions has null DimensionSpec");
            this.groupingColumns.add(spec.getDimension());
        }
        this.aggregatorSpecs = aggregatorSpecs == null ? ImmutableList.of() : aggregatorSpecs;
        this.postAggregatorSpecs = Queries.prepareAggregations(this.dimensions.stream().map(DimensionSpec::getOutputName).collect(Collectors.toList()), this.aggregatorSpecs, (List<PostAggregator>)(postAggregatorSpecs == null ? ImmutableList.of() : postAggregatorSpecs));
        GroupByQuery.verifyOutputNames(this.dimensions, this.aggregatorSpecs, this.postAggregatorSpecs);
        this.universalTimestamp = this.computeUniversalTimestamp();
        this.resultRowSignature = this.computeResultRowSignature(RowSignature.Finalization.UNKNOWN);
        this.havingSpec = havingSpec;
        this.limitSpec = LimitSpec.nullToNoopLimitSpec(limitSpec);
        this.subtotalsSpec = this.verifySubtotalsSpec(subtotalsSpec, this.dimensions);
        this.postProcessingFn = postProcessingFn != null ? postProcessingFn : this.makePostProcessingFn();
        this.canDoLimitPushDown = this.canDoLimitPushDown(this.limitSpec, this.havingSpec, this.subtotalsSpec);
    }

    @Nullable
    private List<List<String>> verifySubtotalsSpec(@Nullable List<List<String>> subtotalsSpec, List<DimensionSpec> dimensions) {
        if (subtotalsSpec != null) {
            for (List<String> subtotalSpec : subtotalsSpec) {
                for (String s : subtotalSpec) {
                    boolean found = false;
                    for (DimensionSpec ds : dimensions) {
                        if (!s.equals(ds.getOutputName())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    throw new IAE("Subtotal spec %s is either not a subset of top level dimensions.", subtotalSpec);
                }
            }
        }
        return subtotalsSpec;
    }

    @Override
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=VirtualColumns.JsonIncludeFilter.class)
    public VirtualColumns getVirtualColumns() {
        return this.virtualColumns;
    }

    @Nullable
    @JsonProperty(value="filter")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public DimFilter getDimFilter() {
        return this.dimFilter;
    }

    @JsonProperty
    public List<DimensionSpec> getDimensions() {
        return this.dimensions;
    }

    @JsonProperty(value="aggregations")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<AggregatorFactory> getAggregatorSpecs() {
        return this.aggregatorSpecs;
    }

    @JsonProperty(value="postAggregations")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<PostAggregator> getPostAggregatorSpecs() {
        return this.postAggregatorSpecs;
    }

    @JsonProperty(value="having")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public HavingSpec getHavingSpec() {
        return this.havingSpec;
    }

    @JsonProperty
    public LimitSpec getLimitSpec() {
        return this.limitSpec;
    }

    @Nullable
    @JsonProperty(value="subtotalsSpec")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<List<String>> getSubtotalsSpec() {
        return this.subtotalsSpec;
    }

    @Override
    public RowSignature getResultRowSignature() {
        return this.resultRowSignature;
    }

    @Override
    public RowSignature getResultRowSignature(RowSignature.Finalization finalization) {
        if (finalization == RowSignature.Finalization.UNKNOWN) {
            return this.resultRowSignature;
        }
        return this.computeResultRowSignature(finalization);
    }

    public int getResultRowSizeWithoutPostAggregators() {
        return this.getResultRowPostAggregatorStart();
    }

    public int getResultRowSizeWithPostAggregators() {
        return this.resultRowSignature.size();
    }

    @Nullable
    public DateTime getUniversalTimestamp() {
        return this.universalTimestamp;
    }

    public boolean getResultRowHasTimestamp() {
        return this.universalTimestamp == null;
    }

    public int getResultRowDimensionStart() {
        return this.getResultRowHasTimestamp() ? 1 : 0;
    }

    public int getResultRowAggregatorStart() {
        return this.getResultRowDimensionStart() + this.dimensions.size();
    }

    public int getResultRowPostAggregatorStart() {
        return this.getResultRowAggregatorStart() + this.aggregatorSpecs.size();
    }

    @Override
    public boolean hasFilters() {
        return this.dimFilter != null;
    }

    @Override
    @Nullable
    public DimFilter getFilter() {
        return this.dimFilter;
    }

    @Override
    public String getType() {
        return "groupBy";
    }

    @JsonIgnore
    public boolean getContextSortByDimsFirst() {
        return this.context().getBoolean(CTX_KEY_SORT_BY_DIMS_FIRST, false);
    }

    @JsonIgnore
    public boolean isApplyLimitPushDown() {
        if (this.forceLimitPushDown == null) {
            this.forceLimitPushDown = this.validateAndGetForceLimitPushDown();
        }
        return this.forceLimitPushDown != false || this.canDoLimitPushDown;
    }

    @JsonIgnore
    public boolean getApplyLimitPushDownFromContext() {
        return this.context().getBoolean("applyLimitPushDown", true);
    }

    @Override
    public Ordering getResultOrdering() {
        Ordering<ResultRow> rowOrdering = this.getRowOrdering(false);
        return Ordering.from((lhs, rhs) -> {
            if (lhs instanceof ResultRow) {
                return rowOrdering.compare((Object)((ResultRow)lhs), (Object)((ResultRow)rhs));
            }
            return Comparators.naturalNullsFirst().compare(lhs, rhs);
        });
    }

    private boolean validateAndGetForceLimitPushDown() {
        boolean forcePushDown = this.context().getBoolean("forceLimitPushDown", false);
        if (forcePushDown) {
            if (!(this.limitSpec instanceof DefaultLimitSpec)) {
                throw new IAE("When forcing limit push down, a limit spec must be provided.", new Object[0]);
            }
            if (!((DefaultLimitSpec)this.limitSpec).isLimited()) {
                throw new IAE("When forcing limit push down, the provided limit spec must have a limit.", new Object[0]);
            }
            if (this.havingSpec != null) {
                throw new IAE("Cannot force limit push down when a having spec is present.", new Object[0]);
            }
            for (OrderByColumnSpec orderBySpec : ((DefaultLimitSpec)this.limitSpec).getColumns()) {
                if (OrderByColumnSpec.getPostAggIndexForOrderBy(orderBySpec, this.postAggregatorSpecs) <= -1) continue;
                throw new UnsupportedOperationException("Limit push down when sorting by a post aggregator is not supported.");
            }
        }
        return forcePushDown;
    }

    private RowSignature computeResultRowSignature(RowSignature.Finalization finalization) {
        RowSignature.Builder builder = RowSignature.builder();
        if (this.universalTimestamp == null) {
            builder.addTimeColumn();
        }
        return builder.addDimensions(this.dimensions).addAggregators(this.aggregatorSpecs, finalization).addPostAggregators(this.postAggregatorSpecs).build();
    }

    private boolean canDoLimitPushDown(@Nullable LimitSpec limitSpec, @Nullable HavingSpec havingSpec, @Nullable List<List<String>> subtotalsSpec) {
        if (subtotalsSpec != null && !subtotalsSpec.isEmpty()) {
            return false;
        }
        if (limitSpec instanceof DefaultLimitSpec) {
            DefaultLimitSpec limitSpecWithoutOffset = ((DefaultLimitSpec)limitSpec).withOffsetToLimit();
            if (!limitSpecWithoutOffset.isLimited()) {
                return false;
            }
            if (!this.getApplyLimitPushDownFromContext()) {
                return false;
            }
            if (havingSpec != null) {
                return false;
            }
            boolean sortHasNonGroupingFields = DefaultLimitSpec.sortingOrderHasNonGroupingFields((DefaultLimitSpec)limitSpec, this.getDimensions());
            return !sortHasNonGroupingFields;
        }
        return false;
    }

    public Ordering<ResultRow> getRowOrdering(boolean granular) {
        return this.getOrderingAndDimensions(granular).getRowOrdering();
    }

    public List<String> getDimensionNamesInOrder() {
        return this.getOrderingAndDimensions(false).getDimensions().stream().map(DimensionSpec::getOutputName).collect(Collectors.toList());
    }

    public OrderingAndDimensions getOrderingAndDimensions(boolean granular) {
        DefaultLimitSpec limitSpec1;
        boolean sortByDimsFirst = this.getContextSortByDimsFirst();
        IntArrayList orderedFieldNumbers = new IntArrayList();
        HashSet<Integer> dimsInOrderBy = new HashSet<Integer>();
        ArrayList<Boolean> needsReverseList = new ArrayList<Boolean>();
        ArrayList<ColumnType> dimensionTypes = new ArrayList<ColumnType>();
        ArrayList<StringComparator> comparators = new ArrayList<StringComparator>();
        ArrayList<DimensionSpec> dimensionsInOrder = new ArrayList<DimensionSpec>();
        if (this.isApplyLimitPushDown() && !DefaultLimitSpec.sortingOrderHasNonGroupingFields(limitSpec1 = (DefaultLimitSpec)this.limitSpec, this.dimensions)) {
            for (OrderByColumnSpec orderSpec : ((DefaultLimitSpec)this.limitSpec).getColumns()) {
                boolean needsReverse;
                boolean bl = needsReverse = orderSpec.getDirection() != OrderByColumnSpec.Direction.ASCENDING;
                int dimIndex = OrderByColumnSpec.getDimIndexForOrderBy(orderSpec, this.dimensions);
                if (dimIndex < 0) continue;
                DimensionSpec dim = this.dimensions.get(dimIndex);
                orderedFieldNumbers.add(this.resultRowSignature.indexOf(dim.getOutputName()));
                dimsInOrderBy.add(dimIndex);
                needsReverseList.add(needsReverse);
                ColumnType type = this.dimensions.get(dimIndex).getOutputType();
                dimensionTypes.add(type);
                comparators.add(orderSpec.getDimensionComparator());
                dimensionsInOrder.add(dim);
            }
        }
        for (int i = 0; i < this.dimensions.size(); ++i) {
            if (dimsInOrderBy.contains(i)) continue;
            orderedFieldNumbers.add(this.resultRowSignature.indexOf(this.dimensions.get(i).getOutputName()));
            needsReverseList.add(false);
            ColumnType type = this.dimensions.get(i).getOutputType();
            dimensionTypes.add(type);
            comparators.add(StringComparators.NATURAL);
            dimensionsInOrder.add(this.dimensions.get(i));
        }
        Comparator<ResultRow> timeComparator = this.getTimeComparator(granular);
        Ordering ordering = timeComparator == null ? Ordering.from((arg_0, arg_1) -> GroupByQuery.lambda$getOrderingAndDimensions$3((IntList)orderedFieldNumbers, needsReverseList, dimensionTypes, comparators, arg_0, arg_1)) : (sortByDimsFirst ? Ordering.from((arg_0, arg_1) -> GroupByQuery.lambda$getOrderingAndDimensions$4((IntList)orderedFieldNumbers, needsReverseList, dimensionTypes, comparators, timeComparator, arg_0, arg_1)) : Ordering.from((arg_0, arg_1) -> GroupByQuery.lambda$getOrderingAndDimensions$5(timeComparator, (IntList)orderedFieldNumbers, needsReverseList, dimensionTypes, comparators, arg_0, arg_1)));
        return new OrderingAndDimensions((Ordering<ResultRow>)ordering, dimensionsInOrder);
    }

    @Nullable
    private Comparator<ResultRow> getTimeComparator(boolean granular) {
        if (Granularities.ALL.equals(this.getGranularity())) {
            return null;
        }
        if (!this.getResultRowHasTimestamp()) {
            throw new ISE("Cannot do time comparisons!", new Object[0]);
        }
        if (granular) {
            return (lhs, rhs) -> Longs.compare((long)this.getGranularity().bucketStart(lhs.getLong(0)), (long)this.getGranularity().bucketStart(rhs.getLong(0)));
        }
        return NON_GRANULAR_TIME_COMP;
    }

    @Nullable
    private DateTime computeUniversalTimestamp() {
        String timestampStringFromContext = this.context().getString(CTX_KEY_FUDGE_TIMESTAMP, "");
        Granularity granularity = this.getGranularity();
        if (!timestampStringFromContext.isEmpty()) {
            return DateTimes.utc(Long.parseLong(timestampStringFromContext));
        }
        if (Granularities.ALL.equals(granularity)) {
            List<Interval> intervals = this.getIntervals();
            if (intervals.isEmpty()) {
                return null;
            }
            DateTime timeStart = intervals.get(0).getStart();
            return granularity.getIterable(new Interval((ReadableInstant)timeStart, (ReadableInstant)timeStart.plus(1L))).iterator().next().getStart();
        }
        return null;
    }

    private static int compareDims(IntList fields, List<Boolean> needsReverseList, List<ColumnType> dimensionTypes, List<StringComparator> comparators, ResultRow lhs, ResultRow rhs) {
        for (int i = 0; i < fields.size(); ++i) {
            Object[] rhsArr;
            Object[] lhsArr;
            int dimCompare;
            int fieldNumber = fields.getInt(i);
            StringComparator comparator = comparators.get(i);
            ColumnType dimensionType = dimensionTypes.get(i);
            Object lhsObj = lhs.get(fieldNumber);
            Object rhsObj = rhs.get(fieldNumber);
            if (dimensionType.isNumeric()) {
                dimCompare = DimensionComparisonUtils.isNaturalComparator((ValueType)dimensionType.getType(), comparator) ? DimensionHandlerUtils.compareObjectsAsType(lhsObj, rhsObj, dimensionType) : comparator.compare(String.valueOf(lhsObj), String.valueOf(rhsObj));
            } else if (dimensionType.equals(ColumnType.STRING_ARRAY)) {
                lhsArr = DimensionHandlerUtils.coerceToStringArray(lhsObj);
                rhsArr = DimensionHandlerUtils.coerceToStringArray(rhsObj);
                dimCompare = ColumnType.STRING_ARRAY.getNullableStrategy().compare(lhsArr, rhsArr);
            } else if (dimensionType.equals(ColumnType.LONG_ARRAY) || dimensionType.equals(ColumnType.DOUBLE_ARRAY)) {
                lhsArr = DimensionHandlerUtils.convertToArray(lhsObj, dimensionType.getElementType());
                rhsArr = DimensionHandlerUtils.convertToArray(rhsObj, dimensionType.getElementType());
                dimCompare = dimensionType.getNullableStrategy().compare(lhsArr, rhsArr);
            } else {
                dimCompare = DimensionComparisonUtils.isNaturalComparator((ValueType)dimensionType.getType(), comparator) ? DimensionHandlerUtils.compareObjectsAsType(lhsObj, rhsObj, dimensionType) : comparator.compare((String)lhsObj, (String)rhsObj);
            }
            if (dimCompare == 0) continue;
            return needsReverseList.get(i) != false ? -dimCompare : dimCompare;
        }
        return 0;
    }

    public Sequence<ResultRow> postProcess(Sequence<ResultRow> results) {
        return (Sequence)this.postProcessingFn.apply(results);
    }

    @Override
    @Nullable
    public Set<String> getRequiredColumns() {
        return Queries.computeRequiredColumns(this.virtualColumns, this.dimFilter, this.groupingColumns, this.aggregatorSpecs);
    }

    @JsonIgnore
    public List<String> getGroupingColumns() {
        return this.groupingColumns;
    }

    public GroupByQuery withOverriddenContext(Map<String, Object> contextOverride) {
        return new Builder(this).overrideContext(contextOverride).build();
    }

    public GroupByQuery withQuerySegmentSpec(QuerySegmentSpec spec) {
        return new Builder(this).setQuerySegmentSpec(spec).build();
    }

    public GroupByQuery withVirtualColumns(VirtualColumns virtualColumns) {
        return new Builder(this).setVirtualColumns(virtualColumns).build();
    }

    public GroupByQuery withDimFilter(@Nullable DimFilter dimFilter) {
        return new Builder(this).setDimFilter(dimFilter).build();
    }

    @Override
    public Query<ResultRow> withDataSource(DataSource dataSource) {
        return new Builder(this).setDataSource(dataSource).build();
    }

    public GroupByQuery withDimensionSpecs(List<DimensionSpec> dimensionSpecs) {
        return new Builder(this).setDimensions(dimensionSpecs).build();
    }

    public GroupByQuery withLimitSpec(LimitSpec limitSpec) {
        return new Builder(this).setLimitSpec(limitSpec).build();
    }

    public GroupByQuery withAggregatorSpecs(List<AggregatorFactory> aggregatorSpecs) {
        return new Builder(this).setAggregatorSpecs(aggregatorSpecs).build();
    }

    public GroupByQuery withSubtotalsSpec(@Nullable List<List<String>> subtotalsSpec) {
        return new Builder(this).setSubtotalsSpec(subtotalsSpec).build();
    }

    public GroupByQuery withPostAggregatorSpecs(List<PostAggregator> postAggregatorSpecs) {
        return new Builder(this).setPostAggregatorSpecs(postAggregatorSpecs).build();
    }

    private static void verifyOutputNames(List<DimensionSpec> dimensions, List<AggregatorFactory> aggregators, List<PostAggregator> postAggregators) {
        HashSet<String> outputNames = new HashSet<String>();
        for (DimensionSpec dimension : dimensions) {
            if (outputNames.add(dimension.getOutputName())) continue;
            throw new IAE("Duplicate output name[%s]", dimension.getOutputName());
        }
        for (AggregatorFactory aggregator : aggregators) {
            if (outputNames.add(aggregator.getName())) continue;
            throw new IAE("Duplicate output name[%s]", aggregator.getName());
        }
        for (PostAggregator postAggregator : postAggregators) {
            if (outputNames.add(postAggregator.getName())) continue;
            throw new IAE("Duplicate output name[%s]", postAggregator.getName());
        }
        if (outputNames.contains("__time")) {
            throw new IAE("'%s' cannot be used as an output name for dimensions, aggregators, or post-aggregators.", "__time");
        }
    }

    public String toString() {
        return "GroupByQuery{dataSource='" + this.getDataSource() + "', querySegmentSpec=" + this.getQuerySegmentSpec() + ", virtualColumns=" + this.virtualColumns + ", limitSpec=" + this.limitSpec + ", dimFilter=" + this.dimFilter + ", granularity=" + this.getGranularity() + ", dimensions=" + this.dimensions + ", aggregatorSpecs=" + this.aggregatorSpecs + ", postAggregatorSpecs=" + this.postAggregatorSpecs + (String)(this.subtotalsSpec != null ? ", subtotalsSpec=" + this.subtotalsSpec : "") + ", havingSpec=" + this.havingSpec + ", context=" + this.getContext() + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GroupByQuery that = (GroupByQuery)o;
        return Objects.equals(this.virtualColumns, that.virtualColumns) && Objects.equals(this.limitSpec, that.limitSpec) && Objects.equals(this.havingSpec, that.havingSpec) && Objects.equals(this.dimFilter, that.dimFilter) && Objects.equals(this.dimensions, that.dimensions) && Objects.equals(this.aggregatorSpecs, that.aggregatorSpecs) && Objects.equals(this.postAggregatorSpecs, that.postAggregatorSpecs) && Objects.equals(this.subtotalsSpec, that.subtotalsSpec);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.virtualColumns, this.limitSpec, this.havingSpec, this.dimFilter, this.dimensions, this.aggregatorSpecs, this.postAggregatorSpecs, this.subtotalsSpec);
    }

    private static /* synthetic */ int lambda$getOrderingAndDimensions$5(Comparator timeComparator, IntList orderedFieldNumbers, List needsReverseList, List dimensionTypes, List comparators, ResultRow lhs, ResultRow rhs) {
        int timeCompare = timeComparator.compare(lhs, rhs);
        if (timeCompare != 0) {
            return timeCompare;
        }
        return GroupByQuery.compareDims(orderedFieldNumbers, needsReverseList, dimensionTypes, comparators, lhs, rhs);
    }

    private static /* synthetic */ int lambda$getOrderingAndDimensions$4(IntList orderedFieldNumbers, List needsReverseList, List dimensionTypes, List comparators, Comparator timeComparator, ResultRow lhs, ResultRow rhs) {
        int cmp = GroupByQuery.compareDims(orderedFieldNumbers, needsReverseList, dimensionTypes, comparators, lhs, rhs);
        if (cmp != 0) {
            return cmp;
        }
        return timeComparator.compare(lhs, rhs);
    }

    private static /* synthetic */ int lambda$getOrderingAndDimensions$3(IntList orderedFieldNumbers, List needsReverseList, List dimensionTypes, List comparators, ResultRow lhs, ResultRow rhs) {
        return GroupByQuery.compareDims(orderedFieldNumbers, needsReverseList, dimensionTypes, comparators, lhs, rhs);
    }

    public static class Builder {
        private DataSource dataSource;
        private QuerySegmentSpec querySegmentSpec;
        private VirtualColumns virtualColumns;
        @Nullable
        private DimFilter dimFilter;
        private Granularity granularity;
        @Nullable
        private List<DimensionSpec> dimensions;
        @Nullable
        private List<AggregatorFactory> aggregatorSpecs;
        @Nullable
        private List<PostAggregator> postAggregatorSpecs;
        @Nullable
        private HavingSpec havingSpec;
        @Nullable
        private Map<String, Object> context;
        @Nullable
        private List<List<String>> subtotalsSpec = null;
        @Nullable
        private LimitSpec limitSpec = null;
        @Nullable
        private Function<Sequence<ResultRow>, Sequence<ResultRow>> postProcessingFn;
        private List<OrderByColumnSpec> orderByColumnSpecs = new ArrayList<OrderByColumnSpec>();
        private int limit = Integer.MAX_VALUE;

        @Nullable
        private static List<List<String>> copySubtotalSpec(@Nullable List<List<String>> subtotalsSpec) {
            if (subtotalsSpec == null) {
                return null;
            }
            return subtotalsSpec.stream().map(ArrayList::new).collect(Collectors.toList());
        }

        public Builder() {
        }

        public Builder(GroupByQuery query) {
            this.dataSource = query.getDataSource();
            this.querySegmentSpec = query.getQuerySegmentSpec();
            this.virtualColumns = query.getVirtualColumns();
            this.dimFilter = query.getDimFilter();
            this.granularity = query.getGranularity();
            this.dimensions = query.getDimensions();
            this.aggregatorSpecs = query.getAggregatorSpecs();
            this.postAggregatorSpecs = query.getPostAggregatorSpecs();
            this.havingSpec = query.getHavingSpec();
            this.limitSpec = query.getLimitSpec();
            this.subtotalsSpec = query.subtotalsSpec;
            this.postProcessingFn = query.postProcessingFn;
            this.context = query.getContext();
        }

        public Builder(Builder builder) {
            this.dataSource = builder.dataSource;
            this.querySegmentSpec = builder.querySegmentSpec;
            this.virtualColumns = builder.virtualColumns;
            this.dimFilter = builder.dimFilter;
            this.granularity = builder.granularity;
            this.dimensions = builder.dimensions;
            this.aggregatorSpecs = builder.aggregatorSpecs;
            this.postAggregatorSpecs = builder.postAggregatorSpecs;
            this.havingSpec = builder.havingSpec;
            this.limitSpec = builder.limitSpec;
            this.subtotalsSpec = Builder.copySubtotalSpec(builder.subtotalsSpec);
            this.postProcessingFn = builder.postProcessingFn;
            this.limit = builder.limit;
            this.orderByColumnSpecs = new ArrayList<OrderByColumnSpec>(builder.orderByColumnSpecs);
            this.context = builder.context;
        }

        public Builder setDataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public Builder setDataSource(String dataSource) {
            this.dataSource = new TableDataSource(dataSource);
            return this;
        }

        public Builder setDataSource(Query query) {
            this.dataSource = new QueryDataSource(query);
            return this;
        }

        public Builder setInterval(QuerySegmentSpec interval) {
            return this.setQuerySegmentSpec(interval);
        }

        public Builder setInterval(List<Interval> intervals) {
            return this.setQuerySegmentSpec(new LegacySegmentSpec((Object)intervals));
        }

        public Builder setInterval(Interval interval) {
            return this.setQuerySegmentSpec(new LegacySegmentSpec(interval));
        }

        public Builder setInterval(String interval) {
            return this.setQuerySegmentSpec(new LegacySegmentSpec(interval));
        }

        public Builder setVirtualColumns(VirtualColumns virtualColumns) {
            this.virtualColumns = (VirtualColumns)Preconditions.checkNotNull((Object)virtualColumns, (Object)"virtualColumns");
            return this;
        }

        public Builder setVirtualColumns(VirtualColumn ... virtualColumns) {
            this.virtualColumns = VirtualColumns.create(Arrays.asList(virtualColumns));
            return this;
        }

        public Builder setLimit(int limit) {
            this.ensureExplicitLimitSpecNotSet();
            this.limit = limit;
            this.postProcessingFn = null;
            return this;
        }

        public Builder setSubtotalsSpec(@Nullable List<List<String>> subtotalsSpec) {
            this.subtotalsSpec = subtotalsSpec;
            return this;
        }

        public Builder addOrderByColumn(String dimension) {
            return this.addOrderByColumn(dimension, null);
        }

        public Builder addOrderByColumn(String dimension, @Nullable OrderByColumnSpec.Direction direction) {
            return this.addOrderByColumn(new OrderByColumnSpec(dimension, direction));
        }

        public Builder addOrderByColumn(OrderByColumnSpec columnSpec) {
            this.ensureExplicitLimitSpecNotSet();
            this.orderByColumnSpecs.add(columnSpec);
            this.postProcessingFn = null;
            return this;
        }

        public Builder setLimitSpec(LimitSpec limitSpec) {
            Preconditions.checkNotNull((Object)limitSpec);
            this.ensureFluentLimitsNotSet();
            this.limitSpec = limitSpec;
            this.postProcessingFn = null;
            return this;
        }

        private void ensureExplicitLimitSpecNotSet() {
            if (this.limitSpec != null) {
                throw new ISE("Ambiguous build, limitSpec[%s] already set", this.limitSpec);
            }
        }

        private void ensureFluentLimitsNotSet() {
            if (this.limit != Integer.MAX_VALUE || !this.orderByColumnSpecs.isEmpty()) {
                throw new ISE("Ambiguous build, limit[%s] or columnSpecs[%s] already set.", this.limit, this.orderByColumnSpecs);
            }
        }

        public Builder setQuerySegmentSpec(QuerySegmentSpec querySegmentSpec) {
            this.querySegmentSpec = querySegmentSpec;
            return this;
        }

        public Builder setDimFilter(@Nullable DimFilter dimFilter) {
            this.dimFilter = dimFilter;
            return this;
        }

        public Builder setGranularity(Granularity granularity) {
            this.granularity = granularity;
            return this;
        }

        public Builder addDimension(String column) {
            return this.addDimension(column, column);
        }

        public Builder addDimension(String column, String outputName) {
            return this.addDimension(new DefaultDimensionSpec(column, outputName));
        }

        public Builder addDimension(DimensionSpec dimension) {
            if (this.dimensions == null) {
                this.dimensions = new ArrayList<DimensionSpec>();
            }
            this.dimensions.add(dimension);
            this.postProcessingFn = null;
            return this;
        }

        public Builder setDimensions(List<DimensionSpec> dimensions) {
            this.dimensions = Lists.newArrayList(dimensions);
            this.postProcessingFn = null;
            return this;
        }

        public Builder setDimensions(DimensionSpec ... dimensions) {
            this.dimensions = new ArrayList<DimensionSpec>(Arrays.asList(dimensions));
            this.postProcessingFn = null;
            return this;
        }

        public Builder addAggregator(AggregatorFactory aggregator) {
            if (this.aggregatorSpecs == null) {
                this.aggregatorSpecs = new ArrayList<AggregatorFactory>();
            }
            this.aggregatorSpecs.add(aggregator);
            this.postProcessingFn = null;
            return this;
        }

        public Builder setAggregatorSpecs(List<AggregatorFactory> aggregatorSpecs) {
            this.aggregatorSpecs = Lists.newArrayList(aggregatorSpecs);
            this.postProcessingFn = null;
            return this;
        }

        public Builder setAggregatorSpecs(AggregatorFactory ... aggregatorSpecs) {
            this.aggregatorSpecs = new ArrayList<AggregatorFactory>(Arrays.asList(aggregatorSpecs));
            this.postProcessingFn = null;
            return this;
        }

        public Builder setPostAggregatorSpecs(List<PostAggregator> postAggregatorSpecs) {
            this.postAggregatorSpecs = Lists.newArrayList(postAggregatorSpecs);
            this.postProcessingFn = null;
            return this;
        }

        public Builder setPostAggregatorSpecs(PostAggregator ... postAggregatorSpecs) {
            this.postAggregatorSpecs = Lists.newArrayList((Object[])postAggregatorSpecs);
            this.postProcessingFn = null;
            return this;
        }

        public Builder setContext(Map<String, Object> context) {
            this.context = context;
            return this;
        }

        public Builder queryId(String queryId) {
            this.context = BaseQuery.computeOverriddenContext(this.context, (Map<String, Object>)ImmutableMap.of((Object)"queryId", (Object)queryId));
            return this;
        }

        public Builder overrideContext(Map<String, Object> contextOverride) {
            this.context = BaseQuery.computeOverriddenContext(this.context, contextOverride);
            return this;
        }

        public Builder setHavingSpec(@Nullable HavingSpec havingSpec) {
            this.havingSpec = havingSpec;
            this.postProcessingFn = null;
            return this;
        }

        public Builder copy() {
            return new Builder(this);
        }

        public GroupByQuery build() {
            LimitSpec theLimitSpec = this.limitSpec == null ? (this.orderByColumnSpecs.isEmpty() && this.limit == Integer.MAX_VALUE ? NoopLimitSpec.instance() : new DefaultLimitSpec(this.orderByColumnSpecs, 0, this.limit)) : this.limitSpec;
            return new GroupByQuery(this.dataSource, this.querySegmentSpec, this.virtualColumns, this.dimFilter, this.granularity, this.dimensions, this.aggregatorSpecs, this.postAggregatorSpecs, this.havingSpec, theLimitSpec, this.subtotalsSpec, this.postProcessingFn, this.context);
        }
    }

    public static class OrderingAndDimensions {
        Ordering<ResultRow> rowOrdering;
        List<DimensionSpec> dimensions;

        public OrderingAndDimensions(Ordering<ResultRow> rowOrdering, List<DimensionSpec> dimensions) {
            this.rowOrdering = rowOrdering;
            this.dimensions = dimensions;
        }

        public Ordering<ResultRow> getRowOrdering() {
            return this.rowOrdering;
        }

        public List<DimensionSpec> getDimensions() {
            return this.dimensions;
        }
    }
}

