/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.context;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.NonnullPair;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.context.DefaultResponseContext;
import org.apache.druid.utils.CollectionUtils;
import org.joda.time.Interval;

public abstract class ResponseContext {
    private static final Comparator<Map.Entry<String, JsonNode>> VALUE_LENGTH_REVERSED_COMPARATOR = Comparator.comparing(e -> ((JsonNode)e.getValue()).toString().length()).reversed();

    protected abstract Map<Key, Object> getDelegate();

    public Map<String, Object> toMap() {
        return CollectionUtils.mapKeys(this.getDelegate(), k -> k.getName());
    }

    public static ResponseContext createEmpty() {
        return DefaultResponseContext.createEmpty();
    }

    public void initialize() {
        this.putValue(Keys.QUERY_TOTAL_BYTES_GATHERED, new AtomicLong());
        this.initializeRemainingResponses();
    }

    public void initializeRemainingResponses() {
        this.putValue(Keys.REMAINING_RESPONSES_FROM_QUERY_SERVERS, new ConcurrentHashMap());
    }

    public void initializeMissingSegments() {
        this.putValue(Keys.MISSING_SEGMENTS, new ArrayList());
    }

    public void initializeRowScanCount() {
        this.putValue(Keys.NUM_SCANNED_ROWS, 0L);
    }

    public static ResponseContext deserialize(String responseContext, ObjectMapper objectMapper) throws IOException {
        return (ResponseContext)objectMapper.readValue(responseContext, ResponseContext.class);
    }

    public Object put(Key key, Object value) {
        Key registeredKey = Keys.instance().keyOf(key.getName());
        return this.putValue(registeredKey, value);
    }

    public void putUncoveredIntervals(List<Interval> intervals, boolean overflowed) {
        this.putValue(Keys.UNCOVERED_INTERVALS, intervals);
        this.putValue(Keys.UNCOVERED_INTERVALS_OVERFLOWED, overflowed);
    }

    public void putEntityTag(String eTag) {
        this.putValue(Keys.ETAG, eTag);
    }

    public void putTimeoutTime(long time) {
        this.putValue(Keys.TIMEOUT_AT, time);
    }

    public void putQueryFailDeadlineMs(long deadlineMs) {
        this.putValue(Keys.QUERY_FAIL_DEADLINE_MILLIS, deadlineMs);
    }

    private Object putValue(Key key, Object value) {
        return this.getDelegate().put(key, value);
    }

    public Object get(Key key) {
        return this.getDelegate().get(key);
    }

    public ConcurrentHashMap<String, Integer> getRemainingResponses() {
        return (ConcurrentHashMap)this.get(Keys.REMAINING_RESPONSES_FROM_QUERY_SERVERS);
    }

    public List<Interval> getUncoveredIntervals() {
        return (List)this.get(Keys.UNCOVERED_INTERVALS);
    }

    public List<SegmentDescriptor> getMissingSegments() {
        return (List)this.get(Keys.MISSING_SEGMENTS);
    }

    public String getEntityTag() {
        return (String)this.get(Keys.ETAG);
    }

    public AtomicLong getTotalBytes() {
        return (AtomicLong)this.get(Keys.QUERY_TOTAL_BYTES_GATHERED);
    }

    public Long getTimeoutTime() {
        return (Long)this.get(Keys.TIMEOUT_AT);
    }

    public Long getRowScanCount() {
        return (Long)this.get(Keys.NUM_SCANNED_ROWS);
    }

    public Long getCpuNanos() {
        return (Long)this.get(Keys.CPU_CONSUMED_NANOS);
    }

    public Object remove(Key key) {
        return this.getDelegate().remove(key);
    }

    public Object add(Key key, Object value) {
        Key registeredKey = Keys.instance().keyOf(key.getName());
        return this.addValue(registeredKey, value);
    }

    public void addRemainingResponse(String id, int count) {
        this.addValue(Keys.REMAINING_RESPONSES_FROM_QUERY_SERVERS, new NonnullPair<String, Integer>(id, count));
    }

    public void addMissingSegments(List<SegmentDescriptor> descriptors) {
        this.addValue(Keys.MISSING_SEGMENTS, descriptors);
    }

    public void addRowScanCount(long count) {
        this.addValue(Keys.NUM_SCANNED_ROWS, count);
    }

    public void addCpuNanos(long ns) {
        this.addValue(Keys.CPU_CONSUMED_NANOS, ns);
    }

    private Object addValue(Key key, Object value) {
        return this.getDelegate().merge(key, value, key::mergeValues);
    }

    public void merge(ResponseContext responseContext) {
        if (responseContext == null) {
            return;
        }
        responseContext.getDelegate().forEach((key, newValue) -> {
            if (newValue != null) {
                this.add((Key)key, newValue);
            }
        });
    }

    public SerializationResult serializeWith(ObjectMapper objectMapper, int maxCharsNumber) throws JsonProcessingException {
        Map<Key, Object> headerMap = this.getDelegate().entrySet().stream().filter(entry -> ((Key)entry.getKey()).includeInHeader()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        String fullSerializedString = objectMapper.writeValueAsString(headerMap);
        if (fullSerializedString.length() <= maxCharsNumber) {
            return new SerializationResult(null, fullSerializedString);
        }
        int needToRemoveCharsNumber = fullSerializedString.length() - maxCharsNumber;
        headerMap.put(Keys.TRUNCATED, true);
        needToRemoveCharsNumber += Keys.TRUNCATED.getName().length() + 7;
        ObjectNode contextJsonNode = (ObjectNode)objectMapper.valueToTree(headerMap);
        ArrayList sortedNodesByLength = Lists.newArrayList((Iterator)contextJsonNode.fields());
        sortedNodesByLength.sort(VALUE_LENGTH_REVERSED_COMPARATOR);
        for (Map.Entry e : sortedNodesByLength) {
            String fieldName = (String)e.getKey();
            if (!Keys.instance().keyOf(fieldName).canDrop()) continue;
            JsonNode node = (JsonNode)e.getValue();
            int removeLength = fieldName.length() + node.toString().length();
            if (removeLength < needToRemoveCharsNumber || !node.isArray()) {
                contextJsonNode.remove(fieldName);
                needToRemoveCharsNumber -= removeLength;
            } else {
                ArrayNode arrayNode = (ArrayNode)node;
                int removed = ResponseContext.removeNodeElementsToSatisfyCharsLimit(arrayNode, needToRemoveCharsNumber);
                if (arrayNode.size() == 0) {
                    contextJsonNode.remove(fieldName);
                    needToRemoveCharsNumber -= removeLength;
                } else {
                    needToRemoveCharsNumber -= removed;
                }
            }
            if (needToRemoveCharsNumber > 0) continue;
            break;
        }
        return new SerializationResult(contextJsonNode.toString(), fullSerializedString);
    }

    private static int removeNodeElementsToSatisfyCharsLimit(ArrayNode node, int target) {
        int nodeLen;
        int startLen = nodeLen = node.toString().length();
        while (node.size() > 0 && target > startLen - nodeLen) {
            int removeUntil = node.size() / 2;
            for (int removeAt = node.size() - 1; removeAt >= removeUntil; --removeAt) {
                node.remove(removeAt);
            }
            nodeLen = node.toString().length();
        }
        return startLen - nodeLen;
    }

    public static class SerializationResult {
        @Nullable
        private final String truncatedResult;
        private final String fullResult;

        public SerializationResult(@Nullable String truncatedResult, String fullResult) {
            this.truncatedResult = truncatedResult;
            this.fullResult = fullResult;
        }

        public String getResult() {
            return this.isTruncated() ? this.truncatedResult : this.fullResult;
        }

        public String getFullResult() {
            return this.fullResult;
        }

        public boolean isTruncated() {
            return this.truncatedResult != null;
        }
    }

    public static class Keys {
        public static final Key UNCOVERED_INTERVALS = new AbstractKey("uncoveredIntervals", true, true, (TypeReference)new TypeReference<List<Interval>>(){}){

            @Override
            public Object mergeValues(Object oldValue, Object newValue) {
                ArrayList result = new ArrayList((List)oldValue);
                result.addAll((List)newValue);
                return result;
            }
        };
        public static final Key UNCOVERED_INTERVALS_OVERFLOWED = new BooleanKey("uncoveredIntervalsOverflowed", true);
        public static final Key REMAINING_RESPONSES_FROM_QUERY_SERVERS = new AbstractKey("remainingResponsesFromQueryServers", false, true, (Class)Object.class){

            @Override
            public Object mergeValues(Object totalRemainingPerId, Object idAndNumResponses) {
                ConcurrentHashMap map = (ConcurrentHashMap)totalRemainingPerId;
                NonnullPair pair = (NonnullPair)idAndNumResponses;
                map.compute((String)pair.lhs, (id, remaining) -> remaining == null ? (Integer)pair.rhs : remaining + (Integer)pair.rhs);
                return map;
            }
        };
        public static final Key MISSING_SEGMENTS = new AbstractKey("missingSegments", true, true, (TypeReference)new TypeReference<List<SegmentDescriptor>>(){}){

            @Override
            public Object mergeValues(Object oldValue, Object newValue) {
                ArrayList result = new ArrayList((List)oldValue);
                result.addAll((List)newValue);
                return result;
            }
        };
        public static final Key ETAG = new StringKey("ETag", false, true);
        public static final Key QUERY_TOTAL_BYTES_GATHERED = new AbstractKey("queryTotalBytesGathered", false, false, (TypeReference)new TypeReference<AtomicLong>(){}){

            @Override
            public Object mergeValues(Object oldValue, Object newValue) {
                return ((AtomicLong)newValue).addAndGet(((AtomicLong)newValue).get());
            }
        };
        public static final Key QUERY_FAIL_DEADLINE_MILLIS = new LongKey("queryFailTime", false);
        public static final Key TIMEOUT_AT = new LongKey("timeoutAt", false);
        public static final Key NUM_SCANNED_ROWS = new CounterKey("count", false);
        public static final Key CPU_CONSUMED_NANOS = new CounterKey("cpuConsumed", false);
        public static final Key TRUNCATED = new BooleanKey("truncated", false);
        public static final Keys INSTANCE = new Keys();
        private final ConcurrentMap<String, Key> registeredKeys = new ConcurrentSkipListMap<String, Key>();

        private Keys() {
        }

        public static Keys instance() {
            return INSTANCE;
        }

        public void registerKey(Key key) {
            if (this.registeredKeys.putIfAbsent(key.getName(), key) != null) {
                throw new IAE("Key [%s] has already been registered as a context key", key.getName());
            }
        }

        public void registerKeys(Key[] keys) {
            for (Key key : keys) {
                this.registerKey(key);
            }
        }

        public Key keyOf(String name) {
            Key key = (Key)this.registeredKeys.get(name);
            if (key == null) {
                throw new ISE("Key [%s] is not registered as a context key", name);
            }
            return key;
        }

        public Key find(String name) {
            return (Key)this.registeredKeys.get(name);
        }

        static {
            Keys.instance().registerKeys(new Key[]{UNCOVERED_INTERVALS, UNCOVERED_INTERVALS_OVERFLOWED, REMAINING_RESPONSES_FROM_QUERY_SERVERS, MISSING_SEGMENTS, ETAG, QUERY_TOTAL_BYTES_GATHERED, QUERY_FAIL_DEADLINE_MILLIS, TIMEOUT_AT, NUM_SCANNED_ROWS, CPU_CONSUMED_NANOS, TRUNCATED});
        }
    }

    public static class CounterKey
    extends AbstractKey {
        CounterKey(String name, boolean inHeader) {
            super(name, inHeader, false, Long.class);
        }

        @Override
        public Object mergeValues(Object oldValue, Object newValue) {
            if (oldValue == null) {
                return newValue;
            }
            if (newValue == null) {
                return oldValue;
            }
            return (Long)oldValue + (Long)newValue;
        }
    }

    public static class LongKey
    extends AbstractKey {
        LongKey(String name, boolean inHeader) {
            super(name, inHeader, false, Long.class);
        }

        @Override
        public Object mergeValues(Object oldValue, Object newValue) {
            return newValue;
        }
    }

    public static class BooleanKey
    extends AbstractKey {
        BooleanKey(String name, boolean inHeader) {
            super(name, inHeader, false, Boolean.class);
        }

        @Override
        public Object mergeValues(Object oldValue, Object newValue) {
            return (Boolean)oldValue != false || (Boolean)newValue != false;
        }
    }

    public static class StringKey
    extends AbstractKey {
        StringKey(String name, boolean inHeader, boolean canDrop) {
            super(name, inHeader, canDrop, String.class);
        }

        @Override
        public Object mergeValues(Object oldValue, Object newValue) {
            return newValue;
        }
    }

    public static abstract class AbstractKey
    implements Key {
        private final String name;
        private final boolean inHeader;
        private final boolean canDrop;
        private final Function<JsonParser, Object> parseFunction;

        AbstractKey(String name, boolean inHeader, boolean canDrop, Class<?> serializedClass) {
            this.name = name;
            this.inHeader = inHeader;
            this.canDrop = canDrop;
            this.parseFunction = jp -> {
                try {
                    return jp.readValueAs(serializedClass);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            };
        }

        AbstractKey(String name, boolean inHeader, boolean canDrop, TypeReference<?> serializedTypeReference) {
            this.name = name;
            this.inHeader = inHeader;
            this.canDrop = canDrop;
            this.parseFunction = jp -> {
                try {
                    return jp.readValueAs(serializedTypeReference);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            };
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean includeInHeader() {
            return this.inHeader;
        }

        @Override
        public boolean canDrop() {
            return this.canDrop;
        }

        @Override
        public Object readValue(JsonParser jp) {
            return this.parseFunction.apply(jp);
        }

        public String toString() {
            return this.name;
        }
    }

    public static interface Key {
        @JsonValue
        public String getName();

        public boolean includeInHeader();

        public Object readValue(JsonParser var1);

        public Object mergeValues(Object var1, Object var2);

        @JsonIgnore
        public boolean canDrop();
    }
}

