/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.druid.query.BySegmentResultValue;
import org.joda.time.Interval;

public class BySegmentResultValueClass<T>
implements BySegmentResultValue<T> {
    private final List<T> results;
    private final String segmentId;
    private final Interval interval;

    public BySegmentResultValueClass(@JsonProperty(value="results") List<T> results, @JsonProperty(value="segment") String segmentId, @JsonProperty(value="interval") Interval interval) {
        this.results = results;
        this.segmentId = segmentId;
        this.interval = interval;
    }

    @Override
    @JsonProperty(value="results")
    public List<T> getResults() {
        return this.results;
    }

    @Override
    @JsonProperty(value="segment")
    public String getSegmentId() {
        return this.segmentId;
    }

    @Override
    @JsonProperty(value="interval")
    public Interval getInterval() {
        return this.interval;
    }

    public <U> BySegmentResultValueClass<U> mapResults(Function<? super T, ? extends U> mapper) {
        List mappedResults = this.results.stream().map(mapper).collect(Collectors.toList());
        return new BySegmentResultValueClass(mappedResults, this.segmentId, this.interval);
    }

    public String toString() {
        return "BySegmentResultValue{results=" + this.results + ", segmentId='" + this.segmentId + "', interval='" + this.interval + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BySegmentResultValueClass that = (BySegmentResultValueClass)o;
        if (this.interval != null ? !this.interval.equals((Object)that.interval) : that.interval != null) {
            return false;
        }
        if (this.results != null ? !this.results.equals(that.results) : that.results != null) {
            return false;
        }
        return !(this.segmentId != null ? !this.segmentId.equals(that.segmentId) : that.segmentId != null);
    }

    public int hashCode() {
        int result = this.results != null ? this.results.hashCode() : 0;
        result = 31 * result + (this.segmentId != null ? this.segmentId.hashCode() : 0);
        result = 31 * result + (this.interval != null ? this.interval.hashCode() : 0);
        return result;
    }
}

