/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor;

import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;

public class ReturnOrAwait<T> {
    private static final IntSet RANGE_SET_ONE = IntSets.singleton((int)0);
    @Nullable
    private final T retVal;
    @Nullable
    private final IntSet await;
    private final boolean awaitAll;

    private ReturnOrAwait(@Nullable T retVal, @Nullable IntSet await, boolean awaitAll) {
        this.retVal = retVal;
        this.await = await;
        this.awaitAll = awaitAll;
        if (retVal != null && await != null) {
            throw new IAE("Cannot have a value when await != null", new Object[0]);
        }
    }

    public static <T> ReturnOrAwait<T> runAgain() {
        return new ReturnOrAwait<Object>(null, IntSets.emptySet(), true);
    }

    public static <T> ReturnOrAwait<T> awaitAll(IntSet await) {
        return new ReturnOrAwait<Object>(null, await, true);
    }

    public static <T> ReturnOrAwait<T> awaitAll(int count) {
        return new ReturnOrAwait<Object>(null, ReturnOrAwait.rangeSet(count), true);
    }

    public static <T> ReturnOrAwait<T> awaitAny(IntSet await) {
        return new ReturnOrAwait<Object>(null, await, false);
    }

    public static <T> ReturnOrAwait<T> returnObject(T o) {
        return new ReturnOrAwait<T>(o, null, false);
    }

    @Nullable
    public T value() {
        if (this.isAwait()) {
            throw new ISE("No value yet", new Object[0]);
        }
        return this.retVal;
    }

    public IntSet awaitSet() {
        if (this.isReturn()) {
            throw new ISE("No await set", new Object[0]);
        }
        return this.await;
    }

    public boolean isReturn() {
        return this.await == null;
    }

    public boolean isAwait() {
        return this.await != null;
    }

    public boolean isAwaitAll() {
        return this.awaitAll;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReturnOrAwait that = (ReturnOrAwait)o;
        return this.awaitAll == that.awaitAll && Objects.equals(this.retVal, that.retVal) && Objects.equals(this.await, that.await);
    }

    public int hashCode() {
        return Objects.hash(this.retVal, this.await, this.awaitAll);
    }

    public String toString() {
        if (this.isAwait()) {
            return "await=" + (this.awaitAll ? "all" : "any") + this.await;
        }
        return "return=" + this.retVal;
    }

    private static IntSet rangeSet(int count) {
        if (count == 0) {
            return IntSets.emptySet();
        }
        if (count == 1) {
            return RANGE_SET_ONE;
        }
        return IntSets.fromTo((int)0, (int)count);
    }
}

