/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.data.input.impl.NewSpatialDimensionSchema;
import org.apache.druid.data.input.impl.SpatialDimensionSchema;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.parsers.ParserUtils;

public class DimensionsSpec {
    public static final String PARAMETER_FORCE_TIME_SORT = "forceSegmentSortByTime";
    public static final String WARNING_NON_TIME_SORT_ORDER = StringUtils.format("Warning: support for segments not sorted by[%s] is experimental. Such segments are not readable by older version of Druid, and certain queries cannot run on them. See https://druid.apache.org/docs/latest/ingestion/partitioning#sorting for details before setting %s to[false].", "__time", "forceSegmentSortByTime");
    public static final boolean DEFAULT_FORCE_TIME_SORT = true;
    private final List<DimensionSchema> dimensions;
    private final Set<String> dimensionExclusions;
    private final Map<String, DimensionSchema> dimensionSchemaMap;
    private final boolean includeAllDimensions;
    private final Boolean forceSegmentSortByTime;
    private final boolean useSchemaDiscovery;
    public static final DimensionsSpec EMPTY = new DimensionsSpec(null, null, null, false, null, false);

    public static List<DimensionSchema> getDefaultSchemas(List<String> dimNames) {
        return DimensionsSpec.getDefaultSchemas(dimNames, DimensionSchema.MultiValueHandling.ofDefault());
    }

    public static List<DimensionSchema> getDefaultSchemas(List<String> dimNames, DimensionSchema.MultiValueHandling multiValueHandling) {
        return dimNames.stream().map(input -> new StringDimensionSchema((String)input, multiValueHandling, (Boolean)true)).collect(Collectors.toList());
    }

    public static DimensionSchema convertSpatialSchema(SpatialDimensionSchema spatialSchema) {
        return new NewSpatialDimensionSchema(spatialSchema.getDimName(), spatialSchema.getDims());
    }

    public static Builder builder() {
        return new Builder();
    }

    public DimensionsSpec(List<DimensionSchema> dimensions) {
        this(dimensions, null, null, false, null, null);
    }

    @JsonCreator
    private DimensionsSpec(@JsonProperty(value="dimensions") List<DimensionSchema> dimensions, @JsonProperty(value="dimensionExclusions") List<String> dimensionExclusions, @Deprecated @JsonProperty(value="spatialDimensions") List<SpatialDimensionSchema> spatialDimensions, @JsonProperty(value="includeAllDimensions") boolean includeAllDimensions, @JsonProperty(value="useSchemaDiscovery") Boolean useSchemaDiscovery, @JsonProperty(value="forceSegmentSortByTime") Boolean forceSegmentSortByTime) {
        this.dimensions = dimensions == null ? new ArrayList<DimensionSchema>() : Lists.newArrayList(dimensions);
        this.dimensionExclusions = dimensionExclusions == null ? new HashSet<String>() : Sets.newHashSet(dimensionExclusions);
        ArrayList<SpatialDimensionSchema> spatialDims = spatialDimensions == null ? new ArrayList<SpatialDimensionSchema>() : spatialDimensions;
        this.verify(spatialDims);
        this.dimensionSchemaMap = new HashMap<String, DimensionSchema>();
        for (DimensionSchema schema : this.dimensions) {
            this.dimensionSchemaMap.put(schema.getName(), schema);
        }
        for (SpatialDimensionSchema spatialSchema : spatialDims) {
            DimensionSchema newSchema = DimensionsSpec.convertSpatialSchema(spatialSchema);
            this.dimensions.add(newSchema);
            this.dimensionSchemaMap.put(newSchema.getName(), newSchema);
        }
        this.includeAllDimensions = includeAllDimensions;
        this.useSchemaDiscovery = useSchemaDiscovery != null && useSchemaDiscovery != false;
        this.forceSegmentSortByTime = forceSegmentSortByTime;
    }

    @JsonProperty
    public List<DimensionSchema> getDimensions() {
        return this.dimensions;
    }

    @JsonProperty
    public Set<String> getDimensionExclusions() {
        return this.dimensionExclusions;
    }

    @JsonProperty
    public boolean isIncludeAllDimensions() {
        return this.includeAllDimensions;
    }

    @JsonProperty
    public boolean useSchemaDiscovery() {
        return this.useSchemaDiscovery;
    }

    @JsonProperty(value="forceSegmentSortByTime")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean isForceSegmentSortByTimeConfigured() {
        return this.forceSegmentSortByTime;
    }

    public boolean isForceSegmentSortByTime() {
        if (this.forceSegmentSortByTime != null) {
            return this.forceSegmentSortByTime;
        }
        return true;
    }

    @Deprecated
    @JsonIgnore
    public List<SpatialDimensionSchema> getSpatialDimensions() {
        Iterable filteredList = Iterables.filter(this.dimensions, NewSpatialDimensionSchema.class);
        Iterable transformedList = Iterables.transform((Iterable)filteredList, (Function)new Function<NewSpatialDimensionSchema, SpatialDimensionSchema>(){

            @Nullable
            public SpatialDimensionSchema apply(NewSpatialDimensionSchema input) {
                return new SpatialDimensionSchema(input.getName(), input.getDims());
            }
        });
        return Lists.newArrayList((Iterable)transformedList);
    }

    @JsonIgnore
    public List<String> getDimensionNames() {
        return Lists.transform(this.dimensions, (Function)new Function<DimensionSchema, String>(){

            public String apply(DimensionSchema input) {
                return input.getName();
            }
        });
    }

    public DimensionSchema getSchema(String dimension) {
        return this.dimensionSchemaMap.get(dimension);
    }

    public boolean hasFixedDimensions() {
        return this.dimensions != null && !this.dimensions.isEmpty() && !this.useSchemaDiscovery && !this.includeAllDimensions;
    }

    public DimensionsSpec withDimensions(List<DimensionSchema> dims) {
        return new DimensionsSpec(dims, (List<String>)ImmutableList.copyOf(this.dimensionExclusions), null, this.includeAllDimensions, this.useSchemaDiscovery, this.forceSegmentSortByTime);
    }

    public DimensionsSpec withDimensionExclusions(Set<String> dimExs) {
        return new DimensionsSpec(this.dimensions, (List<String>)ImmutableList.copyOf((Collection)Sets.union(this.dimensionExclusions, dimExs)), null, this.includeAllDimensions, this.useSchemaDiscovery, this.forceSegmentSortByTime);
    }

    @Deprecated
    public DimensionsSpec withSpatialDimensions(List<SpatialDimensionSchema> spatials) {
        return new DimensionsSpec(this.dimensions, (List<String>)ImmutableList.copyOf(this.dimensionExclusions), spatials, this.includeAllDimensions, this.useSchemaDiscovery, this.forceSegmentSortByTime);
    }

    private void verify(List<SpatialDimensionSchema> spatialDimensions) {
        List<String> dimNames = this.getDimensionNames();
        Preconditions.checkArgument((boolean)Sets.intersection(this.dimensionExclusions, (Set)Sets.newHashSet(dimNames)).isEmpty(), (Object)"dimensions and dimensions exclusions cannot overlap");
        List spatialDimNames = Lists.transform(spatialDimensions, (Function)new Function<SpatialDimensionSchema, String>(){

            public String apply(SpatialDimensionSchema input) {
                return input.getDimName();
            }
        });
        ParserUtils.validateFields(Iterables.concat(dimNames, (Iterable)spatialDimNames));
        ParserUtils.validateFields(this.dimensionExclusions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimensionsSpec that = (DimensionsSpec)o;
        return this.includeAllDimensions == that.includeAllDimensions && this.useSchemaDiscovery == that.useSchemaDiscovery && Objects.equals(this.dimensions, that.dimensions) && Objects.equals(this.dimensionExclusions, that.dimensionExclusions) && Objects.equals(this.dimensionSchemaMap, that.dimensionSchemaMap) && Objects.equals(this.forceSegmentSortByTime, that.forceSegmentSortByTime);
    }

    public int hashCode() {
        return Objects.hash(this.dimensions, this.dimensionExclusions, this.dimensionSchemaMap, this.includeAllDimensions, this.forceSegmentSortByTime, this.useSchemaDiscovery);
    }

    public String toString() {
        return "DimensionsSpec{dimensions=" + this.dimensions + ", dimensionExclusions=" + this.dimensionExclusions + ", includeAllDimensions=" + this.includeAllDimensions + ", useSchemaDiscovery=" + this.useSchemaDiscovery + (String)(this.forceSegmentSortByTime != null ? ", forceSegmentSortByTime=" + this.forceSegmentSortByTime : "") + "}";
    }

    public static final class Builder {
        private List<DimensionSchema> dimensions;
        private List<String> dimensionExclusions;
        private List<SpatialDimensionSchema> spatialDimensions;
        private boolean includeAllDimensions;
        private boolean useSchemaDiscovery;
        private Boolean forceSegmentSortByTime;

        public Builder setDimensions(List<DimensionSchema> dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public Builder setDefaultSchemaDimensions(List<String> dimensions) {
            this.dimensions = DimensionsSpec.getDefaultSchemas(dimensions);
            return this;
        }

        public Builder setDimensionExclusions(List<String> dimensionExclusions) {
            this.dimensionExclusions = dimensionExclusions;
            return this;
        }

        @Deprecated
        public Builder setSpatialDimensions(List<SpatialDimensionSchema> spatialDimensions) {
            this.spatialDimensions = spatialDimensions;
            return this;
        }

        public Builder setIncludeAllDimensions(boolean includeAllDimensions) {
            this.includeAllDimensions = includeAllDimensions;
            return this;
        }

        public Builder useSchemaDiscovery(boolean useSchemaDiscovery) {
            this.useSchemaDiscovery = useSchemaDiscovery;
            return this;
        }

        public Builder setForceSegmentSortByTime(Boolean forceSegmentSortByTime) {
            this.forceSegmentSortByTime = forceSegmentSortByTime;
            return this;
        }

        public DimensionsSpec build() {
            return new DimensionsSpec(this.dimensions, this.dimensionExclusions, this.spatialDimensions, this.includeAllDimensions, this.useSchemaDiscovery, this.forceSegmentSortByTime);
        }
    }
}

